/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.openide.util.NbBundle;

public class NewConnectionPanel
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    DatabaseConnection con;
    boolean result = false;
    Dialog dialog = null;
    JComboBox drvfield;
    JTextField dbfield;
    JTextField userfield;
    JTextField drvClassField;
    JPasswordField pwdfield;
    JCheckBox rememberbox;

    public NewConnectionPanel(Vector drivervec, String driver, String database, String loginname) {
        this(drivervec, new DatabaseConnection(driver, database, loginname, null));
    }

    public NewConnectionPanel(Vector drivervec, DatabaseConnection xcon) {
        this.con = xcon;
        try {
            this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constr = new GridBagConstraints();
            this.setLayout(layout);
            ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            JLabel label = new JLabel(bundle.getString("NewConnectionDriverName"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionDriverName_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionDriverNameA11yDesc"));
            constr.anchor = 17;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 0;
            layout.setConstraints(label, constr);
            this.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            this.drvfield = new JComboBox(drivervec);
            this.drvfield.setEditable(false);
            this.drvfield.setToolTipText(bundle.getString("ACS_NewConnectionDriverNameComboBoxA11yDesc"));
            this.drvfield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionDriverNameComboBoxA11yName"));
            label.setLabelFor(this.drvfield);
            this.drvfield.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    Object drv = combo.getSelectedItem();
                    String dbprefix = null;
                    String driver = null;
                    if (drv != null && drv instanceof DatabaseDriver) {
                        dbprefix = ((DatabaseDriver)drv).getDatabasePrefix();
                        driver = ((DatabaseDriver)drv).getURL();
                    }
                    if (dbprefix != null) {
                        NewConnectionPanel.this.dbfield.setText(dbprefix);
                    }
                    if (driver != null) {
                        NewConnectionPanel.this.drvClassField.setText(driver);
                    }
                }
            });
            layout.setConstraints(this.drvfield, constr);
            this.add(this.drvfield);
            label = new JLabel(bundle.getString("NewConnectionDriverClass"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionDriverClass_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionDriverClassA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 1;
            layout.setConstraints(label, constr);
            this.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 1;
            constr.insets = new Insets(2, 2, 2, 2);
            this.drvClassField = new JTextField(35);
            this.drvClassField.setText(xcon.getDriver());
            this.drvClassField.setEditable(false);
            this.drvClassField.setToolTipText(bundle.getString("ACS_NewConnectionDriverClassComboBoxA11yDesc"));
            this.drvClassField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionDriverClassComboBoxA11yName"));
            label.setLabelFor(this.drvClassField);
            layout.setConstraints(this.drvClassField, constr);
            this.add(this.drvClassField);
            label = new JLabel(bundle.getString("NewConnectionDatabaseURL"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionDatabaseURL_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionDatabaseURLA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 2;
            layout.setConstraints(label, constr);
            this.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 2;
            constr.insets = new Insets(2, 2, 2, 2);
            this.dbfield = new JTextField(35);
            this.dbfield.setText(xcon.getDatabase());
            this.dbfield.setToolTipText(bundle.getString("ACS_NewConnectionDatabaseURLTextFieldA11yDesc"));
            this.dbfield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionDatabaseURLTextFieldA11yName"));
            label.setLabelFor(this.dbfield);
            layout.setConstraints(this.dbfield, constr);
            this.add(this.dbfield);
            String drv = xcon.getDriver();
            String drvname = xcon.getDriverName();
            if (drv != null && drvname != null) {
                int i = 0;
                while (i < drivervec.size()) {
                    DatabaseDriver dbdrv = (DatabaseDriver)drivervec.elementAt(i);
                    if (dbdrv.getURL().equals(drv) && dbdrv.getName().equals(drvname)) {
                        this.drvfield.setSelectedIndex(i);
                    }
                    ++i;
                }
            }
            label = new JLabel(bundle.getString("NewConnectionUserName"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionUserName_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionUserNameA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 3;
            layout.setConstraints(label, constr);
            this.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 3;
            constr.insets = new Insets(2, 2, 2, 2);
            this.userfield = new JTextField(35);
            this.userfield.setText(xcon.getUser());
            this.userfield.setToolTipText(bundle.getString("ACS_NewConnectionUserNameTextFieldA11yDesc"));
            this.userfield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionUserNameTextFieldA11yName"));
            label.setLabelFor(this.userfield);
            layout.setConstraints(this.userfield, constr);
            this.add(this.userfield);
            label = new JLabel(bundle.getString("NewConnectionPassword"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionPassword_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionPasswordA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 4;
            layout.setConstraints(label, constr);
            this.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 4;
            constr.insets = new Insets(2, 2, 2, 2);
            this.pwdfield = new JPasswordField(35);
            this.pwdfield.setToolTipText(bundle.getString("ACS_NewConnectionPasswordTextFieldA11yDesc"));
            this.pwdfield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionPasswordTextFieldA11yName"));
            label.setLabelFor(this.pwdfield);
            layout.setConstraints(this.pwdfield, constr);
            this.add(this.pwdfield);
            this.rememberbox = new JCheckBox(bundle.getString("NewConnectionRememberPassword"));
            this.rememberbox.setMnemonic(bundle.getString("NewConnectionRememberPassword_Mnemonic").charAt(0));
            this.rememberbox.setToolTipText(bundle.getString("ACS_NewConnectionRememberPasswordA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 1;
            constr.gridy = 5;
            layout.setConstraints(this.rememberbox, constr);
            this.add(this.rememberbox);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }

    String getSelectedDriver() {
        int idx = this.drvfield.getSelectedIndex();
        String drvval = idx != -1 ? ((DatabaseDriver)this.drvfield.getItemAt(idx)).getURL() : (String)this.drvfield.getSelectedItem();
        return drvval;
    }

    public void setConnectionInfo() {
        this.con.setDriver(this.getSelectedDriver());
        this.con.setDatabase(this.dbfield.getText());
        this.con.setUser(this.userfield.getText());
        String tmppwd = new String(this.pwdfield.getPassword());
        String pwd = tmppwd.length() > 0 ? tmppwd : null;
        this.con.setPassword(pwd);
        this.con.setRememberPassword(this.rememberbox.isSelected());
    }

    public DBConnection getConnection() {
        return this.con;
    }

    public String getDriver() {
        return this.getSelectedDriver();
    }

    public String getDatabase() {
        return this.dbfield.getText();
    }

    public String getUser() {
        return this.userfield.getText();
    }

    public String getPassword() {
        String tmppwd = new String(this.pwdfield.getPassword());
        String pword = tmppwd.length() > 0 ? tmppwd : null;
        return pword;
    }

    public boolean rememberPassword() {
        return this.rememberbox.isSelected();
    }

    public String getTitle() {
        return bundle.getString("NewConnectionDialogTitle");
    }
}

