/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class TestDriverDialog {
    DatabaseConnection con;
    boolean result = false;
    Dialog dialog = null;
    JTextField dbfield;
    JTextField userfield;
    JPasswordField pwdfield;
    static ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");

    public TestDriverDialog(String driver, String database, String loginname) {
        this(new DatabaseConnection(driver, database, loginname, null));
    }

    public TestDriverDialog(DatabaseConnection xcon) {
        this.con = xcon;
        try {
            JPanel pane = new JPanel();
            pane.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constr = new GridBagConstraints();
            pane.setLayout(layout);
            JLabel driverlabel = new JLabel(bundle.getString("NewConnectionDriverClass"));
            driverlabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionDriverClassA11yDesc"));
            constr.anchor = 17;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 0;
            layout.setConstraints(driverlabel, constr);
            pane.add(driverlabel);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            JLabel label = new JLabel(this.con.getDriver());
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionDriverClassA11yDesc"));
            driverlabel.setLabelFor(label);
            layout.setConstraints(label, constr);
            pane.add(label);
            label = new JLabel(bundle.getString("NewConnectionDatabaseURL"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionDatabaseURL_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionDatabaseURLA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 1;
            layout.setConstraints(label, constr);
            pane.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 1;
            constr.insets = new Insets(2, 2, 2, 2);
            this.dbfield = new JTextField(35);
            this.dbfield.setText(xcon.getDatabase());
            this.dbfield.setToolTipText(bundle.getString("ACS_NewConnectionDatabaseURLTextFieldA11yDesc"));
            this.dbfield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionDatabaseURLTextFieldA11yName"));
            label.setLabelFor(this.dbfield);
            layout.setConstraints(this.dbfield, constr);
            pane.add(this.dbfield);
            label = new JLabel(bundle.getString("NewConnectionUserName"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionUserName_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionUserNameA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 2;
            layout.setConstraints(label, constr);
            pane.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 2;
            constr.insets = new Insets(2, 2, 2, 2);
            this.userfield = new JTextField(35);
            this.userfield.setText(xcon.getUser());
            this.userfield.setToolTipText(bundle.getString("ACS_NewConnectionUserNameTextFieldA11yDesc"));
            this.userfield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionUserNameTextFieldA11yName"));
            label.setLabelFor(this.userfield);
            layout.setConstraints(this.userfield, constr);
            pane.add(this.userfield);
            label = new JLabel(bundle.getString("NewConnectionPassword"));
            label.setDisplayedMnemonic(bundle.getString("NewConnectionPassword_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NewConnectionPasswordA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 3;
            layout.setConstraints(label, constr);
            pane.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.gridx = 1;
            constr.gridy = 3;
            constr.insets = new Insets(2, 2, 2, 2);
            this.pwdfield = new JPasswordField(35);
            this.pwdfield.setToolTipText(bundle.getString("ACS_NewConnectionPasswordTextFieldA11yDesc"));
            this.pwdfield.getAccessibleContext().setAccessibleName(bundle.getString("ACS_NewConnectionPasswordTextFieldA11yName"));
            label.setLabelFor(this.pwdfield);
            layout.setConstraints(this.pwdfield, constr);
            pane.add(this.pwdfield);
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == NotifyDescriptor.OK_OPTION) {
                        TestDriverDialog.this.ok();
                    } else {
                        TestDriverDialog.this.cancel();
                    }
                    ((Component)TestDriverDialog.this.dialog).setVisible(false);
                    TestDriverDialog.this.dialog.dispose();
                }
            };
            pane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TestDriverDialogA11yDesc"));
            DialogDescriptor descriptor = new DialogDescriptor((Object)pane, bundle.getString("TestDriverDialogTitle") + " - " + xcon.getDriverName(), true, listener);
            this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            this.dialog.setResizable(false);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }

    protected void ok() {
        try {
            String drvval = this.con.getDriver();
            Class.forName(this.con.getDriver());
            this.con.setDriver(drvval);
            this.con.setDatabase(this.dbfield.getText());
            this.con.setUser(this.userfield.getText());
            String tmppwd = new String(this.pwdfield.getPassword());
            String pwd = tmppwd.length() > 0 ? tmppwd : null;
            this.con.setPassword(pwd);
            this.result = true;
        }
        catch (ClassNotFoundException ex) {
            this.result = false;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("TestDriverNoDriverClass"), 0));
        }
    }

    protected void cancel() {
        this.result = false;
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.con.getDatabase(), this.con.getUser(), this.con.getPassword());
    }

    public boolean run() {
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(true);
        }
        return this.result;
    }
}

