/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.dlg.UnsupportedDatabaseDialog;
import org.netbeans.modules.db.explorer.infos.ConnectionOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.nodes.Node;

public class ConnectionNodeInfo
extends DatabaseNodeInfo
implements ConnectionOperations {
    static final long serialVersionUID = -8322295510950137669L;

    public void connect(String dbsys) throws DatabaseException {
        String drvurl = this.getDriver();
        String dburl = this.getDatabase();
        Object schema = null;
        try {
            Specification spec;
            if (drvurl.startsWith("com.pointbase.jdbc.jdbcUniversalDriver")) {
                Node[] n = this.getParent().getNode().getChildren().getNodes();
                int i = 0;
                while (i < n.length) {
                    ConnectionNodeInfo cinfo;
                    if (n[i] instanceof ConnectionNode && (cinfo = (ConnectionNodeInfo)((ConnectionNode)n[i]).getInfo()).getDriver().startsWith("com.pointbase.jdbc.jdbcUniversalDriver") && (!cinfo.getDatabase().equals(dburl) || !cinfo.getUser().equals(this.getUser())) && cinfo.getConnection() != null) {
                        throw new Exception(DatabaseNodeInfo.bundle.getString("EXC_PBConcurrentConn"));
                    }
                    ++i;
                }
            }
            Properties dbprops = this.getConnectionProperties();
            DatabaseConnection con = new DatabaseConnection(drvurl, dburl, this.getUser(), this.getPassword());
            Connection connection = con.createJDBCConnection();
            SpecificationFactory factory = (SpecificationFactory)this.getSpecificationFactory();
            if (dbsys != null) {
                spec = (Specification)factory.createSpecification(con, dbsys, connection);
            } else {
                this.setReadOnly(false);
                spec = (Specification)factory.createSpecification(con, connection);
            }
            this.put("dbproduct", spec.getProperties().get("dbproduct"));
            this.setSpecification(spec);
            DriverSpecification drvSpec = factory.createDriverSpecification(spec.getMetaData().getDriverName().trim());
            if (spec.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                drvSpec.setMetaData(connection.getMetaData());
            } else {
                drvSpec.setMetaData(spec.getMetaData());
            }
            drvSpec.setCatalog(connection.getCatalog());
            drvSpec.setSchema(this.getSchema());
            this.setDriverSpecification(drvSpec);
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException e) {
            UnsupportedDatabaseDialog dlg = new UnsupportedDatabaseDialog();
            dlg.show();
            this.setReadOnly(false);
            switch (dlg.getResult()) {
                case 1: {
                    this.connect("GenericDatabaseSystem");
                    break;
                }
                case 2: {
                    this.connectReadOnly();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void connect() throws DatabaseException {
        this.connect(null);
    }

    public void connectReadOnly() throws DatabaseException {
        this.setReadOnly(true);
        this.connect("GenericDatabaseSystem");
    }

    public void disconnect() throws DatabaseException {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                connection.close();
                this.setConnection(null);
            }
            catch (Exception exc) {
                this.setConnection(null);
                String message = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_ConnectionIsBroken"), exc.getMessage());
                throw new DatabaseException(message);
            }
        }
    }

    public void delete() throws IOException {
        try {
            this.disconnect();
            Vector cons = RootNode.getOption().getConnections();
            DatabaseConnection cinfo = (DatabaseConnection)this.getDatabaseConnection();
            if (cons.contains(cinfo)) {
                cons.remove(cinfo);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public Object put(Object key, Object obj) {
        if (key.equals("user") || key.equals("driver") || key.equals("db") || key.equals("schema")) {
            String oldVal = (String)this.get(key);
            String newVal = (String)obj;
            this.updateConnection((String)key, oldVal, newVal);
        }
        return super.put(key, obj);
    }

    private void updateConnection(String key, String oldVal, String newVal) {
        DatabaseOption option = RootNode.getOption();
        Vector cons = option.getConnections();
        Enumeration enu = cons.elements();
        DBConnection infoConn = this.getDatabaseConnection();
        int idx = cons.indexOf(infoConn);
        if (idx >= 0) {
            DatabaseConnection connFromList = (DatabaseConnection)cons.elementAt(idx);
            if (key.equals("schema")) {
                connFromList.setSchema(newVal);
            } else if (key.equals("user")) {
                connFromList.setUser(newVal);
            } else if (key.equals("driver")) {
                connFromList.setDriver(newVal);
            } else if (key.equals("db")) {
                connFromList.setDatabase(newVal);
            }
        }
        this.setName(infoConn.getName());
    }
}

