/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverOperations;
import org.netbeans.modules.db.explorer.nodes.RootNode;

public class DriverListNodeInfo
extends DatabaseNodeInfo
implements DriverOperations {
    static final long serialVersionUID = -7948529055260667590L;

    protected void initChildren(Vector children) throws DatabaseException {
        Vector cons = RootNode.getOption().getAvailableDrivers();
        if (cons != null) {
            try {
                Enumeration cons_e = cons.elements();
                while (cons_e.hasMoreElements()) {
                    DatabaseDriver drv = (DatabaseDriver)cons_e.nextElement();
                    DriverNodeInfo chinfo = (DriverNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "driver");
                    if (chinfo != null && drv != null) {
                        chinfo.setDatabaseDriver(drv);
                        children.add(chinfo);
                        continue;
                    }
                    String message = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_Driver"), drv.toString());
                    throw new Exception(message);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addDriver(DatabaseDriver drv) throws DatabaseException {
        DatabaseOption option = RootNode.getOption();
        Vector drvs = option.getAvailableDrivers();
        if (drvs.contains(drv)) {
            String message = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_DriverAlreadyExists"), drv.toString());
            throw new DatabaseException(message);
        }
        drvs.add(drv);
        DatabaseNodeChildren chld = (DatabaseNodeChildren)this.getNode().getChildren();
        DriverNodeInfo ninfo = (DriverNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "driver");
        ninfo.setDatabaseDriver(drv);
        chld.createSubnode(ninfo, true);
    }
}

