/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverListNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;

public class DriverNodeInfo
extends DriverListNodeInfo {
    static final long serialVersionUID = 6994829681095273161L;

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.get("dbdriver");
    }

    public void setDatabaseDriver(DatabaseDriver drv) {
        this.put("name", drv.getName());
        this.put("url", drv.getURL());
        this.put("prefix", drv.getDatabasePrefix());
        this.put("adaptorClass", drv.getDatabaseAdaptor());
        this.put("dbdriver", drv);
    }

    public void delete() throws IOException {
        try {
            DatabaseDriver drv = this.getDatabaseDriver();
            Vector drvs = RootNode.getOption().getAvailableDrivers();
            int idx = drvs.indexOf(drv);
            if (idx == -1) {
                String message = MessageFormat.format(DatabaseNodeInfo.bundle.getString("EXC_DriverNotFound"), drv.toString());
                throw new DatabaseException(message);
            }
            drvs.removeElementAt(idx);
            this.getParent().refreshChildren();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

