/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.IndexNodeInfo;

public class IndexListNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = 5809643799834921044L;

    public void initChildren(Vector children) throws DatabaseException {
        try {
            String table = (String)this.get("table");
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getIndexInfo(table, false, false);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashSet<String> ixmap = new HashSet<String>();
                HashMap rset = new HashMap();
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    if (rset.get(new Integer(6)) != null) {
                        IndexNodeInfo info = (IndexNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "index", rset);
                        if (info != null) {
                            if (!ixmap.contains(info.getName())) {
                                ixmap.add(info.getName());
                                info.put("index", info.getName());
                                children.add(info);
                            }
                        } else {
                            throw new Exception(DatabaseNodeInfo.bundle.getString("EXC_UnableToCreateIndexNodeInfo"));
                        }
                    }
                    rset.clear();
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void addIndex(String name) throws DatabaseException {
        try {
            String table = (String)this.get("table");
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getIndexInfo(table, false, false);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashMap rset = new HashMap();
                IndexNodeInfo info = null;
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    String findex = (String)rset.get(new Integer(6));
                    if (findex != null && findex.equalsIgnoreCase(name)) {
                        info = (IndexNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "index", rset);
                    }
                    rset.clear();
                }
                rs.close();
                if (info != null) {
                    ((DatabaseNodeChildren)this.getNode().getChildren()).createSubnode(info, true);
                }
                this.getParent().refreshChildren();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DatabaseException(e.getMessage());
        }
    }
}

