/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.DropIndex;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class IndexNodeInfo
extends TableNodeInfo {
    static final long serialVersionUID = -8633867970381524742L;

    public void initChildren(Vector children) throws DatabaseException {
        try {
            String table = (String)this.get("table");
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getIndexInfo(table, false, false);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                Hashtable ixmap = new Hashtable();
                HashMap rset = new HashMap();
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    String ixname = (String)this.get("index");
                    DatabaseNodeInfo info = DatabaseNodeInfo.createNodeInfo(this, "indexcolumn", rset);
                    String newixname = (String)info.get("ixname");
                    if (ixname != null && newixname != null && newixname.equals(ixname)) {
                        String way = info.get("ord") instanceof Boolean ? "A" : (String)info.get("ord");
                        if (way == null) {
                            way = "A";
                        }
                        info.put("iconbase", info.get("iconbase" + way));
                        if (info != null) {
                            children.add(info);
                        } else {
                            rs.close();
                            throw new Exception(DatabaseNodeInfo.bundle.getString("EXC_UnableToCreateIndexNodeInfo"));
                        }
                    }
                    rset.clear();
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void refreshChildren() throws DatabaseException {
        Vector charr = new Vector();
        this.put("children", charr);
        this.initChildren(charr);
        try {
            Node[] subTreeNodes = new Node[charr.size()];
            DatabaseNodeChildren children = (DatabaseNodeChildren)this.getNode().getChildren();
            children.remove(children.getNodes());
            int i = 0;
            while (i < charr.size()) {
                subTreeNodes[i] = children.createNode((DatabaseNodeInfo)charr.elementAt(i));
                ++i;
            }
            children.add(subTreeNodes);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void delete() throws IOException {
        try {
            String code = this.getCode();
            String table = (String)this.get("table");
            Specification spec = (Specification)this.getSpecification();
            DropIndex cmd = spec.createCommandDropIndex(this.getName());
            cmd.setTableName(table);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
            this.getParent("table").refreshChildren();
        }
        catch (DDLException e) {
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

