/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.ConnectionOwnerOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;

public class RootNodeInfo
extends DatabaseNodeInfo
implements ConnectionOwnerOperations {
    static final long serialVersionUID = -8079386805046070315L;

    public void initChildren(Vector children) throws DatabaseException {
        try {
            FileObject adaptorsFolder;
            DataFolder dbdo;
            Repository r;
            FileSystem rfs;
            FileObject rootFolder;
            FileObject databaseFileObject;
            Vector cons = RootNode.getOption().getConnections();
            if (cons != null) {
                Enumeration en = cons.elements();
                while (en.hasMoreElements()) {
                    DBConnection cinfo = (DBConnection)en.nextElement();
                    ConnectionNodeInfo ninfo = (ConnectionNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "connection");
                    ninfo.setUser(cinfo.getUser());
                    ninfo.setDatabase(cinfo.getDatabase());
                    ninfo.setSchema(cinfo.getSchema());
                    ninfo.setName(cinfo.getName());
                    ninfo.setDatabaseConnection(cinfo);
                    children.add(ninfo);
                }
            }
            if ((databaseFileObject = (rootFolder = (rfs = (r = Repository.getDefault()).getDefaultFileSystem()).getRoot()).getFileObject("Database")) != null && (dbdo = DataFolder.findFolder((FileObject)(adaptorsFolder = databaseFileObject.getFileObject("Adaptors")))) != null) {
                children.add(dbdo.getNodeDelegate());
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void refreshChildren() throws DatabaseException {
    }

    public void addConnection(DBConnection cinfo) throws DatabaseException {
        this.getChildren();
        Vector cons = RootNode.getOption().getConnections();
        if (cons.contains(cinfo)) {
            throw new DatabaseException(DatabaseNodeInfo.bundle.getString("EXC_ConnectionAlreadyExists"));
        }
        try {
            DatabaseNode node = this.getNode();
            DatabaseNodeChildren children = (DatabaseNodeChildren)node.getChildren();
            ConnectionNodeInfo ninfo = (ConnectionNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "connection");
            ninfo.setName(cinfo.getName());
            ninfo.setUser(cinfo.getUser());
            ninfo.setDatabase(cinfo.getDatabase());
            ninfo.setSchema(cinfo.getSchema());
            ninfo.setDatabaseConnection(cinfo);
            cons.add(cinfo);
            DatabaseNode cnode = children.createSubnode(ninfo, true);
            ((ConnectionNodeInfo)cnode.getInfo()).connect();
        }
        catch (Exception e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            throw new DatabaseException(e.getMessage());
        }
    }

    public void addOrConnectConnection(DBConnection conn) throws DatabaseException {
        this.getChildren();
        Vector cons = RootNode.getOption().getConnections();
        if (cons.contains(conn)) {
            ConnectionNode connNode = (ConnectionNode)this.getNode().getChildren().findChild(conn.getName());
            if (connNode != null && ((ConnectionNodeInfo)connNode.getInfo()).getConnection() == null) {
                ((ConnectionNodeInfo)connNode.getInfo()).setDatabaseConnection(conn);
                ((ConnectionNodeInfo)connNode.getInfo()).connect();
            }
        } else {
            this.addConnection(conn);
        }
    }

    public void addOrSetConnection(DBConnection conn) throws DatabaseException {
        this.getChildren();
        Vector cons = RootNode.getOption().getConnections();
        if (cons.contains(conn)) {
            ConnectionNode connNode = (ConnectionNode)this.getNode().getChildren().findChild(conn.getName());
            if (connNode != null && ((ConnectionNodeInfo)connNode.getInfo()).getConnection() == null) {
                ((ConnectionNodeInfo)connNode.getInfo()).setDatabaseConnection(conn);
            }
        } else {
            DatabaseNode node = this.getNode();
            DatabaseNodeChildren children = (DatabaseNodeChildren)node.getChildren();
            ConnectionNodeInfo ninfo = (ConnectionNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "connection");
            ninfo.setDatabaseConnection(conn);
            ninfo.setSchema(conn.getSchema());
            cons.add(conn);
            DatabaseNode cnode = children.createSubnode(ninfo, true);
        }
    }
}

