/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableOwnerOperations;

public class TableListNodeInfo
extends DatabaseNodeInfo
implements TableOwnerOperations {
    static final long serialVersionUID = -6156362126513404875L;

    protected void initChildren(Vector children) throws DatabaseException {
        try {
            String[] types = new String[]{"TABLE"};
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getTables("%", types);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashMap rset = new HashMap();
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    DatabaseNodeInfo info = DatabaseNodeInfo.createNodeInfo(this, "table", rset);
                    if (info == null) {
                        throw new Exception(DatabaseNodeInfo.bundle.getString("EXC_UnableToCreateNodeInformationForTable"));
                    }
                    info.put("table", info.getName());
                    children.add(info);
                    rset.clear();
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void addTable(String tname) throws DatabaseException {
        try {
            String[] types = new String[]{"TABLE", "BASE"};
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getTables(tname, types);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashMap rset = new HashMap();
                rs.next();
                rset = drvSpec.getRow();
                if (rset == null) {
                    throw new NullPointerException();
                }
                DatabaseNodeInfo info = DatabaseNodeInfo.createNodeInfo(this, "table", rset);
                rset.clear();
                rs.close();
                if (info == null) {
                    throw new Exception(DatabaseNodeInfo.bundle.getString("EXC_UnableToCreateNodeInformationForTable"));
                }
                info.put("table", info.getName());
                this.refreshChildren();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public TableNodeInfo getChildrenTableInfo(TableNodeInfo info) {
        String scode = info.getCode();
        String sname = info.getName();
        try {
            Enumeration enu = this.getChildren().elements();
            while (enu.hasMoreElements()) {
                TableNodeInfo elem = (TableNodeInfo)enu.nextElement();
                if (!elem.getCode().equals(scode) || !elem.getName().equals(sname)) continue;
                return elem;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }
}

