/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.CommentTable;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.ForeignKeyListNodeInfo;
import org.netbeans.modules.db.explorer.infos.IndexListNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class TableNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = -632875098783935367L;

    public void initChildren(Vector children) throws DatabaseException {
        this.initChildren(children, null);
    }

    private void initChildren(Vector children, String columnname) throws DatabaseException {
        try {
            HashMap rset;
            String table = (String)this.get("table");
            DriverSpecification drvSpec = this.getDriverSpecification();
            Hashtable<String, DatabaseNodeInfo> ihash = new Hashtable<String, DatabaseNodeInfo>();
            drvSpec.getPrimaryKeys(table);
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                HashMap rset2 = new HashMap();
                while (rs.next()) {
                    rset2 = drvSpec.getRow();
                    DatabaseNodeInfo iinfo = DatabaseNodeInfo.createNodeInfo(this, "pcolumn", rset2);
                    String iname = (String)iinfo.get("name");
                    ihash.put(iname, iinfo);
                    rset2.clear();
                }
                rs.close();
            }
            Hashtable<String, DatabaseNodeInfo> ixhash = new Hashtable<String, DatabaseNodeInfo>();
            drvSpec.getIndexInfo(table, true, false);
            rs = drvSpec.getResultSet();
            if (rs != null) {
                rset = new HashMap();
                while (rs.next()) {
                    rset = drvSpec.getRow();
                    if (rset.get(new Integer(9)) == null) continue;
                    DatabaseNodeInfo iinfo = DatabaseNodeInfo.createNodeInfo(this, "icolumn", rset);
                    String iname = (String)iinfo.get("name");
                    ixhash.put(iname, iinfo);
                    rset.clear();
                }
                rs.close();
            }
            drvSpec.getColumns(table, columnname);
            rs = drvSpec.getResultSet();
            if (rs != null) {
                rset = new HashMap();
                while (rs.next()) {
                    DatabaseNodeInfo tempInfo;
                    DatabaseNodeInfo nfo;
                    rset = drvSpec.getRow();
                    String cname = (String)rset.get(new Integer(4));
                    if (ihash.containsKey(cname)) {
                        nfo = (DatabaseNodeInfo)ihash.get(cname);
                        tempInfo = DatabaseNodeInfo.createNodeInfo(this, "column", rset);
                        this.copyProperties(tempInfo, nfo);
                    } else if (ixhash.containsKey(cname)) {
                        nfo = (DatabaseNodeInfo)ixhash.get(cname);
                        tempInfo = DatabaseNodeInfo.createNodeInfo(this, "column", rset);
                        this.copyProperties(tempInfo, nfo);
                    } else {
                        nfo = DatabaseNodeInfo.createNodeInfo(this, "column", rset);
                    }
                    children.add(nfo);
                    rset.clear();
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    private void copyProperties(DatabaseNodeInfo source, DatabaseNodeInfo target) {
        Enumeration keys = source.keys();
        while (keys.hasMoreElements()) {
            String nextKey = keys.nextElement().toString();
            if (target.get(nextKey) != null) continue;
            target.put(nextKey, source.get(nextKey));
        }
    }

    public void setProperty(String key, Object obj) {
        try {
            if (key.equals("remarks")) {
                this.setRemarks((String)obj);
            }
            this.put(key, obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setRemarks(String rem) throws DatabaseException {
        String tablename = (String)this.get("table");
        Specification spec = (Specification)this.getSpecification();
        try {
            CommentTable cmd = spec.createCommandCommentTable(tablename, rem);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void dropIndex(DatabaseNodeInfo tinfo) throws DatabaseException {
    }

    public void refreshChildren() throws DatabaseException {
        this.getNode().getChildren().getNodes();
        Vector charr = new Vector();
        this.put("children", charr);
        this.initChildren(charr);
        try {
            Node[] subTreeNodes = new Node[charr.size() + 1 + 1];
            DatabaseNodeChildren children = (DatabaseNodeChildren)this.getNode().getChildren();
            final Node[] childrenNodes = children.getNodes();
            int i = 0;
            while (i < childrenNodes.length) {
                int j;
                if (((DatabaseNode)childrenNodes[i]).getInfo() instanceof IndexListNodeInfo) {
                    j = i;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                ((DatabaseNode)childrenNodes[j]).getInfo().refreshChildren();
                            }
                            catch (Exception ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                    });
                    subTreeNodes[charr.size() + 1] = childrenNodes[i];
                } else if (((DatabaseNode)childrenNodes[i]).getInfo() instanceof ForeignKeyListNodeInfo) {
                    j = i;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                ((DatabaseNode)childrenNodes[j]).getInfo().refreshChildren();
                            }
                            catch (Exception ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                    });
                    subTreeNodes[charr.size()] = childrenNodes[i];
                }
                ++i;
            }
            children.remove(childrenNodes);
            int i2 = 0;
            while (i2 < charr.size()) {
                subTreeNodes[i2] = children.createNode((DatabaseNodeInfo)charr.elementAt(i2));
                ++i2;
            }
            children.add(subTreeNodes);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void delete() throws IOException {
        try {
            Specification spec = (Specification)this.getSpecification();
            AbstractCommand cmd = spec.createCommandDropTable(this.getTable());
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
    }

    public ColumnNodeInfo getChildrenColumnInfo(ColumnNodeInfo info) {
        String scode = info.getCode();
        String sname = info.getName();
        try {
            Enumeration enu = this.getChildren().elements();
            while (enu.hasMoreElements()) {
                ColumnNodeInfo elem = (ColumnNodeInfo)enu.nextElement();
                if (!elem.getCode().equals(scode) || !elem.getName().equals(sname)) continue;
                return elem;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public void addColumn(String tname) throws DatabaseException {
        try {
            Vector chvec = new Vector(1);
            this.initChildren(chvec, tname);
            if (chvec.size() == 1) {
                DatabaseNodeInfo nfo = (DatabaseNodeInfo)chvec.elementAt(0);
                DatabaseNodeChildren chld = (DatabaseNodeChildren)this.getNode().getChildren();
                chld.createSubnode(nfo, true);
            }
            this.refreshChildren();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }
}

