/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.Vector;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.CommentView;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;

public class ViewNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = 8370676447530973161L;

    public void initChildren(Vector children) throws DatabaseException {
        try {
            String view = (String)this.get("view");
            DriverSpecification drvSpec = this.getDriverSpecification();
            drvSpec.getColumns(view, "%");
            ResultSet rs = drvSpec.getResultSet();
            if (rs != null) {
                while (rs.next()) {
                    DatabaseNodeInfo nfo = DatabaseNodeInfo.createNodeInfo(this, "viewcolumn", drvSpec.getRow());
                    if (nfo == null) continue;
                    children.add(nfo);
                }
                rs.close();
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void setProperty(String key, Object obj) {
        try {
            if (key.equals("remarks")) {
                this.setRemarks((String)obj);
            }
            this.put(key, obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setRemarks(String rem) throws DatabaseException {
        String viewname = (String)this.get("view");
        Specification spec = (Specification)this.getSpecification();
        try {
            CommentView cmd = spec.createCommandCommentView(viewname, rem);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void delete() throws IOException {
        try {
            String code = this.getCode();
            String table = (String)this.get("table");
            Specification spec = (Specification)this.getSpecification();
            AbstractCommand cmd = spec.createCommandDropView(this.getName());
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

