/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectionNode
extends DatabaseNode {
    private boolean createPropSupport = true;

    public void setInfo(DatabaseNodeInfo nodeinfo) {
        super.setInfo(nodeinfo);
        DatabaseNodeInfo info = this.getInfo();
        this.setName(info.getName());
        info.addConnectionListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("db")) {
                    ConnectionNode.this.setConnectionName();
                }
                if (evt.getPropertyName().equals("schema")) {
                    ConnectionNode.this.setConnectionName();
                }
                if (evt.getPropertyName().equals("user")) {
                    ConnectionNode.this.setConnectionName();
                }
                if (evt.getPropertyName().equals("connection")) {
                    ConnectionNode.this.update((Connection)evt.getNewValue());
                    ConnectionNode.super.firePropertyChange(null, null, null);
                }
            }
        });
        this.getCookieSet().add((Node.Cookie)this);
    }

    private void setConnectionName() {
        String displayName = this.getInfo().getDatabaseConnection().getName();
        this.setDisplayName(displayName);
    }

    private boolean createPropSupport() {
        return this.createPropSupport;
    }

    private void setPropSupport(boolean value) {
        this.createPropSupport = value;
    }

    private void update(Connection connection) {
        final boolean connecting = connection != null;
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                block7: {
                    DatabaseNodeChildren children = (DatabaseNodeChildren)ConnectionNode.this.getChildren();
                    DatabaseNodeInfo info = ConnectionNode.this.getInfo();
                    ConnectionNode.this.setIconBase((String)info.get(connecting ? "activeiconbase" : "iconbase"));
                    ConnectionNode.this.setConnectionName();
                    Sheet.Set set = ConnectionNode.super.getSheet().get("properties");
                    try {
                        Node.Property dbprop;
                        if (ConnectionNode.this.createPropSupport()) {
                            dbprop = set.get("db");
                            PropertySupport newdbprop = ConnectionNode.this.createPropertySupport(dbprop.getName(), dbprop.getValueType(), dbprop.getDisplayName(), dbprop.getShortDescription(), info, !connecting);
                            set.put((Node.Property)newdbprop);
                            ConnectionNode.super.firePropertyChange("db", dbprop, newdbprop);
                            Node.Property drvprop = set.get("driver");
                            PropertySupport newdrvprop = ConnectionNode.this.createPropertySupport(drvprop.getName(), drvprop.getValueType(), drvprop.getDisplayName(), drvprop.getShortDescription(), info, !connecting);
                            set.put((Node.Property)newdrvprop);
                            ConnectionNode.super.firePropertyChange("driver", drvprop, newdrvprop);
                            Node.Property schemaprop = set.get("schema");
                            PropertySupport newschemaprop = ConnectionNode.this.createPropertySupport(schemaprop.getName(), schemaprop.getValueType(), schemaprop.getDisplayName(), schemaprop.getShortDescription(), info, !connecting);
                            set.put((Node.Property)newschemaprop);
                            ConnectionNode.super.firePropertyChange("schema", schemaprop, newschemaprop);
                            Node.Property usrprop = set.get("user");
                            PropertySupport newusrprop = ConnectionNode.this.createPropertySupport(usrprop.getName(), usrprop.getValueType(), usrprop.getDisplayName(), usrprop.getShortDescription(), info, !connecting);
                            set.put((Node.Property)newusrprop);
                            ConnectionNode.super.firePropertyChange("user", usrprop, newusrprop);
                            Node.Property rememberprop = set.get("rememberpwd");
                            PropertySupport newrememberprop = ConnectionNode.this.createPropertySupport(rememberprop.getName(), rememberprop.getValueType(), rememberprop.getDisplayName(), rememberprop.getShortDescription(), info, connecting);
                            set.put((Node.Property)newrememberprop);
                            ConnectionNode.super.firePropertyChange("rememberpassword", rememberprop, newrememberprop);
                            ConnectionNode.this.setPropSupport(false);
                        } else {
                            dbprop = set.get("db");
                            set.put(dbprop);
                            ConnectionNode.super.firePropertyChange("db", null, dbprop);
                            Node.Property drvprop = set.get("driver");
                            ConnectionNode.super.firePropertyChange("driver", null, drvprop);
                            Node.Property schemaprop = set.get("schema");
                            ConnectionNode.super.firePropertyChange("schema", null, schemaprop);
                            Node.Property usrprop = set.get("user");
                            ConnectionNode.super.firePropertyChange("user", null, usrprop);
                            Node.Property rememberprop = set.get("rememberpwd");
                            ConnectionNode.super.firePropertyChange("rememberpassword", null, rememberprop);
                        }
                        if (!connecting) {
                            children.remove(children.getNodes());
                            break block7;
                        }
                        DatabaseMetaData dmd = info.getSpecification().getMetaData();
                        try {
                            info.put("databaseProductName", dmd.getDatabaseProductName());
                            info.put("mixedCaseIdentifiers", dmd.supportsMixedCaseIdentifiers() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("mixedCaseQuotedIdentifiers", dmd.supportsMixedCaseQuotedIdentifiers() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("alterTableWithAddColumn", dmd.supportsAlterTableWithAddColumn() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("alterTableWithDropColumn", dmd.supportsAlterTableWithDropColumn() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("convert", dmd.supportsConvert() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("tableCorrelationNames", dmd.supportsTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("tableCorrelationNames", dmd.supportsDifferentTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("expressionsInOrderBy", dmd.supportsExpressionsInOrderBy() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("orderByUnrelated", dmd.supportsOrderByUnrelated() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("groupBy", dmd.supportsGroupBy() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("groupByUnrelated", dmd.supportsGroupByUnrelated() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("groupByBeyondSelect", dmd.supportsGroupByBeyondSelect() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("likeEscapeClause", dmd.supportsLikeEscapeClause() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("multipleResultSets", dmd.supportsMultipleResultSets() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("multipleTransactions", dmd.supportsMultipleTransactions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("nonNullableColumns", dmd.supportsNonNullableColumns() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("minimumSQLGrammar", dmd.supportsMinimumSQLGrammar() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("coreSQLGrammar", dmd.supportsCoreSQLGrammar() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("extendedSQLGrammar", dmd.supportsExtendedSQLGrammar() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("ANSI92EntryLevelSQL", dmd.supportsANSI92EntryLevelSQL() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("ANSI92IntermediateSQL", dmd.supportsANSI92IntermediateSQL() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("ANSI92FullSQL", dmd.supportsANSI92FullSQL() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("IntegrityEnhancementFacility", dmd.supportsIntegrityEnhancementFacility() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("outerJoins", dmd.supportsOuterJoins() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("fullOuterJoins", dmd.supportsFullOuterJoins() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("limitedOuterJoins", dmd.supportsLimitedOuterJoins() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("schemasInDataManipulation", dmd.supportsSchemasInDataManipulation() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("schemasInProcedureCalls", dmd.supportsSchemasInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("schemasInTableDefinitions", dmd.supportsSchemasInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("schemasInIndexDefinitions", dmd.supportsSchemasInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("schemasInPrivilegeDefinitions", dmd.supportsSchemasInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("catalogsInDataManipulation", dmd.supportsCatalogsInDataManipulation() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("catalogsInProcedureCalls", dmd.supportsCatalogsInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("catalogsInTableDefinitions", dmd.supportsCatalogsInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("catalogsInIndexDefinitions", dmd.supportsCatalogsInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("catalogsInPrivilegeDefinitions", dmd.supportsCatalogsInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("positionedDelete", dmd.supportsPositionedDelete() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("positionedUpdate", dmd.supportsPositionedUpdate() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("selectForUpdate", dmd.supportsSelectForUpdate() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("storedProcedures", dmd.supportsStoredProcedures() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("subqueriesInComparisons", dmd.supportsSubqueriesInComparisons() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("subqueriesInExists", dmd.supportsSubqueriesInExists() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("subqueriesInIns", dmd.supportsSubqueriesInIns() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("subqueriesInQuantifieds", dmd.supportsSubqueriesInQuantifieds() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("correlatedSubqueries", dmd.supportsCorrelatedSubqueries() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("union", dmd.supportsUnion() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("unionAll", dmd.supportsUnionAll() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("openCursorsAcrossCommit", dmd.supportsOpenCursorsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("openCursorsAcrossRollback", dmd.supportsOpenCursorsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("openStatementsAcrossCommit", dmd.supportsOpenStatementsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("openStatementsAcrossRollback", dmd.supportsOpenStatementsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("transactions", dmd.supportsTransactions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("dataDefinitionAndDataManipulationTransactions", dmd.supportsDataDefinitionAndDataManipulationTransactions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("dataManipulationTransactionsOnly", dmd.supportsDataManipulationTransactionsOnly() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("batchUpdates", dmd.supportsBatchUpdates() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("catalogAtStart", dmd.isCatalogAtStart() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("columnAliasing", dmd.supportsColumnAliasing() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("dataDefinitionCausesTransactionCommit", dmd.dataDefinitionCausesTransactionCommit() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("dataDefinitionIgnoredInTransactions", dmd.dataDefinitionIgnoredInTransactions() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("differentTableCorrelationNames", dmd.supportsDifferentTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("localFiles", dmd.usesLocalFiles() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("localFilePerTable", dmd.usesLocalFilePerTable() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("maxRowSizeIncludeBlobs", dmd.doesMaxRowSizeIncludeBlobs() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("nullPlusNonNullIsNull", dmd.nullPlusNonNullIsNull() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("proceduresAreCallable", dmd.allProceduresAreCallable() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("tablesAreSelectable", dmd.allTablesAreSelectable() ? Boolean.TRUE : Boolean.FALSE);
                            info.put("maxBinaryLiteralLength", new Integer(dmd.getMaxBinaryLiteralLength()));
                            info.put("maxCharLiteralLength", new Integer(dmd.getMaxCharLiteralLength()));
                            info.put("maxColumnNameLength", new Integer(dmd.getMaxColumnNameLength()));
                            info.put("maxColumnsInGroupBy", new Integer(dmd.getMaxColumnsInGroupBy()));
                            info.put("maxColumnsInIndex", new Integer(dmd.getMaxColumnsInIndex()));
                            info.put("maxColumnsInOrderBy", new Integer(dmd.getMaxColumnsInOrderBy()));
                            info.put("maxColumnsInSelect", new Integer(dmd.getMaxColumnsInSelect()));
                            info.put("maxColumnsInTable", new Integer(dmd.getMaxColumnsInTable()));
                            info.put("maxConnections", new Integer(dmd.getMaxConnections()));
                            info.put("maxCursorNameLength", new Integer(dmd.getMaxCursorNameLength()));
                            info.put("maxIndexLength", new Integer(dmd.getMaxIndexLength()));
                            info.put("maxSchemaNameLength", new Integer(dmd.getMaxSchemaNameLength()));
                            info.put("maxProcedureNameLength", new Integer(dmd.getMaxProcedureNameLength()));
                            info.put("maxCatalogNameLength", new Integer(dmd.getMaxCatalogNameLength()));
                            info.put("maxRowSize", new Integer(dmd.getMaxRowSize()));
                            info.put("maxStatementLength", new Integer(dmd.getMaxStatementLength()));
                            info.put("maxStatements", new Integer(dmd.getMaxStatements()));
                            info.put("maxTableNameLength", new Integer(dmd.getMaxTableNameLength()));
                            info.put("maxTablesInSelect", new Integer(dmd.getMaxTablesInSelect()));
                            info.put("maxUserNameLength", new Integer(dmd.getMaxUserNameLength()));
                            info.put("defaultTransactionIsolation", new Integer(dmd.getDefaultTransactionIsolation()));
                            info.put("URL", dmd.getURL());
                            info.put("userName", dmd.getUserName());
                            info.put("databaseProductVersion", dmd.getDatabaseProductVersion());
                            info.put("driverName", dmd.getDriverName());
                            info.put("driverVersion", dmd.getDriverVersion());
                            info.put("driverMajorVersion", new Integer(dmd.getDriverMajorVersion()));
                            info.put("driverMinorVersion", new Integer(dmd.getDriverMinorVersion()));
                            info.put("identifierQuoteString", dmd.getIdentifierQuoteString());
                            info.put("SQLKeywords", dmd.getSQLKeywords());
                            info.put("numericFunctions", dmd.getNumericFunctions());
                            info.put("stringFunctions", dmd.getStringFunctions());
                            info.put("systemFunctions", dmd.getSystemFunctions());
                            info.put("timeDateFunctions", dmd.getTimeDateFunctions());
                            info.put("searchStringEscape", dmd.getSearchStringEscape());
                            info.put("extraNameCharacters", dmd.getExtraNameCharacters());
                            info.put("schemaTerm", dmd.getSchemaTerm());
                            info.put("procedureTerm", dmd.getProcedureTerm());
                            info.put("catalogTerm", dmd.getCatalogTerm());
                            info.put("catalogSeparator", dmd.getCatalogSeparator());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        DatabaseNodeInfo innernfo = DatabaseNodeInfo.createNodeInfo(info, "tablelist");
                        children.createSubnode(innernfo, true);
                        innernfo = DatabaseNodeInfo.createNodeInfo(info, "viewlist");
                        children.createSubnode(innernfo, true);
                        innernfo = DatabaseNodeInfo.createNodeInfo(info, "procedurelist");
                        children.createSubnode(innernfo, true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }, (int)0);
    }

    public boolean canDestroy() {
        Connection con = this.getInfo().getConnection();
        try {
            return con == null || con.isClosed();
        }
        catch (SQLException exc) {
            return true;
        }
    }

    public String getShortDescription() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_Connection");
    }
}

