/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.diff;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.openide.filesystems.FileUtil;
import org.openide.util.io.ReaderInputStream;

public abstract class StreamSource {
    public abstract String getName();

    public abstract String getTitle();

    public abstract String getMIMEType();

    public abstract Reader createReader() throws IOException;

    public abstract Writer createWriter(Difference[] var1) throws IOException;

    public void close() {
    }

    public static StreamSource createSource(String name, String title, String MIMEType, Reader r) {
        return new Impl(name, title, MIMEType, r);
    }

    public static StreamSource createSource(String name, String title, String MIMEType, File file) {
        return new Impl(name, title, MIMEType, file);
    }

    private static class Impl
    extends StreamSource {
        private String name;
        private String title;
        private String MIMEType;
        private Reader r;
        private File readerSource;
        private Writer w;
        private File file;

        Impl(String name, String title, String MIMEType, Reader r) {
            this.name = name;
            this.title = title;
            this.MIMEType = MIMEType;
            this.r = r;
            this.readerSource = null;
            this.w = null;
            this.file = null;
        }

        Impl(String name, String title, String MIMEType, File file) {
            this.name = name;
            this.title = title;
            this.MIMEType = MIMEType;
            this.readerSource = null;
            this.w = null;
            this.file = file;
        }

        private File createReaderSource(Reader r) throws IOException {
            OutputStream out;
            File tmp;
            block5: {
                tmp = null;
                tmp = File.createTempFile("ss", "tmp");
                tmp.deleteOnExit();
                tmp.createNewFile();
                ReaderInputStream in = null;
                out = null;
                try {
                    in = new ReaderInputStream(r);
                    out = new FileOutputStream(tmp);
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                    Object var6_5 = null;
                    if (in == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                in.close();
            }
            if (out != null) {
                out.close();
            }
            return tmp;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.MIMEType;
        }

        public Reader createReader() throws IOException {
            if (this.file != null) {
                return new BufferedReader(new FileReader(this.file));
            }
            Impl impl = this;
            synchronized (impl) {
                if (this.r != null) {
                    this.readerSource = this.createReaderSource(this.r);
                    this.r = null;
                }
            }
            return new BufferedReader(new FileReader(this.readerSource));
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            if (conflicts != null && conflicts.length > 0) {
                return null;
            }
            if (this.file != null) {
                return new BufferedWriter(new FileWriter(this.file));
            }
            return this.w;
        }

        public void notifyClosed() {
        }
    }
}

