/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.DiffAction;
import org.netbeans.modules.diff.builtin.Patch;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.io.ReaderInputStream;

public class PatchAction
extends NodeAction {
    private static final String PATCHING_IO_ENCODING = "ISO-8859-1";
    static /* synthetic */ Class class$org$netbeans$modules$diff$PatchAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"CTL_PatchActionName");
    }

    public boolean enable(Node[] nodes) {
        DataObject do1;
        if (nodes.length == 1 && (do1 = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PatchAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null) {
            if (do1 instanceof InstanceDataObject) {
                return false;
            }
            FileObject fo = do1.getPrimaryFile();
            try {
                FileSystem fs = fo.getFileSystem();
                if (fs.isDefault()) {
                    String packageName = fo.getPackageName('/');
                    return packageName.startsWith("Templates") || packageName.startsWith("vcs/config") || packageName.startsWith("org/");
                }
                return true;
            }
            catch (FileStateInvalidException fsiex) {
                return false;
            }
        }
        return false;
    }

    public void performAction(Node[] nodes) {
        DataObject do1 = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PatchAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (do1 != null) {
            Patch.FileDifferences[] fileDiffs;
            FileObject fo = do1.getPrimaryFile();
            File patch = this.getPatchFor(fo);
            if (patch == null) {
                return;
            }
            try {
                fileDiffs = Patch.parse(new InputStreamReader((InputStream)new FileInputStream(patch), PATCHING_IO_ENCODING));
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ioex, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_PatchParsingFailed", (Object)ioex.getLocalizedMessage())));
                return;
            }
            int numDiffs = 0;
            int i = 0;
            while (i < fileDiffs.length) {
                numDiffs += fileDiffs[i].getDifferences().length;
                ++i;
            }
            if (numDiffs == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_NoDifferences", (Object)patch.getName())));
                return;
            }
            this.applyFileDiffs(fileDiffs, fo);
        }
    }

    private File getPatchFor(FileObject fo) {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
        chooser.setFileSelectionMode(0);
        String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)(fo.isData() ? "TITLE_SelectPatchForFile" : "TITLE_SelectPatchForFolder"), (Object)fo.getNameExt());
        chooser.setDialogTitle(title);
        chooser.setApproveButtonText(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"BTN_Patch"));
        chooser.setApproveButtonMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"BTN_Patch_mnc").charAt(0));
        chooser.setApproveButtonToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"BTN_Patch_tooltip"));
        JFrame parent = new JFrame();
        JDialog dialog = new JDialog(parent, title, true);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"ACSD_PatchDialog"));
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooser, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        ChooserListener listener = new ChooserListener(dialog, chooser);
        chooser.addActionListener(listener);
        dialog.show();
        return listener.getFile();
    }

    private void applyFileDiffs(Patch.FileDifferences[] fileDiffs, FileObject fo) {
        ArrayList<String> notFoundFileNames = new ArrayList<String>();
        ArrayList<FileObject> appliedFiles = new ArrayList<FileObject>();
        HashMap<FileObject, FileObject> backups = new HashMap<FileObject, FileObject>();
        boolean patchFailed = false;
        int i = 0;
        while (i < fileDiffs.length) {
            FileObject file = fo.isData() ? fo : PatchAction.findChild(fo, fileDiffs[i].getFileName());
            if (file == null) {
                notFoundFileNames.add(fo.getPackageNameExt(File.separatorChar, '.') + File.separator + fileDiffs[i].getFileName());
            } else {
                FileObject backup = this.createFileBackup(file);
                if (this.applyDiffsTo(fileDiffs[i].getDifferences(), file)) {
                    appliedFiles.add(file);
                    backups.put(file, backup);
                    file.refresh(true);
                } else {
                    patchFailed = true;
                }
            }
            ++i;
        }
        if (notFoundFileNames.size() > 0) {
            String files = "";
            int i2 = 0;
            while (i2 < notFoundFileNames.size()) {
                files = files + notFoundFileNames.get(i2).toString();
                if (i2 < notFoundFileNames.size() - 1) {
                    files = files + ", ";
                }
                ++i2;
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_NotFoundFiles", (Object)files)));
        }
        if (appliedFiles.size() > 0) {
            String message = patchFailed ? NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_PatchAppliedPartially") : NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"MSG_PatchAppliedSuccessfully");
            Object notifyResult = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, 0));
            if (NotifyDescriptor.YES_OPTION.equals(notifyResult)) {
                this.showDiffs(appliedFiles, backups);
            }
        }
    }

    private static FileObject findChild(FileObject folder, String child) {
        child = child.replace(File.separatorChar, '/');
        StringTokenizer tokenizer = new StringTokenizer(child, "/");
        FileObject ch = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            ch = folder.getFileObject(token);
            if (ch == null || !ch.isFolder()) continue;
            folder = ch;
            ch = null;
        }
        return ch;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileObject createFileBackup(FileObject fo) {
        block14: {
            parent = fo.getParent();
            lock = null;
            in = null;
            out = null;
            try {
                try {
                    orig = parent.getFileObject(fo.getNameExt(), "orig");
                    if (orig == null) {
                        orig = parent.createData(fo.getNameExt(), "orig");
                    }
                    in = fo.getInputStream();
                    lock = orig.lock();
                    out = orig.getOutputStream(lock);
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                    var7_8 = orig;
                    var9_10 = null;
                    if (lock == null) break block14;
                }
                catch (IOException ioex) {
                    var7_9 = null;
                    var9_11 = null;
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out == null) return var7_9;
                        out.close();
                        return var7_9;
                    }
                    catch (IOException ioex) {
                        // empty catch block
                    }
                    return var7_9;
                }
            }
            catch (Throwable var8_16) {
                var9_12 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
                try {}
                catch (IOException ioex) {
                    throw var8_16;
                }
                if (in != null) {
                    in.close();
                }
                if (out == null) throw var8_16;
                out.close();
                throw var8_16;
            }
            lock.releaseLock();
        }
        ** try [egrp 2[TRYBLOCK] [2 : 106->129)] { 
lbl51:
        // 1 sources

        if (in != null) {
            in.close();
        }
        if (out == null) return var7_8;
        out.close();
        return var7_8;
lbl56:
        // 1 sources

        catch (IOException ioex) {
            // empty catch block
        }
        return var7_8;
    }

    /*
     * Loose catch block
     */
    private boolean applyDiffsTo(Difference[] diffs, FileObject fo) {
        File tmp;
        block35: {
            FileLock lock;
            OutputStream out;
            InputStream in;
            block34: {
                block32: {
                    try {
                        tmp = File.createTempFile("patch", "tmp");
                    }
                    catch (IOException ioex) {
                        ErrorManager.getDefault().notify((Throwable)ioex);
                        return false;
                    }
                    tmp.deleteOnExit();
                    in = null;
                    out = null;
                    Reader patched = Patch.apply(diffs, new InputStreamReader(fo.getInputStream(), PATCHING_IO_ENCODING));
                    in = new ReaderInputStream(patched);
                    out = new FileOutputStream(tmp);
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                    Object var11_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        break block32;
                    }
                    catch (IOException ioex2) {}
                    break block32;
                    {
                        catch (IOException ioex) {
                            String msg = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_PatchApplicationFailed"), ioex.getLocalizedMessage(), fo.getNameExt());
                            NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)msg);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                            ErrorManager.getDefault().log(msg);
                            tmp.delete();
                            boolean bl = false;
                            Object var11_10 = null;
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (IOException ioex2) {
                                // empty catch block
                            }
                            return bl;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ioex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                lock = null;
                in = new FileInputStream(tmp);
                lock = fo.lock();
                out = fo.getOutputStream(lock);
                FileUtil.copy((InputStream)in, (OutputStream)out);
                Object var14_21 = null;
                if (lock == null) break block34;
                lock.releaseLock();
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                break block35;
            }
            catch (IOException ioex3) {}
            break block35;
            {
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ioex, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction), (String)"EXC_CopyOfAppliedPatchFailed", (Object)fo.getNameExt())));
                    boolean bl = false;
                    Object var14_22 = null;
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ioex3) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var14_23 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ioex3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        tmp.delete();
        return true;
    }

    private void showDiffs(ArrayList files, HashMap backups) {
        int i = 0;
        while (i < files.size()) {
            FileObject file = (FileObject)files.get(i);
            FileObject backup = (FileObject)backups.get(file);
            DiffAction.performAction(backup, file);
            ++i;
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$diff$PatchAction == null ? (class$org$netbeans$modules$diff$PatchAction = PatchAction.class$("org.netbeans.modules.diff.PatchAction")) : class$org$netbeans$modules$diff$PatchAction);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ChooserListener
    implements ActionListener {
        private JDialog dialog;
        private JFileChooser chooser;
        private File file = null;

        public ChooserListener(JDialog dialog, JFileChooser chooser) {
            this.dialog = dialog;
            this.chooser = chooser;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command == "ApproveSelection") {
                if (this.dialog != null) {
                    this.file = this.chooser.getSelectedFile();
                    ((Component)this.dialog).setVisible(false);
                }
            } else if (this.dialog != null) {
                this.file = null;
                ((Component)this.dialog).setVisible(false);
            }
        }

        public File getFile() {
            return this.file;
        }
    }
}

