/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.netbeans.api.diff.Difference;
import org.netbeans.spi.diff.DiffProvider;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class DiffPresenter
extends JPanel {
    public static final String PROP_PROVIDER = "provider";
    public static final String PROP_VISUALIZER = "visualizer";
    private Info diffInfo;
    private DiffProvider defaultProvider;
    private DiffVisualizer defaultVisualizer;
    private PropertyChangeSupport propSupport;
    private JPanel servicesPanel;
    private JLabel emptyLabel;
    private JPanel visualizerPanel;
    private JLabel providerLabel;
    private JLabel visualizerLabel;
    static /* synthetic */ Class class$org$netbeans$modules$diff$builtin$DiffPresenter;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$netbeans$spi$diff$DiffProvider;
    static /* synthetic */ Class class$org$netbeans$spi$diff$DiffVisualizer;

    public DiffPresenter(Info diffInfo) {
        this.diffInfo = diffInfo;
        this.propSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.initMyComponents();
        this.providerLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"LBL_Provider_Mnemonic").charAt(0));
        this.visualizerLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"LBL_Visualizer_Mnemonic").charAt(0));
        this.providerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"ACS_ProviderA11yDesc"));
        this.visualizerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"ACS_VisualizerA11yDesc"));
    }

    private void initComponents() {
        this.servicesPanel = new JPanel();
        this.providerLabel = new JLabel();
        this.visualizerLabel = new JLabel();
        this.emptyLabel = new JLabel();
        this.visualizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.servicesPanel.setLayout(new GridBagLayout());
        this.providerLabel.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"LBL_Provider"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.servicesPanel.add((Component)this.providerLabel, gridBagConstraints);
        this.visualizerLabel.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"LBL_Visualizer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.servicesPanel.add((Component)this.visualizerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.servicesPanel.add((Component)this.emptyLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 10, 10, 10);
        this.add((Component)this.servicesPanel, gridBagConstraints);
        this.visualizerPanel.setLayout(new BorderLayout());
        this.visualizerPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.visualizerPanel, gridBagConstraints);
    }

    private void initMyComponents() {
        GridBagConstraints gridBagConstraints;
        PropertyPanel panel;
        DefaultPropertyModel model;
        PropertyDescriptor pd;
        FileSystem dfs = Repository.getDefault().getDefaultFileSystem();
        FileObject services = dfs.findResource("Services");
        DataFolder df = DataFolder.findFolder((FileObject)services);
        if (this.diffInfo.isChooseProviders()) {
            try {
                pd = new PropertyDescriptor(PROP_PROVIDER, this.getClass());
            }
            catch (IntrospectionException intrex) {
                return;
            }
            pd.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"LBL_ProvidersPropEditorTitle"));
            pd.setPropertyEditorClass(PropertyEditorManager.findEditor(class$java$lang$Object == null ? (class$java$lang$Object = DiffPresenter.class$("java.lang.Object")) : class$java$lang$Object).getClass());
            pd.setValue("superClass", class$org$netbeans$spi$diff$DiffProvider == null ? (class$org$netbeans$spi$diff$DiffProvider = DiffPresenter.class$("org.netbeans.spi.diff.DiffProvider")) : class$org$netbeans$spi$diff$DiffProvider);
            FileObject providersFO = services.getFileObject("DiffProviders");
            try {
                DataObject providersDO = DataObject.find((FileObject)providersFO);
                Node providersNode = providersDO.getNodeDelegate();
                pd.setValue("node", providersNode);
            }
            catch (DataObjectNotFoundException donfex) {
                // empty catch block
            }
            pd.setValue("helpID", "org.netbeans.modules.diff.DiffPresenter.providers");
            model = new DefaultPropertyModel((Object)this, pd);
            panel = new PropertyPanel((PropertyModel)model, 4);
            panel.setChangeImmediate(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            this.servicesPanel.add((Component)panel, gridBagConstraints);
            this.providerLabel.setLabelFor((Component)panel);
            panel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"ACS_ProviderPropertyPanelA11yName"));
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"ACS_ProviderPropertyPanelA11yDesc"));
        }
        if (this.diffInfo.isChooseVisualizers()) {
            try {
                pd = new PropertyDescriptor(PROP_VISUALIZER, this.getClass());
            }
            catch (IntrospectionException intrex) {
                return;
            }
            pd.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"LBL_VisualizersPropEditorTitle"));
            pd.setPropertyEditorClass(PropertyEditorManager.findEditor(class$java$lang$Object == null ? (class$java$lang$Object = DiffPresenter.class$("java.lang.Object")) : class$java$lang$Object).getClass());
            pd.setValue("superClass", class$org$netbeans$spi$diff$DiffVisualizer == null ? (class$org$netbeans$spi$diff$DiffVisualizer = DiffPresenter.class$("org.netbeans.spi.diff.DiffVisualizer")) : class$org$netbeans$spi$diff$DiffVisualizer);
            FileObject visualizersFO = services.getFileObject("DiffVisualizers");
            try {
                DataObject visualizersDO = DataObject.find((FileObject)visualizersFO);
                Node visualizersNode = visualizersDO.getNodeDelegate();
                pd.setValue("node", visualizersNode);
            }
            catch (DataObjectNotFoundException donfex) {
                // empty catch block
            }
            pd.setValue("helpID", "org.netbeans.modules.diff.DiffPresenter.visualizers");
            model = new DefaultPropertyModel((Object)this, pd);
            panel = new PropertyPanel((PropertyModel)model, 4);
            panel.setChangeImmediate(false);
            panel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"ACS_VisualizerPropertyPanelA11yName"));
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$DiffPresenter == null ? (class$org$netbeans$modules$diff$builtin$DiffPresenter = DiffPresenter.class$("org.netbeans.modules.diff.builtin.DiffPresenter")) : class$org$netbeans$modules$diff$builtin$DiffPresenter), (String)"ACS_VisualizerPropertyPanelA11yDesc"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 3;
            this.servicesPanel.add((Component)panel, gridBagConstraints);
            this.visualizerLabel.setLabelFor((Component)panel);
        }
        this.providerLabel.setVisible(this.diffInfo.isChooseProviders());
        this.visualizerLabel.setVisible(this.diffInfo.isChooseVisualizers());
        this.servicesPanel.setVisible(this.diffInfo.isChooseProviders() || this.diffInfo.isChooseVisualizers());
    }

    public DiffProvider getProvider() {
        return this.defaultProvider;
    }

    public void setProvider(DiffProvider p) {
        this.defaultProvider = p;
        this.showDiff();
    }

    public DiffVisualizer getVisualizer() {
        return this.defaultVisualizer;
    }

    public void setVisualizer(DiffVisualizer v) {
        this.defaultVisualizer = v;
        this.showDiff();
    }

    private void showDiff() {
        try {
            this.showDiff(this.defaultProvider, this.defaultVisualizer);
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify((Throwable)ioex);
        }
    }

    private synchronized void showDiff(DiffProvider p, DiffVisualizer v) throws IOException {
        Difference[] diffs;
        if (v == null) {
            return;
        }
        if (p != null) {
            diffs = this.diffInfo.getInitialDifferences();
            if (diffs == null) {
                diffs = p.computeDiff(this.diffInfo.createFirstReader(), this.diffInfo.createSecondReader());
            }
        } else {
            diffs = this.diffInfo.getDifferences();
        }
        if (diffs == null) {
            return;
        }
        Component c = v.createView(diffs, this.diffInfo.getName1(), this.diffInfo.getTitle1(), this.diffInfo.createFirstReader(), this.diffInfo.getName2(), this.diffInfo.getTitle2(), this.diffInfo.createSecondReader(), this.diffInfo.getMimeType());
        this.setVisualizer(c);
        TopComponent tp = this.diffInfo.getPresentingComponent();
        if (tp != null) {
            tp.setName(c.getName());
            if (c instanceof TopComponent) {
                TopComponent vtp = (TopComponent)c;
                tp.setToolTipText(vtp.getToolTipText());
                tp.setIcon(vtp.getIcon());
            }
        }
        c.requestFocus();
    }

    private void setVisualizer(Component visualizer) {
        this.visualizerPanel.removeAll();
        if (visualizer != null) {
            this.visualizerPanel.add(visualizer, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class Info {
        private String name1;
        private String name2;
        private String title1;
        private String title2;
        private String mimeType;
        private boolean chooseProviders;
        private boolean chooseVisualizers;
        private TopComponent tp;

        public Info(String name1, String name2, String title1, String title2, String mimeType, boolean chooseProviders, boolean chooseVisualizers) {
            this.name1 = name1;
            this.name2 = name2;
            this.title1 = title1;
            this.title2 = title2;
            this.mimeType = mimeType;
            this.chooseProviders = chooseProviders;
            this.chooseVisualizers = chooseVisualizers;
        }

        public String getName1() {
            return this.name1;
        }

        public String getName2() {
            return this.name2;
        }

        public String getTitle1() {
            return this.title1;
        }

        public String getTitle2() {
            return this.title2;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public boolean isChooseProviders() {
            return this.chooseProviders;
        }

        public boolean isChooseVisualizers() {
            return this.chooseVisualizers;
        }

        public Difference[] getDifferences() {
            return null;
        }

        public Difference[] getInitialDifferences() {
            return null;
        }

        public abstract Reader createFirstReader();

        public abstract Reader createSecondReader();

        public void setPresentingComponent(TopComponent tp) {
            this.tp = tp;
        }

        public TopComponent getPresentingComponent() {
            return this.tp;
        }
    }
}

