/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.provider.io.LineIndexedAccess;

public class LineDiff {
    public static final boolean DEFAULT_HEURISTIC = true;
    public static final long DEFAULT_MINMATCH = 1L;

    private LineDiff() {
    }

    public static Difference[] diff(LineIndexedAccess f1, LineIndexedAccess f2) throws IOException {
        return LineDiff.diff(f1, f2, true, 1L);
    }

    public static Difference[] diff(LineIndexedAccess f1, LineIndexedAccess f2, boolean heuristic, long minmatch) throws IOException {
        ArrayList<Difference> diffs = new ArrayList<Difference>();
        long s1 = f1.length();
        long s2 = f2.length();
        if (s1 == 0L && s2 == 0L) {
            return new Difference[0];
        }
        if (s1 == 0L) {
            diffs.add(LineDiff.createAdd(f2, 0L, 0L, s2));
            return diffs.toArray(new Difference[diffs.size()]);
        }
        if (s2 == 0L) {
            diffs.add(LineDiff.createDel(f1, 0L, s1, 0L));
            return diffs.toArray(new Difference[diffs.size()]);
        }
        long o1 = 0L;
        long o2 = 0L;
        long line1 = 0L;
        long line2 = 0L;
        while (s1 != o1 && s2 != o2) {
            long iRun;
            long max_i = Math.max(s1 - o1, s2 - o2) - minmatch;
            boolean sync = false;
            long i = 0L;
            block1: while (i <= max_i) {
                long j = 0L;
                while (j <= i) {
                    if (LineDiff.testMinmatch(f1, o1 + i, s1, f2, o2 + j, s2, minmatch)) {
                        if (heuristic) {
                            while (i > 0L && j > 0L && f1.readAt(o1 + i - 1L).equals(f2.readAt(o2 + j - 1L))) {
                                --i;
                                --j;
                            }
                        }
                        if (i > 0L) {
                            diffs.add(LineDiff.createDel(f1, o1, o1 + i, o2));
                        }
                        diffs.add(LineDiff.createAdd(f2, o1, o2, o2 + j));
                        o1 += i;
                        o2 += j;
                        sync = true;
                        break block1;
                    }
                    if (LineDiff.testMinmatch(f1, o1 + j, s1, f2, o2 + i, s2, minmatch)) {
                        if (heuristic) {
                            while (i > 0L && j > 0L && f1.readAt(o1 + j - 1L).equals(f2.readAt(o2 + i - 1L))) {
                                --i;
                                --j;
                            }
                        }
                        if (j > 0L) {
                            diffs.add(LineDiff.createDel(f1, o1, o1 + j, o2));
                        }
                        diffs.add(LineDiff.createAdd(f2, o1, o2, o2 + i));
                        o1 += j;
                        o2 += i;
                        sync = true;
                        break block1;
                    }
                    ++j;
                }
                if (heuristic) {
                    i += i / 10L;
                }
                ++i;
            }
            if (!sync) {
                if (s1 - o1 > 0L) {
                    diffs.add(LineDiff.createDel(f1, o1, s1, o2));
                }
                diffs.add(LineDiff.createAdd(f2, o1, o2, s2));
                o1 = s1;
                o2 = s2;
            }
            if (o1 == s1 || o2 == s2 || (iRun = LineDiff.getRun(f1, o1, s1, f2, o2, s2)) <= 0L) continue;
            o1 += iRun;
            o2 += iRun;
        }
        if (o1 != s1) {
            diffs.add(LineDiff.createDel(f1, o1, s1, o2));
        }
        if (o2 != s2) {
            diffs.add(LineDiff.createAdd(f2, o1, o2, s2));
        }
        LineDiff.cleanup(diffs);
        return diffs.toArray(new Difference[diffs.size()]);
    }

    private static long getRun(LineIndexedAccess f1, long o1, long s1, LineIndexedAccess f2, long o2, long s2) throws IOException {
        long i1 = o1;
        long i2 = o2;
        long i = 0L;
        while (i1 < s1 && i2 < s2 && f1.readAt(i1).equals(f2.readAt(i2))) {
            ++i;
            ++i1;
            ++i2;
        }
        return i;
    }

    private static boolean testMinmatch(LineIndexedAccess f1, long o1, long s1, LineIndexedAccess f2, long o2, long s2, long minmatch) throws IOException {
        long i1 = o1;
        long i2 = o2;
        if (s1 - i1 < minmatch) {
            return false;
        }
        if (s2 - i2 < minmatch) {
            return false;
        }
        int i = 0;
        while ((long)i < minmatch) {
            if (!f1.readAt(i1).equals(f2.readAt(i2))) {
                return false;
            }
            ++i;
            ++i1;
            ++i2;
        }
        return true;
    }

    private static Difference createAdd(LineIndexedAccess file, long f1l1, long f2l1, long f2l2) {
        if (f2l1 >= f2l2) {
            return null;
        }
        StringBuffer text = new StringBuffer();
        try {
            String[] lines = (String[])file.readFullyAt(f2l1, f2l2 - f2l1);
            int i = 0;
            while (i < lines.length) {
                text.append(lines[i]);
                text.append("\n");
                ++i;
            }
        }
        catch (IOException ioex) {
            // empty catch block
        }
        return new Difference(1, (int)f1l1, 0, (int)f2l1 + 1, (int)f2l2, "", text.toString());
    }

    private static Difference createDel(LineIndexedAccess file, long f1l1, long f1l2, long f2l1) {
        StringBuffer text = new StringBuffer();
        try {
            String[] lines = (String[])file.readFullyAt(f1l1, f1l2 - f1l1);
            int i = 0;
            while (i < lines.length) {
                text.append(lines[i]);
                text.append("\n");
                ++i;
            }
        }
        catch (IOException ioex) {
            // empty catch block
        }
        return new Difference(0, (int)f1l1 + 1, (int)f1l2, (int)f2l1, 0, text.toString(), "");
    }

    private static void cleanup(List diffs) {
        Difference last = null;
        int i = 0;
        while (i < diffs.size()) {
            Difference diff = (Difference)diffs.get(i);
            if (diff == null) {
                diffs.remove(i);
                --i;
            } else {
                if (last != null && (diff.getType() == 1 && last.getType() == 0 || diff.getType() == 0 && last.getType() == 1)) {
                    int d2f2l1;
                    int d1f2l1;
                    Difference del;
                    Difference add;
                    if (1 == diff.getType()) {
                        add = diff;
                        del = last;
                    } else {
                        add = last;
                        del = diff;
                    }
                    int d1f1l1 = add.getFirstStart() + 1;
                    int d2f1l1 = del.getFirstStart();
                    if (d1f1l1 == d2f1l1 && (d1f2l1 = add.getSecondStart()) == (d2f2l1 = del.getSecondStart() + 1)) {
                        Difference newDiff = new Difference(2, d1f1l1, del.getFirstEnd(), d1f2l1, add.getSecondEnd(), del.getFirstText(), add.getSecondText());
                        diffs.set(i - 1, newDiff);
                        diffs.remove(i);
                        --i;
                        diff = newDiff;
                    }
                }
                last = diff;
            }
            ++i;
        }
    }
}

