/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.modules.diff.builtin.visualizer.LinesComponent;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class DiffPanel
extends JPanel {
    private static final double VERTICAL_SCROLL_NUM_LINES = 4.0;
    private static final double HORIZONTAL_SCROLL_NUM_LINES = 4.0;
    private int totalHeight = 0;
    private int additionalHeight = 0;
    private int totalLines = 0;
    private int horizontalScroll1ChangedValue = -1;
    private int horizontalScroll2ChangedValue = -1;
    private LinesComponent linesComp1;
    private LinesComponent linesComp2;
    private ArrayList closeListeners = new ArrayList();
    private boolean diffSetSuccess = true;
    static final long serialVersionUID = 3683458237532937983L;
    private static final String PLAIN_TEXT_MIME = "text/plain";
    private Hashtable kitActions;
    private PropertyChangeListener copyL;
    private PropertyChangeListener copyP;
    private JViewport jViewport1;
    private JViewport jViewport2;
    private JButton nextButton;
    private JLabel fileLabel2;
    private JLabel fileLabel1;
    private JPanel filePanel2;
    private JPanel filePanel1;
    private JEditorPane jEditorPane2;
    private JEditorPane jEditorPane1;
    private JScrollPane jScrollPane2;
    private JPanel editorPanel;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JButton prevButton;
    private JPanel commandPanel;
    static /* synthetic */ Class class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;

    public DiffPanel() {
        this.initComponents();
        this.prevButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/prev.gif")));
        this.nextButton.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/next.gif")));
        this.prevButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"DiffComponent.prevButton.mnemonic").charAt(0));
        this.nextButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"DiffComponent.nextButton.mnemonic").charAt(0));
        this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"DiffComponent.title"));
        this.initActions();
        this.jSplitPane1.setResizeWeight(0.5);
        this.putClientProperty("PersistenceType", "Never");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_DiffPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_DiffPanelA11yDesc"));
        this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane1A11yName"));
        this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane1A11yDescr"));
        this.jEditorPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane2A11yName"));
        this.jEditorPane2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel), (String)"ACS_EditorPane2A11yDescr"));
    }

    private void initComponents() {
        this.commandPanel = new JPanel();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.editorPanel = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.filePanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.fileLabel1 = new JLabel();
        this.filePanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane2 = new JEditorPane();
        this.fileLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.commandPanel.setLayout(new GridBagLayout());
        this.prevButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel)).getString("DiffComponent.prevButton.toolTipText"));
        this.prevButton.setPreferredSize(new Dimension(24, 24));
        this.prevButton.setMaximumSize(new Dimension(24, 24));
        this.prevButton.setMargin(new Insets(1, 1, 0, 1));
        this.prevButton.setMinimumSize(new Dimension(24, 24));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        this.commandPanel.add((Component)this.prevButton, gridBagConstraints);
        this.nextButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel == null ? (class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel = DiffPanel.class$("org.netbeans.modules.diff.builtin.visualizer.DiffPanel")) : class$org$netbeans$modules$diff$builtin$visualizer$DiffPanel)).getString("DiffComponent.nextButton.toolTipText"));
        this.nextButton.setPreferredSize(new Dimension(24, 24));
        this.nextButton.setMaximumSize(new Dimension(24, 24));
        this.nextButton.setMargin(new Insets(1, 1, 0, 1));
        this.nextButton.setMinimumSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.commandPanel.add((Component)this.nextButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.commandPanel, gridBagConstraints);
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.setPreferredSize(new Dimension(700, 600));
        this.jSplitPane1.setDividerSize(4);
        this.filePanel1.setLayout(new GridBagLayout());
        this.jEditorPane1.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DiffPanel.this.jEditorPane1CaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.fileLabel1.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel1.add((Component)this.fileLabel1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.filePanel1);
        this.filePanel2.setLayout(new GridBagLayout());
        this.jEditorPane2.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DiffPanel.this.jEditorPane2CaretUpdate(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jEditorPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.fileLabel2.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.filePanel2.add((Component)this.fileLabel2, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.filePanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.editorPanel.add((Component)this.jSplitPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.editorPanel, gridBagConstraints);
    }

    private void jEditorPane1CaretUpdate(CaretEvent evt) {
    }

    private void jEditorPane2CaretUpdate(CaretEvent evt) {
    }

    public void setCurrentLine(int line, int diffLength) {
        if (line > 0) {
            this.showLine(line, diffLength);
        }
    }

    public void addPrevLineButtonListener(ActionListener listener) {
        this.prevButton.addActionListener(listener);
    }

    public void addNextLineButtonListener(ActionListener listener) {
        this.nextButton.addActionListener(listener);
    }

    private void jScrollBar1AdjustmentValueChanged(AdjustmentEvent evt) {
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void exitForm(WindowEvent evt) {
    }

    private void initActions() {
        this.jEditorPane1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DiffPanel.this.editorActivated(DiffPanel.this.jEditorPane1);
            }

            public void focusLost(FocusEvent e) {
                DiffPanel.this.editorDeactivated(DiffPanel.this.jEditorPane1);
            }
        });
        this.jEditorPane2.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DiffPanel.this.editorActivated(DiffPanel.this.jEditorPane2);
            }

            public void focusLost(FocusEvent e) {
                DiffPanel.this.editorDeactivated(DiffPanel.this.jEditorPane2);
            }
        });
    }

    private Action getAction(String s, JEditorPane editor) {
        Hashtable<Object, Action> actions;
        if (this.kitActions == null) {
            this.kitActions = new Hashtable();
        }
        if ((actions = (Hashtable<Object, Action>)this.kitActions.get(editor)) == null) {
            EditorKit kit = editor.getEditorKit();
            if (kit == null) {
                return null;
            }
            Action[] a = kit.getActions();
            actions = new Hashtable<Object, Action>(a.length);
            int k = a.length;
            int i = 0;
            while (i < k) {
                actions.put(a[i].getValue("Name"), a[i]);
                ++i;
            }
            this.kitActions.put(editor, actions);
        }
        return (Action)actions.get(s);
    }

    private void editorActivated(final JEditorPane editor) {
        final Action copy = this.getAction("copy-to-clipboard", editor);
        if (copy != null) {
            final CallbackSystemAction sysCopy = (CallbackSystemAction)SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DiffPanel.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction));
            final ActionPerformer perf = new ActionPerformer(){

                public void performAction(SystemAction action) {
                    copy.actionPerformed(new ActionEvent(editor, 0, ""));
                }
            };
            sysCopy.setActionPerformer((ActionPerformer)(copy.isEnabled() ? perf : null));
            PropertyChangeListener copyListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        if (((Boolean)evt.getNewValue()).booleanValue()) {
                            sysCopy.setActionPerformer(perf);
                        } else if (sysCopy.getActionPerformer() == perf) {
                            sysCopy.setActionPerformer(null);
                        }
                    }
                }
            };
            copy.addPropertyChangeListener(copyListener);
            if (editor.equals(this.jEditorPane1)) {
                this.copyL = copyListener;
            } else {
                this.copyP = copyListener;
            }
        }
    }

    private void editorDeactivated(JEditorPane editor) {
        Action copy = this.getAction("copy-to-clipboard", editor);
        PropertyChangeListener copyListener = editor.equals(this.jEditorPane1) ? this.copyL : this.copyP;
        if (copy != null) {
            copy.removePropertyChangeListener(copyListener);
        }
    }

    private void addWindowListener(WindowListener listener) {
        Container ancestor = this.getTopLevelAncestor();
        if (ancestor instanceof Window) {
            ((Window)ancestor).addWindowListener(listener);
        }
    }

    public void open() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffPanel.this.jSplitPane1.setDividerLocation(0.5);
                DiffPanel.this.openPostProcess();
            }
        });
    }

    protected void openPostProcess() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffPanel.this.initGlobalSizes();
                DiffPanel.this.addChangeListeners();
            }
        });
    }

    private void initGlobalSizes() {
        int numLines2;
        StyledDocument doc1 = (StyledDocument)this.jEditorPane1.getDocument();
        StyledDocument doc2 = (StyledDocument)this.jEditorPane2.getDocument();
        int numLines1 = NbDocument.findLineNumber((StyledDocument)doc1, (int)doc1.getEndPosition().getOffset());
        int numLines = Math.max(numLines1, numLines2 = NbDocument.findLineNumber((StyledDocument)doc2, (int)doc2.getEndPosition().getOffset()));
        if (numLines < 1) {
            numLines = 1;
        }
        this.totalLines = numLines;
        int value = this.jEditorPane2.getSize().height;
        int totHeight = this.jEditorPane1.getSize().height;
        if (value > totHeight) {
            totHeight = value;
        }
        this.totalHeight = totHeight;
    }

    private void showLine(int line, int diffLength) {
        this.linesComp1.setActiveLine(line);
        this.linesComp2.setActiveLine(line);
        this.linesComp2.repaint();
        this.linesComp1.repaint();
        int padding = 5;
        if (line <= 5) {
            padding = line / 2;
        }
        int viewHeight = this.jViewport1.getExtentSize().height;
        this.initGlobalSizes();
        Point p1 = this.jViewport1.getViewPosition();
        Point p2 = this.jViewport2.getViewPosition();
        int ypos = this.totalHeight * (line - padding - 1) / (this.totalLines + 1);
        int viewSize = this.jViewport1.getViewRect().y;
        if (ypos < p1.y || ypos + (diffLength + padding) * this.totalHeight / this.totalLines > p1.y + viewHeight) {
            p1.y = ypos;
            p2.y = ypos;
            this.setViewPosition(p1, p2);
        }
        int off1 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane1.getDocument()), (int)line);
        int off2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)this.jEditorPane2.getDocument()), (int)line);
        this.jEditorPane1.setCaretPosition(off1);
        this.jEditorPane2.setCaretPosition(off2);
    }

    private void setViewPosition(Point p1, Point p2) {
        this.jViewport1.setViewPosition(p1);
        this.jViewport1.repaint(this.jViewport1.getViewRect());
        this.jViewport2.setViewPosition(p2);
        this.jViewport2.repaint(this.jViewport2.getViewRect());
    }

    private void joinScrollBars() {
        final JScrollBar scrollBarH1 = this.jScrollPane1.getHorizontalScrollBar();
        final JScrollBar scrollBarV1 = this.jScrollPane1.getVerticalScrollBar();
        final JScrollBar scrollBarH2 = this.jScrollPane2.getHorizontalScrollBar();
        final JScrollBar scrollBarV2 = this.jScrollPane2.getVerticalScrollBar();
        scrollBarV1.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = scrollBarV1.getValue();
                int oldValue = scrollBarV2.getValue();
                if (oldValue != value) {
                    scrollBarV2.setValue(value);
                }
            }
        });
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
        scrollBarV2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = scrollBarV2.getValue();
                int oldValue = scrollBarV1.getValue();
                if (oldValue != value) {
                    scrollBarV1.setValue(value);
                }
            }
        });
        scrollBarH1.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = scrollBarH1.getValue();
                if (value == DiffPanel.this.horizontalScroll1ChangedValue) {
                    return;
                }
                int max1 = scrollBarH1.getMaximum();
                int max2 = scrollBarH2.getMaximum();
                int ext1 = scrollBarH1.getModel().getExtent();
                int ext2 = scrollBarH2.getModel().getExtent();
                if (max1 == ext1) {
                    DiffPanel.this.horizontalScroll2ChangedValue = 0;
                } else {
                    DiffPanel.this.horizontalScroll2ChangedValue = value * (max2 - ext2) / (max1 - ext1);
                }
                DiffPanel.this.horizontalScroll1ChangedValue = -1;
                scrollBarH2.setValue(DiffPanel.this.horizontalScroll2ChangedValue);
            }
        });
        scrollBarH2.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = scrollBarH2.getValue();
                if (value == DiffPanel.this.horizontalScroll2ChangedValue) {
                    return;
                }
                int max1 = scrollBarH1.getMaximum();
                int max2 = scrollBarH2.getMaximum();
                int ext1 = scrollBarH1.getModel().getExtent();
                int ext2 = scrollBarH2.getModel().getExtent();
                if (max2 == ext2) {
                    DiffPanel.this.horizontalScroll1ChangedValue = 0;
                } else {
                    DiffPanel.this.horizontalScroll1ChangedValue = value * (max1 - ext1) / (max2 - ext2);
                }
                DiffPanel.this.horizontalScroll2ChangedValue = -1;
                scrollBarH1.setValue(DiffPanel.this.horizontalScroll1ChangedValue);
            }
        });
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private String strCharacters(char c, int num) {
        StringBuffer s = new StringBuffer();
        while (num-- > 0) {
            s.append(c);
        }
        return s.toString();
    }

    private void customizeEditor(JEditorPane editor) {
        StyledDocument doc;
        EditorKit kit = editor.getEditorKit();
        Document document = editor.getDocument();
        try {
            doc = (StyledDocument)editor.getDocument();
        }
        catch (ClassCastException e) {
            doc = new DefaultStyledDocument();
            try {
                doc.insertString(0, document.getText(0, document.getLength()), null);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            editor.setDocument(doc);
        }
        int lastOffset = doc.getEndPosition().getOffset();
        int numLines = NbDocument.findLineNumber((StyledDocument)doc, (int)lastOffset);
        int numLength = Integer.toString(numLines).length();
        int line = 0;
        while (line <= numLines) {
            int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
            String lineStr = Integer.toString(line + 1);
            if (lineStr.length() < numLength) {
                lineStr = this.strCharacters(' ', numLength - lineStr.length()) + lineStr;
            }
            ++line;
        }
    }

    private void setScrollBarsIncrements() {
        StyledDocument doc = (StyledDocument)this.jEditorPane1.getDocument();
        int lineHeight = this.jEditorPane1.getSize().height / NbDocument.findLineNumber((StyledDocument)doc, (int)doc.getEndPosition().getOffset());
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement((int)(4.0 * (double)lineHeight));
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement((int)(4.0 * (double)lineHeight));
        this.jScrollPane1.getHorizontalScrollBar().setUnitIncrement((int)(4.0 * (double)lineHeight));
        this.jScrollPane2.getHorizontalScrollBar().setUnitIncrement((int)(4.0 * (double)lineHeight));
    }

    private void addChangeListeners() {
        this.jEditorPane1.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        DiffPanel.access$700(13.access$1100(this.this$1));
                        DiffPanel.access$1200(13.access$1100(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffPanel access$1100(13 x0) {
                return x0.DiffPanel.this;
            }
        });
        this.jEditorPane2.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        DiffPanel.access$700(15.access$1300(this.this$1));
                        DiffPanel.access$1400(15.access$1300(this.this$1)).repaint();
                    }
                });
            }

            static /* synthetic */ DiffPanel access$1300(15 x0) {
                return x0.DiffPanel.this;
            }
        });
    }

    public void setSource1(Reader r) throws IOException {
        EditorKit kit = this.jEditorPane1.getEditorKit();
        if (kit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document doc = kit.createDefaultDocument();
        if (!(doc instanceof StyledDocument)) {
            doc = new DefaultStyledDocument(new StyleContext());
            kit = new StyledEditorKit();
            this.jEditorPane1.setEditorKit(kit);
        }
        try {
            try {
                kit.read(r, doc, 0);
            }
            catch (BadLocationException e) {
                throw new IOException("Can not locate the beginning of the document.");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            r.close();
            throw throwable;
        }
        r.close();
        kit.install(this.jEditorPane1);
        this.jEditorPane1.setDocument(doc);
        this.jEditorPane1.setEditable(false);
        this.customizeEditor(this.jEditorPane1);
        this.linesComp1 = new LinesComponent(this.jEditorPane1);
        this.jScrollPane1.setRowHeaderView(this.linesComp1);
        this.jViewport1 = this.jScrollPane1.getViewport();
    }

    public void setSource2(Reader r) throws IOException {
        EditorKit kit = this.jEditorPane2.getEditorKit();
        if (kit == null) {
            throw new IOException("Missing Editor Kit");
        }
        Document doc = kit.createDefaultDocument();
        if (!(doc instanceof StyledDocument)) {
            doc = new DefaultStyledDocument(new StyleContext());
            kit = new StyledEditorKit();
            this.jEditorPane2.setEditorKit(kit);
        }
        try {
            try {
                kit.read(r, doc, 0);
            }
            catch (BadLocationException e) {
                throw new IOException("Can not locate the beginning of the document.");
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            r.close();
            throw throwable;
        }
        r.close();
        kit.install(this.jEditorPane2);
        this.jEditorPane2.setDocument(doc);
        this.jEditorPane2.setEditable(false);
        this.customizeEditor(this.jEditorPane2);
        this.linesComp2 = new LinesComponent(this.jEditorPane2);
        this.jScrollPane2.setRowHeaderView(this.linesComp2);
        this.jViewport2 = this.jScrollPane2.getViewport();
        this.joinScrollBars();
    }

    public void setSource1Title(String title) {
        this.fileLabel1.setText(title);
    }

    public void setSource2Title(String title) {
        this.fileLabel2.setText(title);
    }

    public void setMimeType1(String mime) {
        this.jEditorPane1.setContentType(mime);
        EditorKit kit = JEditorPane.createEditorKitForContentType(mime);
        if (kit == null) {
            kit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane1.setEditorKit(kit);
    }

    public void setMimeType2(String mime) {
        this.jEditorPane2.setContentType(mime);
        EditorKit kit = JEditorPane.createEditorKitForContentType(mime);
        if (kit == null) {
            kit = JEditorPane.createEditorKitForContentType(PLAIN_TEXT_MIME);
        }
        this.jEditorPane2.setEditorKit(kit);
    }

    public void setDocument1(Document doc) {
        if (doc != null) {
            this.jEditorPane1.setDocument(doc);
        }
    }

    public void setDocument2(Document doc) {
        if (doc != null) {
            this.jEditorPane2.setDocument(doc);
        }
    }

    String getDocumentText1() {
        return this.jEditorPane1.getText();
    }

    String getDocumentText2() {
        return this.jEditorPane2.getText();
    }

    private void setHighlight(StyledDocument doc, int line1, int line2, Color color) {
        int line = line1 - 1;
        while (line < line2) {
            int offset;
            if (line >= 0 && (offset = NbDocument.findLineOffset((StyledDocument)doc, (int)line)) >= 0) {
                Style s = doc.getLogicalStyle(offset);
                if (s == null) {
                    s = doc.addStyle("diff-style(" + color + "):1500", null);
                }
                s.addAttribute(StyleConstants.ColorConstants.Background, color);
                doc.setLogicalStyle(offset, s);
            }
            ++line;
        }
    }

    private void unhighlight(StyledDocument doc) {
        int endOffset = doc.getEndPosition().getOffset();
        int endLine = NbDocument.findLineNumber((StyledDocument)doc, (int)endOffset);
        Style s = doc.addStyle("diff-style(white):1500", null);
        s.addAttribute(StyleConstants.ColorConstants.Background, Color.white);
        int line = 0;
        while (line <= endLine) {
            int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
            doc.setLogicalStyle(offset, s);
            ++line;
        }
    }

    public void unhighlightAll() {
        this.unhighlight((StyledDocument)this.jEditorPane1.getDocument());
        this.unhighlight((StyledDocument)this.jEditorPane2.getDocument());
    }

    public void highlightRegion1(int line1, int line2, Color color) {
        StyledDocument doc = (StyledDocument)this.jEditorPane1.getDocument();
        this.setHighlight(doc, line1, line2, color);
    }

    public void highlightRegion2(int line1, int line2, Color color) {
        StyledDocument doc = (StyledDocument)this.jEditorPane2.getDocument();
        this.setHighlight(doc, line1, line2, color);
    }

    private void addEmptyLines(StyledDocument doc, int line, int numLines) {
        int lastOffset = doc.getEndPosition().getOffset();
        int totLines = NbDocument.findLineNumber((StyledDocument)doc, (int)lastOffset);
        int offset = lastOffset - 1;
        if (line <= totLines) {
            offset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
        }
        String insStr = this.strCharacters('\n', numLines);
        try {
            doc.insertString(offset, insStr, null);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public void addEmptyLines1(int line, int numLines) {
        StyledDocument doc = (StyledDocument)this.jEditorPane1.getDocument();
        this.addEmptyLines(doc, line, numLines);
        this.linesComp1.addEmptyLines(line, numLines);
    }

    public void addEmptyLines2(int line, int numLines) {
        StyledDocument doc = (StyledDocument)this.jEditorPane2.getDocument();
        this.addEmptyLines(doc, line, numLines);
        this.linesComp2.addEmptyLines(line, numLines);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ LinesComponent access$1200(DiffPanel x0) {
        return x0.linesComp1;
    }

    static /* synthetic */ LinesComponent access$1400(DiffPanel x0) {
        return x0.linesComp2;
    }
}

