/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.LinkedList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class LinesComponent
extends JComponent
implements Accessible {
    private JEditorPane editorPane;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private int lineHeight = 1;
    private float lineHeightCorrection = 1.0f;
    private boolean init = false;
    private int numberWidth;
    private boolean showLineNumbers = true;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private Insets lineNumberMargin;
    private int lineNumberDigitWidth;
    private int lineAscent;
    private LinkedList linesList;
    private int activeLine = -1;
    private static final long serialVersionUID = -4861542695772182147L;
    static /* synthetic */ Class class$org$netbeans$modules$diff$builtin$visualizer$LinesComponent;

    public LinesComponent(JEditorPane pane) {
        this.editorPane = pane;
        this.font = this.editorPane.getFont();
        this.foreColor = this.editorPane.getForeground();
        this.backgroundColor = this.editorPane.getBackground();
        this.setLineNumberDigitWidth(10);
        this.setLineNumberMargin(new Insets(2, 2, 2, 4));
        this.init();
        this.update();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        this.createLines();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$LinesComponent == null ? (class$org$netbeans$modules$diff$builtin$visualizer$LinesComponent = LinesComponent.class$("org.netbeans.modules.diff.builtin.visualizer.LinesComponent")) : class$org$netbeans$modules$diff$builtin$visualizer$LinesComponent), (String)"ACSN_Lines_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$builtin$visualizer$LinesComponent == null ? (class$org$netbeans$modules$diff$builtin$visualizer$LinesComponent = LinesComponent.class$("org.netbeans.modules.diff.builtin.visualizer.LinesComponent")) : class$org$netbeans$modules$diff$builtin$visualizer$LinesComponent), (String)"ACSD_Lines_Component"));
    }

    private void createLines() {
        this.linesList = new LinkedList();
        StyledDocument doc = (StyledDocument)this.editorPane.getDocument();
        int lastOffset = doc.getEndPosition().getOffset();
        int lineCnt = NbDocument.findLineNumber((StyledDocument)doc, (int)lastOffset);
        int i = 0;
        while (i < lineCnt) {
            this.linesList.add("" + (i + 1));
            ++i;
        }
    }

    public void addEmptyLines(int line, int count) {
        boolean appending = line > this.linesList.size();
        int i = 0;
        while (i < count) {
            if (appending) {
                this.linesList.add("");
            } else {
                this.linesList.add(line, "");
            }
            ++i;
        }
    }

    public void insertNumbers(int line, int startNum, int count) {
        boolean appending;
        boolean bl = appending = line >= this.linesList.size();
        if (appending) {
            int i = 0;
            while (i < count) {
                this.linesList.add(Integer.toString(startNum));
                ++i;
                ++startNum;
            }
        } else {
            int toAdd = Math.max(line + count - this.linesList.size(), 0);
            count -= toAdd;
            int i = 0;
            while (i < count) {
                this.linesList.set(line, Integer.toString(startNum));
                ++i;
                ++startNum;
                ++line;
            }
            int i2 = 0;
            while (i2 < toAdd) {
                this.linesList.add(Integer.toString(startNum));
                ++i2;
                ++startNum;
            }
        }
    }

    public void removeNumbers(int line, int count) {
        boolean appending;
        boolean bl = appending = line >= this.linesList.size();
        if (appending) {
            int i = 0;
            while (i < count) {
                this.linesList.add("");
                ++i;
            }
        } else {
            int toAdd = Math.max(line + count - this.linesList.size(), 0);
            count -= toAdd;
            int i = 0;
            while (i < count) {
                this.linesList.set(line, "");
                ++i;
                ++line;
            }
            int i2 = 0;
            while (i2 < toAdd) {
                this.linesList.add("");
                ++i2;
            }
        }
    }

    public void shrink(int numLines) {
        while (this.linesList.size() > numLines) {
            this.linesList.remove(numLines);
        }
    }

    private void update() {
        Class<?> kitClass = this.editorPane.getEditorKit().getClass();
        Object value = Settings.getValue(kitClass, (String)"line-height-correction");
        if (!(value instanceof Float) || ((Float)value).floatValue() < 0.0f) {
            value = SettingsDefaults.defaultLineHeightCorrection;
        }
        this.lineHeightCorrection = ((Float)value).floatValue();
        Object colValue = Settings.getValue(kitClass, (String)"line-number");
        Coloring col = null;
        col = colValue != null && colValue instanceof Coloring ? (Coloring)colValue : SettingsDefaults.defaultLineNumberColoring;
        this.foreColor = col.getForeColor();
        this.backgroundColor = col.getBackColor();
        this.font = this.editorPane.getFont();
        FontMetrics fm = ((Component)this.editorPane).getFontMetrics(this.font);
        int maxHeight = 1;
        int maxAscent = 0;
        if (fm != null) {
            maxHeight = Math.max(maxHeight, fm.getHeight());
            maxAscent = Math.max(maxAscent, fm.getAscent());
        }
        this.lineHeight = (int)((float)maxHeight * this.lineHeightCorrection);
        this.lineAscent = (int)((float)maxAscent * this.lineHeightCorrection);
        this.showLineNumbers = true;
        this.init = true;
        if (this.highestLineNumber <= this.getLineCount()) {
            this.highestLineNumber = this.getLineCount();
        }
        int maxWidth = 1;
        char[] digit = new char[1];
        int i = 0;
        while (i <= 9) {
            digit[0] = (char)(48 + i);
            maxWidth = Math.max(maxWidth, fm.charsWidth(digit, 0, 1));
            ++i;
        }
        this.setLineNumberDigitWidth(maxWidth);
        this.resize();
    }

    protected void resize() {
        Dimension dim = new Dimension();
        dim.width = this.getWidthDimension();
        dim.height = this.getHeightDimension();
        dim.height += 300 * this.lineHeight;
        this.numberWidth = this.getLineNumberWidth();
        this.setPreferredSize(dim);
        this.revalidate();
    }

    protected int getLineCount() {
        return this.linesList.size();
    }

    protected int getDigitCount(int number) {
        return Integer.toString(number).length();
    }

    protected int getLineNumberWidth() {
        int newWidth = 0;
        Insets insets = this.getLineNumberMargin();
        if (insets != null) {
            newWidth += insets.left + insets.right;
        }
        return newWidth += (this.getDigitCount(this.highestLineNumber) + 1) * this.getLineNumberDigitWidth();
    }

    protected int getWidthDimension() {
        int newWidth = 0;
        if (this.showLineNumbers) {
            newWidth += this.getLineNumberWidth();
        }
        return newWidth;
    }

    protected int getHeightDimension() {
        return this.highestLineNumber * this.lineHeight;
    }

    /*
     * Unable to fully structure code
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.update();
        if (!this.init) {
            return;
        }
        drawHere = g.getClipBounds();
        g.setColor(this.backgroundColor);
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(this.font);
        g.setColor(this.foreColor);
        fm = FontMetricsCache.getFontMetrics((Font)this.font, (Component)this);
        rightMargin = 0;
        margin = this.getLineNumberMargin();
        if (margin != null) {
            rightMargin = margin.right;
        }
        if ((line = (int)((float)drawHere.y / (float)this.lineHeight)) > 0) {
            --line;
        }
        y = line * this.lineHeight;
        if (!this.showLineNumbers || (lastLine = (int)((float)(drawHere.y + drawHere.height) / (float)this.lineHeight) + 1) <= this.highestLineNumber) ** GOTO lbl38
        prevHighest = this.highestLineNumber;
        this.highestLineNumber = lastLine;
        if (this.getDigitCount(this.highestLineNumber) <= this.getDigitCount(prevHighest)) ** GOTO lbl38
        this.resize();
        return;
lbl-1000:
        // 1 sources

        {
            if (this.showLineNumbers) {
                lineStr = null;
                if (line < this.linesList.size()) {
                    lineStr = (String)this.linesList.get(line);
                }
                if (lineStr == null) {
                    lineStr = "";
                }
                activeSymbol = "*";
                lineNumberWidth = fm.stringWidth(lineStr);
                if (line == this.activeLine - 1) {
                    lineStr = lineStr + activeSymbol;
                }
                activeSymbolWidth = fm.stringWidth(activeSymbol);
                g.drawString(lineStr, this.numberWidth - (lineNumberWidth += activeSymbolWidth) - rightMargin, y + this.getLineAscent());
            }
            y += this.lineHeight;
            ++line;
lbl38:
            // 3 sources

            ** while (y + this.lineHeight / 2 <= drawHere.y + drawHere.height)
        }
lbl39:
        // 1 sources

    }

    public void changedLine(int line) {
        if (!this.init) {
            return;
        }
        if (line > 0) {
            --line;
        }
        int y = line * this.lineHeight;
        this.repaint(0, y, (int)this.getSize().getWidth(), 3 * this.lineHeight);
        this.checkSize();
    }

    public void changedAll() {
        if (!this.init) {
            return;
        }
        this.repaint();
        this.checkSize();
    }

    protected void checkSize() {
        int count = this.getLineCount();
        if (count > this.highestLineNumber) {
            this.highestLineNumber = count;
        }
        Dimension dim = this.getPreferredSize();
        if (this.getWidthDimension() > dim.width || this.getHeightDimension() > dim.height) {
            this.resize();
        }
    }

    public Insets getLineNumberMargin() {
        return this.lineNumberMargin;
    }

    public void setLineNumberMargin(Insets lineNumberMargin) {
        this.lineNumberMargin = lineNumberMargin;
    }

    public int getLineNumberDigitWidth() {
        return this.lineNumberDigitWidth;
    }

    public void setLineNumberDigitWidth(int lineNumberDigitWidth) {
        this.lineNumberDigitWidth = lineNumberDigitWidth;
    }

    public int getLineAscent() {
        return this.lineAscent;
    }

    public void setLineAscent(int lineAscent) {
        this.lineAscent = lineAscent;
    }

    public int getActiveLine() {
        return this.activeLine;
    }

    public void setActiveLine(int activeLine) {
        this.activeLine = activeLine;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

