/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.cmdline;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.api.diff.Difference;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CmdlineDiffProvider
extends DiffProvider
implements Serializable {
    public static final String DIFF_REGEXP = "(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)";
    private static final int BUFF_LENGTH = 1024;
    private String diffCmd;
    private transient RE pattern;
    static final long serialVersionUID = 4101521743158176210L;
    static /* synthetic */ Class class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider;

    public CmdlineDiffProvider(String diffCmd) {
        this.diffCmd = diffCmd;
        try {
            this.pattern = new RE(DIFF_REGEXP);
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
    }

    public static CmdlineDiffProvider createDefault() {
        return new CmdlineDiffProvider("diff {0} {1}");
    }

    public void setDiffCommand(String diffCmd) {
        this.diffCmd = diffCmd;
    }

    public String getDiffCommand() {
        return this.diffCmd;
    }

    private static boolean checkEmpty(String str, String element) {
        return str == null || str.length() == 0;
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider == null ? (class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider = CmdlineDiffProvider.class$("org.netbeans.modules.diff.cmdline.CmdlineDiffProvider")) : class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider), (String)"displayName");
    }

    public String getShortDescription() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider == null ? (class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider = CmdlineDiffProvider.class$("org.netbeans.modules.diff.cmdline.CmdlineDiffProvider")) : class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider), (String)"shortDescription");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Difference[] computeDiff(Reader r1, Reader r2) throws IOException {
        Difference[] differenceArray;
        File f2;
        block5: {
            File f1 = null;
            f2 = null;
            try {
                int length;
                f1 = File.createTempFile("TempDiff".intern(), null);
                f2 = File.createTempFile("TempDiff".intern(), null);
                FileWriter fw1 = new FileWriter(f1);
                FileWriter fw2 = new FileWriter(f2);
                char[] buffer = new char[1024];
                while ((length = r1.read(buffer)) > 0) {
                    void var8_8;
                    fw1.write(buffer, 0, (int)var8_8);
                }
                while ((length = r2.read(buffer)) > 0) {
                    fw2.write(buffer, 0, length);
                }
                r1.close();
                r2.close();
                fw1.close();
                fw2.close();
                differenceArray = this.createDiff(f1, f2);
                Object var11_10 = null;
                if (f1 == null) break block5;
                f1.delete();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (f1 != null) {
                    f1.delete();
                }
                if (f2 == null) throw throwable;
                f2.delete();
                throw throwable;
            }
        }
        if (f2 == null) return differenceArray;
        f2.delete();
        return differenceArray;
    }

    public Difference[] computeDiff(FileObject fo1, FileObject fo2) throws IOException {
        File f1 = FileUtil.toFile((FileObject)fo1);
        File f2 = FileUtil.toFile((FileObject)fo2);
        if (f1 != null && f2 != null) {
            return this.createDiff(f1, f2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Difference[] createDiff(File f1, File f2) throws IOException {
        StringBuffer firstText = new StringBuffer();
        StringBuffer secondText = new StringBuffer();
        if (this.pattern == null) {
            try {
                this.pattern = new RE(DIFF_REGEXP);
            }
            catch (RESyntaxException resex) {
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), resex.getLocalizedMessage());
            }
        }
        String cmd = MessageFormat.format(this.diffCmd, f1.getAbsolutePath(), f2.getAbsolutePath());
        try {
            int length;
            Process p = Runtime.getRuntime().exec(cmd);
            InputStreamReader stdout = new InputStreamReader(p.getInputStream());
            char[] buffer = new char[1024];
            StringBuffer outBuffer = new StringBuffer();
            ArrayList differences = new ArrayList();
            while ((length = stdout.read(buffer)) > 0) {
                void var10_13;
                int i = 0;
                while (i < var10_13) {
                    if (buffer[i] == '\n') {
                        CmdlineDiffProvider.outputLine(outBuffer.toString(), this.pattern, differences, firstText, secondText);
                        outBuffer.delete(0, outBuffer.length());
                    } else if (buffer[i] != '\r') {
                        outBuffer.append(buffer[i]);
                    }
                    ++i;
                }
            }
            if (outBuffer.length() > 0) {
                CmdlineDiffProvider.outputLine(outBuffer.toString(), this.pattern, differences, firstText, secondText);
            }
            CmdlineDiffProvider.setTextOnLastDifference(differences, firstText, secondText);
            return differences.toArray(new Difference[differences.size()]);
        }
        catch (IOException ioex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)ioex, NbBundle.getMessage((Class)(class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider == null ? (class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider = CmdlineDiffProvider.class$("org.netbeans.modules.diff.cmdline.CmdlineDiffProvider")) : class$org$netbeans$modules$diff$cmdline$CmdlineDiffProvider), (String)"runtimeError", (Object)cmd));
        }
    }

    public static void setTextOnLastDifference(List differences, StringBuffer firstText, StringBuffer secondText) {
        if (differences.size() > 0) {
            String t2;
            String t1 = firstText.toString();
            if (t1.length() == 0) {
                t1 = null;
            }
            if ((t2 = secondText.toString()).length() == 0) {
                t2 = null;
            }
            Difference d = (Difference)differences.remove(differences.size() - 1);
            differences.add(new Difference(d.getType(), d.getFirstStart(), d.getFirstEnd(), d.getSecondStart(), d.getSecondEnd(), t1, t2));
            firstText.delete(0, firstText.length());
            secondText.delete(0, secondText.length());
        }
    }

    public static void outputLine(String elements, RE pattern, List differences, StringBuffer firstText, StringBuffer secondText) {
        int index = 0;
        int commaIndex = 0;
        int n1 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!pattern.match(elements)) {
            if (elements.startsWith("< ")) {
                firstText.append(elements.substring(2) + "\n");
            }
            if (elements.startsWith("> ")) {
                secondText.append(elements.substring(2) + "\n");
            }
            return;
        }
        CmdlineDiffProvider.setTextOnLastDifference(differences, firstText, secondText);
        index = elements.indexOf(97);
        if (index >= 0) {
            try {
                n1 = Integer.parseInt(elements.substring(0, index));
                commaIndex = elements.indexOf(44, ++index);
                if (commaIndex < 0) {
                    String nStr = elements.substring(index, elements.length());
                    if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                        return;
                    }
                    n4 = n3 = Integer.parseInt(nStr);
                } else {
                    String nStr = elements.substring(index, commaIndex);
                    if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                        return;
                    }
                    n3 = Integer.parseInt(nStr);
                    nStr = elements.substring(commaIndex + 1, elements.length());
                    n4 = nStr == null || nStr.length() == 0 ? n3 : Integer.parseInt(nStr);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
            differences.add(new Difference(1, n1, 0, n3, n4));
        } else {
            index = elements.indexOf(100);
            if (index >= 0) {
                commaIndex = elements.lastIndexOf(44, index);
                try {
                    String nStr;
                    if (commaIndex < 0) {
                        n2 = n1 = Integer.parseInt(elements.substring(0, index));
                    } else {
                        nStr = elements.substring(0, commaIndex);
                        if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                            return;
                        }
                        n1 = Integer.parseInt(nStr);
                        nStr = elements.substring(commaIndex + 1, index);
                        if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                            return;
                        }
                        n2 = Integer.parseInt(nStr);
                    }
                    nStr = elements.substring(index + 1, elements.length());
                    if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                        return;
                    }
                    n3 = Integer.parseInt(nStr);
                }
                catch (NumberFormatException e) {
                    return;
                }
                differences.add(new Difference(0, n1, n2, n3, 0));
            } else {
                index = elements.indexOf(99);
                if (index >= 0) {
                    commaIndex = elements.lastIndexOf(44, index);
                    try {
                        String nStr;
                        if (commaIndex < 0) {
                            n2 = n1 = Integer.parseInt(elements.substring(0, index));
                        } else {
                            nStr = elements.substring(0, commaIndex);
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n1 = Integer.parseInt(nStr);
                            nStr = elements.substring(commaIndex + 1, index);
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n2 = Integer.parseInt(nStr);
                        }
                        commaIndex = elements.indexOf(44, ++index);
                        if (commaIndex < 0) {
                            nStr = elements.substring(index, elements.length());
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n4 = n3 = Integer.parseInt(nStr);
                        } else {
                            nStr = elements.substring(index, commaIndex);
                            if (CmdlineDiffProvider.checkEmpty(nStr, elements)) {
                                return;
                            }
                            n3 = Integer.parseInt(nStr);
                            nStr = elements.substring(commaIndex + 1, elements.length());
                            n4 = nStr == null || nStr.length() == 0 ? n3 : Integer.parseInt(nStr);
                        }
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                    differences.add(new Difference(2, n1, n2, n3, n4));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

