/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.AbstractCodeGeneratorClass;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.CodeGeneratorClass;
import org.netbeans.modules.schema2beans.CodeGeneratorFactory;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DataEnumRestriction;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphLink;
import org.netbeans.modules.schema2beans.GraphNode;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.TreeParser;
import org.netbeans.modules.schema2beans.gen.JavaUtil;
import org.netbeans.modules.schema2beans.gen.JavaWriter;
import org.netbeans.modules.schema2beans.metadd.MetaDD;
import org.netbeans.modules.schema2beans.metadd.MetaElement;
import org.netbeans.modules.schema2beans.metadd.MetaProperty;
import org.xml.sax.SAXException;

public class BeanBuilder {
    private GenBeans.Config config;
    private CodeGeneratorFactory codeGenFactory;
    protected Map illegalClassNames = new HashMap();
    TreeParser parser;

    BeanBuilder(TreeParser parser, GenBeans.Config config, CodeGeneratorFactory cgf) {
        this.parser = parser;
        this.config = config;
        this.codeGenFactory = cgf;
        this.illegalClassNames.put("Class", null);
        this.illegalClassNames.put("Package", null);
        this.illegalClassNames.put("String", null);
        this.illegalClassNames.put("Boolean", null);
        this.illegalClassNames.put("Integer", null);
        this.illegalClassNames.put("Long", null);
        this.illegalClassNames.put("Short", null);
        this.illegalClassNames.put("Double", null);
        this.illegalClassNames.put("Float", null);
        this.illegalClassNames.put("Byte", null);
        this.illegalClassNames.put("Character", null);
        this.illegalClassNames.put("int", null);
        this.illegalClassNames.put("char", null);
        this.illegalClassNames.put("byte", null);
        this.illegalClassNames.put("short", null);
        this.illegalClassNames.put("long", null);
        this.illegalClassNames.put("double", null);
        this.illegalClassNames.put("float", null);
        this.illegalClassNames.put("boolean", null);
        this.illegalClassNames.put("void", null);
    }

    private void buildProperties(GraphLink l, CodeGeneratorClass bc, int nestedLevel, int groupInstance, MetaElement e, MetaDD mdd, Map usedNames) {
        while (l != null) {
            if (this.config.getTraceGen()) {
                this.config.messageOut.println("buildProperties: l=" + l + " l.name=" + l.name + " l.element=" + l.element + " l.sibling=" + l.sibling);
            }
            if (l.element != null) {
                String dtdName;
                String name;
                BeanElement be = (BeanElement)l.element.getObject();
                boolean ored = false;
                if (be == null) {
                    this.config.messageOut.println("Warning: be was null");
                    continue;
                }
                if (l.parent != null) {
                    ored = l.parent.isSequenceOr();
                }
                if (l.name != null) {
                    name = Common.convertName(l.name);
                    dtdName = l.name;
                } else {
                    name = be.getName();
                    dtdName = be.getDTDName();
                }
                MetaElement propertyME = this.getMetaElement(mdd, dtdName);
                if (propertyME != null && propertyME.getBeanName() != null) {
                    name = propertyME.getBeanName();
                    if (this.config.getTraceGen()) {
                        this.config.messageOut.println("buildProperties: property in " + e.getBeanName() + " has been renamed to " + name);
                    }
                }
                String constName = Common.constName(dtdName);
                if ("#PCDATA".equals(dtdName)) {
                    name = "pcdata";
                    constName = "PCDATA";
                }
                if (usedNames.containsKey(name)) {
                    int uniqNum = 2;
                    String baseName = name;
                    while (usedNames.containsKey(name = baseName + uniqNum)) {
                        ++uniqNum;
                    }
                    constName = constName + uniqNum;
                    if (l.name != null) {
                        l.name = l.name + uniqNum;
                    } else {
                        be.setName(name);
                        MetaElement origE = this.getMetaElement(mdd, dtdName);
                        if (origE != null) {
                            MetaElement newE = new MetaElement(origE);
                            mdd.addMetaElement(newE);
                        }
                    }
                    this.config.messageOut.println(Common.getMessage("RenamedProperty_msg", baseName, name));
                }
                usedNames.put(name, be);
                if (this.config.getTraceGen()) {
                    this.config.messageOut.println("buildProperties: name=" + name + " constName=" + constName + " dtdName=" + dtdName + " graphlink.name=" + l.name + " be.getClassType=" + be.getClassType());
                }
                AttrProp[] attrs = be.node.getAttributes();
                List extraData = l.extraData;
                AbstractCodeGeneratorClass.Property prop = bc.addProperty(name, dtdName, l.element, l, be.getClassType(), nestedLevel, l.getElementInstance(), groupInstance, be.type, ored, attrs, constName, l.getDefaultValue(), true, extraData);
                prop.setCanBeEmpty(be.getCanBeEmpty());
                l.setObject(prop);
                if (e != null) {
                    MetaProperty[] metaProperties = e.getMetaProperty();
                    boolean found = false;
                    int i = 0;
                    while (i < metaProperties.length) {
                        if (name.equals(metaProperties[i].getBeanName())) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        MetaProperty mp = new MetaProperty();
                        mp.setBeanName(name);
                        e.addMetaProperty(mp);
                    }
                }
                if (!Common.isBean(be.type) && this.config.getAttributesAsProperties()) {
                    this.addAttrProps(bc, attrs, name, usedNames, false);
                }
            }
            this.buildProperties(l.child, bc, nestedLevel + 1, l.getGroupInstance(), e, mdd, usedNames);
            l = l.sibling;
        }
    }

    protected void addAttrProps(CodeGeneratorClass bc, AttrProp[] attrs, String propertyName, Map usedNames, boolean directChild) {
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                this.addAttrProp(bc, attrs[i], propertyName, usedNames, directChild);
                ++i;
            }
        }
    }

    protected void addAttrProp(CodeGeneratorClass bc, AttrProp attr, String propertyName, Map usedNames, boolean directChild) {
        int type;
        String name = directChild ? Common.convertName(attr.getName()) : Common.convertName(propertyName + "_" + attr.getName());
        if (usedNames.containsKey(name)) {
            int uniqNum = 2;
            String baseName = name;
            while (usedNames.containsKey(name = baseName + uniqNum)) {
                ++uniqNum;
            }
            this.config.messageOut.println(Common.getMessage("RenamedProperty_msg", baseName, name));
        }
        usedNames.put(name, attr);
        String javaType = attr.getJavaType();
        if (javaType == null) {
            type = 256;
            javaType = "java.lang.String";
        } else {
            type = Common.wrapperToType(javaType);
            if (type == 0) {
                type = 256;
            }
        }
        bc.addProperty(name, attr.getDtdName(), null, null, javaType, 0, attr.getInstance(), 0, type, false, null, Common.constName(name), attr.getDefaultValue(), directChild, Collections.EMPTY_LIST).setAttrProp(attr);
    }

    protected void addCommentsProcessing(CodeGeneratorClass bc) {
        bc.addProperty("Comments", "comment", null, null, "java.lang.String", 0, 48, 0, 3840, false, null, "COMMENTS", null, true, Collections.EMPTY_LIST);
    }

    void process() throws IOException {
        CodeGeneratorClass bc;
        String commonInterface;
        BeanElement be;
        GraphNode root = this.parser.getRoot();
        GraphNode[] list = this.parser.getNodes();
        MetaDD mdd = null;
        FileOutputStream mddOut = null;
        boolean genMDD = false;
        if (root == null) {
            throw new IllegalStateException(Common.getMessage("DTDObjectGraphIsNull_msg"));
        }
        int i = 0;
        while (i < list.length) {
            GraphNode node = list[i];
            be = new BeanElement(node);
            be.initialize(node == root);
            node.setObject(be);
            ++i;
        }
        root.getGraphLink().calculateLastInGroup();
        String rootDir = this.config.rootDir;
        String packagePath = this.config.packagePath;
        if (rootDir == null) {
            rootDir = ".";
        }
        BeanElement rootElement = (BeanElement)root.getObject();
        if (packagePath == null) {
            packagePath = rootElement.getName().toLowerCase();
        }
        String genDir = rootDir.equals("") ? packagePath : (!rootDir.equals("/") ? (packagePath == null || packagePath.equals("") ? rootDir : rootDir + "/" + packagePath) : "/" + packagePath);
        String packageName = null;
        if (packagePath != null) {
            packageName = packagePath.replace('/', '.');
        }
        if (this.config.mddFile != null || this.config.mddIn != null) {
            File file = null;
            if (this.config.mddFile != null) {
                file = new File(this.config.mddFile);
            }
            if (this.config.mddIn == null && !file.exists()) {
                if (!this.config.auto) {
                    String str;
                    this.config.messageOut.print("The mdd file " + this.config.mddFile + " doesn't exist. Should we create it (y/n) ?");
                    BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        str = rd.readLine();
                    }
                    catch (IOException e) {
                        this.config.messageOut.println("Got unexpected exception: " + e.getMessage());
                        str = "n";
                    }
                    if (!str.equals("y")) {
                        this.config.messageOut.println("Generation aborted.");
                        return;
                    }
                }
                try {
                    mddOut = new FileOutputStream(this.config.mddFile);
                    mdd = new MetaDD();
                    genMDD = true;
                }
                catch (IOException e) {
                    throw new IOException(Common.getMessage("CantCreateFile_msg", this.config.mddFile, e.getMessage()));
                }
            }
            try {
                if (this.config.mddIn == null) {
                    this.config.mddIn = new FileInputStream(this.config.mddFile);
                    this.config.messageOut.println(Common.getMessage("MSG_UsingMdd", this.config.mddFile));
                }
                mdd = MetaDD.read(this.config.mddIn);
            }
            catch (IOException e) {
                throw new IOException(Common.getMessage("CantCreateMetaDDFile_msg", e.getMessage()));
            }
            catch (ParserConfigurationException e) {
                throw new IOException(Common.getMessage("CantCreateMetaDDFile_msg", e.getMessage()));
            }
            catch (SAXException e) {
                throw new IOException(Common.getMessage("CantCreateMetaDDFile_msg", e.getMessage()));
            }
        }
        mdd = new MetaDD();
        if (!genMDD && this.config.outputStreamProvider instanceof GenBeans.DefaultOutputStreamProvider) {
            File dir = new File(genDir);
            if (dir.exists() && !dir.isDirectory()) {
                throw new Schema2BeansRuntimeException(Common.getMessage("CantCreateDirIsFile_msg", dir));
            }
            if (!dir.exists() && dir.mkdirs()) {
                this.config.messageOut.println(Common.getMessage("MSG_CreatedDirectory", dir));
            }
        }
        if ((commonInterface = this.config.getGenerateCommonInterface()) != null) {
            this.illegalClassNames.put(commonInterface, "Common Bean Interface");
            if (packageName != null) {
                commonInterface = packageName + "." + commonInterface;
            }
        }
        int i2 = 0;
        while (i2 < list.length) {
            MetaElement e = null;
            GraphNode graphNode = list[i2];
            String suggestedJavaType = graphNode.getJavaType();
            be = (BeanElement)graphNode.getObject();
            if (be != null) {
                e = this.getMetaElement(mdd, be.getDTDName(), graphNode.getNamespace());
                if (e == null) {
                    e = new MetaElement();
                    e.setBeanName(be.getName());
                    e.setDtdName(be.getDTDName());
                    e.setNamespace(graphNode.getNamespace());
                    mdd.addMetaElement(e);
                }
                if (e.getBeanName() != null && !e.getBeanName().equals("")) {
                    be.setClassType(e.getBeanName());
                    be.setName(e.getBeanName());
                }
                if (e.getWrapperClass() != null) {
                    suggestedJavaType = e.getWrapperClass();
                    graphNode.setCreated(false);
                } else if (suggestedJavaType != null) {
                    e.setWrapperClass(suggestedJavaType);
                } else if (be != rootElement && Common.isScalar(be.type)) {
                    e.setWrapperClass(Common.wrapperClass(be.type));
                    suggestedJavaType = e.getWrapperClass();
                } else if (be != rootElement && !Common.isBean(be.type)) {
                    e.setWrapperClass(be.typeToString());
                    suggestedJavaType = e.getWrapperClass();
                }
                if (suggestedJavaType != null) {
                    int proposedType = Common.wrapperToType(suggestedJavaType);
                    if (proposedType != 0) {
                        be.type = proposedType;
                    }
                    be.setClassType(suggestedJavaType);
                }
                if (be.isBean()) {
                    while (this.illegalClassNames.containsKey(be.getClassType())) {
                        String prefix = "My";
                        if (graphNode.getNamespace() != null) {
                            prefix = Common.convertName(graphNode.getNamespace());
                        }
                        be.setClassType(prefix + be.getClassType());
                        be.setName(prefix + be.getName());
                        e.setBeanName(prefix + e.getBeanName());
                        if (!this.config.getTraceGen()) continue;
                        System.out.println("Made class name change to " + be.getClassType());
                    }
                    this.illegalClassNames.put(be.getClassType(), be);
                    if (graphNode.getExtendedProperty("extends") != null && e.getExtends() == null) {
                        e.setExtends((String)graphNode.getExtendedProperty("extends"));
                    }
                    if (graphNode.getExtendedProperty("implements") != null && e.getImplements() == null) {
                        e.setImplements((String)graphNode.getExtendedProperty("implements"));
                    }
                    if (this.config.isGenerateInterfaces()) {
                        String interfaceName = be.getName() + "Interface";
                        if (packageName != null) {
                            interfaceName = packageName + "." + interfaceName;
                        }
                        this.addToImplements(e, interfaceName);
                    }
                    if (commonInterface != null) {
                        this.addToImplements(e, commonInterface);
                    }
                }
            }
            ++i2;
        }
        HashMap<BeanElement, CodeGeneratorClass> generators = new HashMap<BeanElement, CodeGeneratorClass>();
        HashMap<String, BeanElement> usedTypes = new HashMap<String, BeanElement>();
        int i3 = 0;
        while (i3 < list.length) {
            MetaElement e = null;
            be = (BeanElement)list[i3].getObject();
            if (be != null) {
                if (be.getGraphNode().isCreated() && (be.isBean() || be == rootElement)) {
                    GraphNode graphNode = be.getGraphNode();
                    if (this.config.getTraceGen()) {
                        this.config.messageOut.println("Building properties for " + be);
                    }
                    e = this.getMetaElement(mdd, be.getDTDName(), graphNode.getNamespace());
                    HashMap usedNames = new HashMap();
                    bc = this.codeGenFactory.newCodeGeneratorClass(be, this.config);
                    bc.setPackageName(packageName);
                    bc.setIndent(this.config.indent);
                    bc.setRootBeanElement(rootElement);
                    bc.setDefaultNamespace(this.parser.getDefaultNamespace());
                    bc.setInvalidPropertyNames(usedNames);
                    if (this.config.getProcessComments()) {
                        this.addCommentsProcessing(bc);
                    }
                    if (this.config.getAttributesAsProperties()) {
                        this.addAttrProps(bc, be.node.getAttributes(), be.getName(), usedNames, true);
                    }
                    if (be.isBean()) {
                        this.buildProperties(be.getGraphNode().getGraphLink(), bc, 0, 0, e, mdd, usedNames);
                    }
                    generators.put(be, bc);
                }
                usedTypes.put(be.getClassType(), be);
            }
            ++i3;
        }
        rootElement.setUsedTypes(usedTypes);
        if (!genMDD) {
            JavaWriter.Method method;
            Iterator mit;
            LinkedList<Collection> generatedMethods = new LinkedList<Collection>();
            Iterator it = generators.keySet().iterator();
            while (it.hasNext()) {
                be = (BeanElement)it.next();
                CodeGeneratorClass bc2 = (CodeGeneratorClass)generators.get(be);
                String outputFileName = be.isBean() ? be.getClassType() : be.getName();
                try {
                    OutputStream out = this.config.outputStreamProvider.getStream(genDir, outputFileName, "java");
                    bc2.generate(out, mdd);
                    out.close();
                    out = null;
                    Collection beansMethods = bc2.getGeneratedMethods();
                    generatedMethods.add(beansMethods);
                    if (this.config.generateDelegator) {
                        String delegatorClassName;
                        GraphNode graphNode = be.getGraphNode();
                        MetaElement e = this.getMetaElement(mdd, be.getDTDName(), graphNode.getNamespace());
                        if (e != null && e.getDelegatorName() != null) {
                            delegatorClassName = e.getDelegatorName();
                        } else {
                            delegatorClassName = outputFileName + "Delegator";
                            if (e != null) {
                                e.setDelegatorName(delegatorClassName);
                            }
                        }
                        out = this.config.outputStreamProvider.getStream(genDir, delegatorClassName, "java");
                        bc2.generateDelegator(out, mdd, delegatorClassName);
                        out.close();
                        out = null;
                    }
                    if (!this.config.isGenerateInterfaces()) continue;
                    ArrayList<JavaWriter.Method> beanInfoMethods = new ArrayList<JavaWriter.Method>(beansMethods.size());
                    mit = beansMethods.iterator();
                    while (mit.hasNext()) {
                        method = (JavaWriter.Method)mit.next();
                        if (method.isStatic() || method.isConstructor() || !method.isPublic() || !method.isBeanInfo()) continue;
                        beanInfoMethods.add(method);
                    }
                    String interfaceName = outputFileName + "Interface";
                    this.generateInterface(genDir, packageName, interfaceName, beanInfoMethods, "This interface has all of the bean info accessor methods.");
                }
                catch (IOException ioe) {
                    this.config.messageOut.println("Failed to generate bean class: " + outputFileName);
                    TraceLogger.error(ioe);
                    throw ioe;
                }
                catch (IllegalStateException ise) {
                    this.config.messageOut.println("Failed to generate bean class " + outputFileName);
                    TraceLogger.error(ise);
                    throw ise;
                }
            }
            if (this.config.getGenerateCommonInterface() != null && generatedMethods.size() > 0) {
                HashMap<String, JavaWriter.Method> commonGeneratedMethods = new HashMap<String, JavaWriter.Method>();
                Iterator it2 = generatedMethods.iterator();
                Collection methods = (Collection)it2.next();
                Iterator mit2 = methods.iterator();
                while (mit2.hasNext()) {
                    JavaWriter.Method method2 = (JavaWriter.Method)mit2.next();
                    if (method2.isStatic() || method2.isConstructor() || !method2.isPublic()) continue;
                    commonGeneratedMethods.put(method2.getNameParameters(), method2);
                }
                while (it2.hasNext()) {
                    methods = (Collection)it2.next();
                    HashMap toKeep = new HashMap();
                    mit = methods.iterator();
                    while (mit.hasNext()) {
                        method = (JavaWriter.Method)mit.next();
                        String nameParameters = method.getNameParameters();
                        if (!commonGeneratedMethods.containsKey(nameParameters)) continue;
                        toKeep.put(nameParameters, commonGeneratedMethods.get(nameParameters));
                    }
                    commonGeneratedMethods = toKeep;
                }
                ArrayList sortedMethodNames = new ArrayList(commonGeneratedMethods.keySet());
                Collections.sort(sortedMethodNames);
                ArrayList sortedMethods = new ArrayList(sortedMethodNames.size());
                Iterator sortedMethodNamesIterator = sortedMethodNames.iterator();
                while (sortedMethodNamesIterator.hasNext()) {
                    sortedMethods.add(commonGeneratedMethods.get(sortedMethodNamesIterator.next()));
                }
                this.generateInterface(genDir, packageName, this.config.getGenerateCommonInterface(), sortedMethods, "This interface is the intersection of all generated methods.");
            }
            if (this.config.getDumpBeanTree() != null) {
                FileWriter out = new FileWriter(this.config.getDumpBeanTree());
                bc = (CodeGeneratorClass)generators.get(rootElement);
                bc.dumpBeanTree(out, "", this.config.indent);
                ((Writer)out).close();
            }
        }
        try {
            if (genMDD) {
                mdd.write(mddOut);
                this.config.messageOut.println("Writing metaDD XML file");
            }
        }
        catch (IOException e) {
            this.config.messageOut.println("Failed to write the mdd file: " + e.getMessage());
            throw e;
        }
        this.config.messageOut.println(Common.getMessage("MSG_GenerationSummary", rootElement.getDTDName(), rootElement.getClassType()));
    }

    protected void generateInterface(String genDir, String packageName, String name, List methods, String comments) throws IOException {
        JavaWriter jw = new JavaWriter();
        if (packageName != null && !"".equals(packageName)) {
            jw.writePackage(packageName);
            jw.cr();
        }
        jw.comment("");
        jw.comment(comments);
        jw.comment("");
        jw.cr();
        jw.writeAccess(0);
        jw.write(" interface ");
        jw.write(name);
        jw.write(" ");
        jw.begin();
        Iterator methodsIterator = methods.iterator();
        while (methodsIterator.hasNext()) {
            JavaWriter.Method method = (JavaWriter.Method)methodsIterator.next();
            method.writeMethod(jw);
            jw.eol();
            jw.cr();
        }
        jw.end();
        try {
            OutputStream out = this.config.outputStreamProvider.getStream(genDir, name, "java");
            jw.writeTo(out);
            out.close();
        }
        catch (IOException ioe) {
            this.config.messageOut.println("Failed to generate interface: " + name);
            TraceLogger.error(ioe);
            throw ioe;
        }
    }

    private MetaElement getMetaElement(MetaDD mdd, String dtdName) {
        return this.getMetaElement(mdd, dtdName, null);
    }

    private MetaElement getMetaElement(MetaDD mdd, String dtdName, String namespace) {
        if (mdd == null) {
            return null;
        }
        int size = mdd.sizeMetaElement();
        int i = 0;
        while (i < size) {
            MetaElement e = mdd.getMetaElement(i);
            if (e != null && (namespace == null || namespace.equals(e.getNamespace())) && e.getDtdName().equals(dtdName)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    private void addToImplements(MetaElement e, String interfce) {
        String implList = e.getImplements();
        if (implList == null) {
            e.setImplements(interfce);
            return;
        }
        implList = implList.trim();
        int pos = implList.indexOf(44);
        while (pos >= 0) {
            String impl = implList.substring(0, pos);
            if ((impl = impl.trim()).equals(interfce)) {
                return;
            }
            implList = implList.substring(pos + 1, implList.length());
            implList = implList.trim();
            pos = implList.indexOf(44);
        }
        if (implList.equals(interfce)) {
            return;
        }
        e.setImplements(e.getImplements() + ", " + interfce);
    }

    protected static class KnownValueEnumeration
    implements DataEnumRestriction {
        private String knownValue;

        protected KnownValueEnumeration(String value) {
            this.knownValue = value;
        }

        public void genRestriction(Writer out, String type) throws IOException {
            out.write(JavaUtil.instanceFrom(type, this.knownValue));
        }
    }

    class BeanElement {
        GraphNode node;
        String beanName;
        int type;
        String classType;
        boolean isRoot;
        private boolean canBeEmpty = false;
        private Map usedTypes;

        BeanElement(GraphNode node) {
            this.node = node;
        }

        void initialize(boolean isRoot) {
            this.beanName = Common.convertName(this.node.getName());
            this.type = 512;
            this.calculateType();
            this.isRoot = isRoot;
        }

        public GraphNode getGraphNode() {
            return this.node;
        }

        public void setNodeCreated(boolean value) {
            this.node.setCreated(value);
            this.calculateType();
        }

        protected void calculateType() {
            GraphNode[] nodes;
            if (!this.node.isCreated()) {
                this.type = 256;
            }
            if ((nodes = this.node.getNodes()).length == 1) {
                if ("#PCDATA".equals(nodes[0].getName())) {
                    this.type = 256;
                } else if ("EMPTY".equals(nodes[0].getName())) {
                    this.type = 768;
                    this.canBeEmpty = true;
                }
            }
        }

        public void setName(String name) {
            this.beanName = name;
        }

        public String getName() {
            return this.beanName;
        }

        public String getDTDName() {
            return this.node.getName();
        }

        public void setDTDName(String dtdName) {
            this.node.setName(dtdName);
        }

        public boolean isBean() {
            return Common.isBean(this.type);
        }

        public boolean isBoolean() {
            return Common.isBoolean(this.type);
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public String typeToString() {
            switch (this.type) {
                case 256: {
                    return "String";
                }
                case 768: {
                    return "Boolean";
                }
            }
            return this.beanName;
        }

        public String getClassType() {
            if (this.classType == null) {
                return this.typeToString();
            }
            return this.classType;
        }

        public void setClassType(String ct) {
            this.classType = ct;
        }

        public String toString() {
            return this.beanName + (this.type == 256 ? " \t(String)" : "\t(Bean)");
        }

        public void setUsedTypes(Map usedTypes) {
            this.usedTypes = usedTypes;
        }

        public boolean isUsedType(String type) {
            return this.usedTypes.containsKey(type);
        }

        public boolean getCanBeEmpty() {
            return this.canBeEmpty;
        }
    }
}

