/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans.gen;

import java.io.IOException;
import org.netbeans.modules.schema2beans.gen.GenBuffer;

public class IndentingWriter
extends GenBuffer {
    protected boolean[] crDone;
    protected int[] indentLevel;
    protected String indentString = "\t";

    public IndentingWriter(int bufferCount) {
        super(bufferCount);
        this.crDone = new boolean[bufferCount];
        this.indentLevel = new int[bufferCount];
        this.privateInit();
    }

    public void reset() {
        super.reset();
        this.privateInit();
    }

    private void privateInit() {
        int i = 0;
        while (i < this.bufferCount) {
            this.crDone[i] = true;
            this.indentLevel[i] = 0;
            ++i;
        }
    }

    public void insertAdditionalBuffers(int offset, int count) {
        boolean[] newCrDone = new boolean[this.bufferCount + count];
        System.arraycopy(this.crDone, 0, newCrDone, 0, offset + 1);
        System.arraycopy(this.crDone, offset + 1, newCrDone, offset + 1 + count, this.bufferCount - offset - 1);
        int i = 0;
        while (i < count) {
            newCrDone[offset + 1 + i] = true;
            ++i;
        }
        this.crDone = newCrDone;
        int[] newIndentLevel = new int[this.bufferCount + count];
        System.arraycopy(this.indentLevel, 0, newIndentLevel, 0, offset + 1);
        System.arraycopy(this.indentLevel, offset + 1, newIndentLevel, offset + 1 + count, this.bufferCount - offset - 1);
        int i2 = 0;
        while (i2 < count) {
            newIndentLevel[offset + 1 + i2] = 0;
            ++i2;
        }
        this.indentLevel = newIndentLevel;
        super.insertAdditionalBuffers(offset, count);
    }

    public void setIndent(String indent) {
        this.indentString = indent;
    }

    public String getIndent() {
        return this.indentString;
    }

    public void cr() throws IOException {
        this.listOut[this.curOut].append("\n");
        this.crDone[this.curOut] = true;
    }

    public void write(String str) throws IOException {
        int len = str.length();
        if (len == 0) {
            return;
        }
        char lastChar = str.charAt(len - 1);
        if (lastChar == '\n') {
            int secondLastChar;
            char firstChar = str.charAt(0);
            int n = secondLastChar = len <= 1 ? 32 : (int)str.charAt(len - 2);
            if (firstChar == '}' || secondLastChar == 125) {
                this.indentLeft();
            }
            super.write(str.substring(0, len - 1));
            this.cr();
            if (secondLastChar == 123) {
                this.indentRight();
            }
        } else {
            super.write(str);
        }
    }

    public void writecr(String str) throws IOException {
        super.write(str);
        this.cr();
    }

    public void writecr(String s1, String s2) throws IOException {
        super.write(s1, s2);
        this.cr();
    }

    public void writecr(String s1, String s2, String s3) throws IOException {
        super.write(s1, s2, s3);
        this.cr();
    }

    public void indentRight() {
        int n = this.curOut;
        this.indentLevel[n] = this.indentLevel[n] + 1;
    }

    public void indentLeft() {
        int n = this.curOut;
        this.indentLevel[n] = this.indentLevel[n] - 1;
    }

    protected void beforeWriteHook() {
        if (this.crDone[this.curOut]) {
            this.indent();
            this.crDone[this.curOut] = false;
        }
    }

    public void indent() {
        int i = 0;
        while (i < this.indentLevel[this.curOut]) {
            this.listOut[this.curOut].append(this.indentString);
            ++i;
        }
    }

    public void indentOneLevel() {
        this.listOut[this.curOut].append(this.indentString);
    }
}

