/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Value;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class ArrayElement
extends JPDAVariable {
    private ArrayReference array;
    private int index;

    ArrayElement(JPDADebugger debugger, ArrayReference array, String parentName, int index, String type) {
        super(debugger, true);
        this.name = "[" + index + "]";
        this.array = array;
        this.index = index;
        this.type = type;
        this.modifiers = "";
        try {
            this.setRemoteValue(array.getValue(index));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.update();
    }

    public void validate() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                return;
            }
            if (this.isCloned) {
                if (this.isObject) {
                    this.value = this.debugger.getValue(this.remoteValue);
                }
            } else {
                try {
                    this.setRemoteValue(this.array.getValue(this.index));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.update();
            }
            this.firePropertyChange();
        }
    }

    protected boolean setValue(final Value v) {
        try {
            new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    ArrayElement.this.array.setValue(ArrayElement.this.index, v);
                    return null;
                }
            }.throwAndWait(null);
        }
        catch (InvalidTypeException e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

