/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.BreakpointUpdater;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClassBreakpoint
extends CoreBreakpoint.Event
implements Executor,
StopEvent,
InfoProducer,
CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = -1921042297280923010L;
    public static final String PROP_TYPE = "type";
    public static final String PROP_CLASS_FILTER = "classFilter";
    public static final String PROP_EXCLUSION_FILTER = "exclusionFilter";
    public static final int TYPE_PREPARE = 1;
    public static final int TYPE_UNLOAD = 2;
    public static final String TYPE_NAME = "java-class";
    private transient ThreadReference thread;
    private StepManager.Requestor requestor;
    private int type = 1;
    private boolean exclusionFilter = false;
    private String classFilter = "";
    private transient String action;
    private transient String className;
    private transient CoreBreakpoint.Action[] actions;
    protected transient BreakpointUpdater updater;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebugger;

    public ClassBreakpoint() {
        this.initUpdater();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initUpdater();
    }

    protected void initUpdater() {
        this.updater = new BreakpointUpdater((CoreBreakpoint.Event)this, "setClassFilterByUpdater", this.className);
    }

    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        super.dispose();
    }

    public boolean set() {
        Debugger d = this.getDebugger();
        if (!(d instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)d;
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        if (this.getClassFilter() == null || this.getClassFilter().trim().length() < 1) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new StepManager.Requestor(debugger.getStepManager(), this);
        }
        try {
            this.requestor.removeRequests();
            if ((this.type & 1) != 0) {
                ClassPrepareRequest cpr = debugger.getRequestManager().createClassPrepareRequest();
                cpr.setSuspendPolicy(2);
                if (this.exclusionFilter) {
                    cpr.addClassExclusionFilter(this.getClassFilter());
                } else {
                    cpr.addClassFilter(this.getClassFilter());
                }
                this.requestor.add(cpr);
                cpr.enable();
            }
            if ((this.type & 2) != 0) {
                ClassUnloadRequest cur = debugger.getRequestManager().createClassUnloadRequest();
                cur.setSuspendPolicy(2);
                if (this.exclusionFilter) {
                    cur.addClassExclusionFilter(this.getClassFilter());
                } else {
                    cur.addClassFilter(this.getClassFilter());
                }
                this.requestor.add(cur);
                cur.enable();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return true;
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = ClassBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CLASS_FILTER, (String)JPDADebugger.getLocString("PROP_class_filter"), (String)JPDADebugger.getLocString("HINT_class_filter"), (String)"getClassFilter", (String)"setClassFilter"), Utils.createProperty((Object)this, Boolean.TYPE, (String)PROP_EXCLUSION_FILTER, (String)JPDADebugger.getLocString("PROP_class_exclusion_filter"), (String)JPDADebugger.getLocString("HINT_class_exclusion_filter"), (String)"getExclusionFilter", (String)"setExclusionFilter"), new PropertySupport.ReadWrite(PROP_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_class_type"), JPDADebugger.getLocString("HINT_class_type")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(ClassBreakpoint.this.getType());
            }

            public void setValue(Object val) throws IllegalArgumentException {
                if (!(val instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                ClassBreakpoint.this.setType((Integer)val);
            }

            public PropertyEditor getPropertyEditor() {
                return new TypeEditor();
            }
        }};
    }

    protected void perform() {
        super.perform();
        CoreBreakpoint.Action[] actions = this.getBreakpoint().getActions();
        int i = 0;
        while (i < actions.length) {
            if (actions[i] instanceof JavaStopAction) {
                ((JavaStopAction)actions[i]).performStopAction((CoreBreakpoint.Event)this);
            }
            ++i;
        }
    }

    public Line[] getLines() {
        return null;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Class_event_type_name");
    }

    public String getCategoryDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = ClassBreakpoint.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger), (String)"CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return new MessageFormat(JPDADebugger.getLocString("CTL_Class_prepare_event_name")).format(new Object[]{this.getClassFilter()});
        }
        if (this.type == 2) {
            return new MessageFormat(JPDADebugger.getLocString("CTL_Class_unload_event_name")).format(new Object[]{this.getClassFilter()});
        }
        return new MessageFormat(JPDADebugger.getLocString("CTL_Class_event_name")).format(new Object[]{this.getClassFilter()});
    }

    public String getIconBase() {
        return "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointClassJPDA");
    }

    public JComponent getCustomizer() {
        this.setClassFilter(JUtils.getCurrentClassName());
        return new ClassBreakpointPanel(this);
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] parentActions = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new ClassPrintAction()};
            if (parentActions.length != 0) {
                CoreBreakpoint.Action[] myActions = this.actions;
                this.actions = new CoreBreakpoint.Action[parentActions.length + myActions.length];
                System.arraycopy(parentActions, 0, this.actions, 0, parentActions.length);
                System.arraycopy(myActions, 0, this.actions, parentActions.length, myActions.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        return debugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public void synchronizeWith(CoreBreakpoint.Event e) {
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            this.thread = ((ClassPrepareEvent)event).thread();
            this.action = JPDADebugger.getLocString("CTL_Prepared");
            this.className = ((ClassPrepareEvent)event).referenceType().name();
        } else {
            this.action = JPDADebugger.getLocString("CTL_Unload");
            this.className = ((ClassUnloadEvent)event).className();
        }
        if (this.classFilter.indexOf(42) < 0 && !this.className.equals(this.classFilter)) {
            ((JPDADebugger)this.getDebugger()).getStepManager().resumeOperator();
            return;
        }
        this.perform();
    }

    public void stop(boolean stop) {
        ((JPDADebugger)this.getDebugger()).stop(stop, (JPDAThread)this.getThread());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type == this.type) {
            return;
        }
        if ((type & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.type;
        this.type = type;
        this.firePropertyChange(PROP_TYPE, new Integer(old), new Integer(type));
    }

    public boolean getExclusionFilter() {
        return this.exclusionFilter;
    }

    public void setExclusionFilter(boolean exclusionFilter) {
        if (exclusionFilter == this.exclusionFilter) {
            return;
        }
        boolean old = this.exclusionFilter;
        this.exclusionFilter = exclusionFilter;
        this.firePropertyChange(PROP_EXCLUSION_FILTER, old ? Boolean.TRUE : Boolean.FALSE, exclusionFilter ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(String classFilter) {
        this.setClassFilter(classFilter, true);
    }

    public void setClassFilterByUpdater(String classFilter) {
        this.setClassFilter(classFilter, false);
    }

    public void setClassFilter(String classFilter, boolean notifyUpdater) {
        if (classFilter != null) {
            classFilter = classFilter.trim();
        }
        if (this.classFilter == classFilter || this.classFilter != null && classFilter != null && classFilter.equals(this.classFilter)) {
            return;
        }
        String old = this.classFilter;
        this.classFilter = classFilter;
        if (notifyUpdater) {
            this.updater.setClassName(classFilter);
        }
        this.firePropertyChange(PROP_CLASS_FILTER, old, classFilter);
    }

    public String toString() {
        return "JPDAClassBreakpoint " + this.getClassFilter();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ClassPrintAction
    extends PrintAction {
        static final long serialVersionUID = 1241425759801080117L;

        ClassPrintAction() {
            super(JPDADebugger.getLocString("CTL_Class_print_name"));
        }

        protected void resolveTag(String tag, CoreBreakpoint.Event event, StringBuffer sb) {
            if (tag.equals("className")) {
                sb.append(((ClassBreakpoint)event).className);
            } else if (tag.equals("action")) {
                sb.append(((ClassBreakpoint)event).action);
            } else {
                super.resolveTag(tag, event, sb);
            }
        }
    }

    static class TypeEditor
    extends PropertyEditorSupport {
        private static final int[] values = new int[]{1, 2, 3};
        private static final String[] tags = new String[]{JPDADebugger.getLocString("CTL_Breakpoint_type_class_prepare"), JPDADebugger.getLocString("CTL_Breakpoint_type_class_unload"), JPDADebugger.getLocString("CTL_Breakpoint_type_class_both")};

        TypeEditor() {
        }

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            int v = (Integer)this.getValue();
            int i = 0;
            while (i < values.length) {
                if (v == values[i]) {
                    return tags[i];
                }
                ++i;
            }
            return "?";
        }

        public void setAsText(String t) {
            int i = 0;
            while (i < tags.length) {
                if (tags[i].equals(t)) {
                    this.setValue(new Integer(values[i]));
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException(t);
        }
    }
}

