/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.debugger.Controller;
import org.netbeans.modules.debugger.jpda.ClassBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings;
import org.netbeans.modules.debugger.jpda.LineBreakpointPanel;
import org.netbeans.modules.debugger.support.java.JavaElementSelector;
import org.netbeans.modules.debugger.support.java.PackageClassHistory;
import org.netbeans.modules.debugger.support.util.AbstractHistory;
import org.netbeans.modules.debugger.support.util.PackageListLoader;
import org.netbeans.modules.debugger.support.util.SimpleHistory;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public final class ClassBreakpointPanel
extends JPanel
implements ChangeListener,
Controller,
Runnable {
    private final JPDADebuggerProjectSettings historyStorage;
    private final SimpleHistory packageHistory;
    private final PackageClassHistory classHistory;
    private ClassBreakpoint classBreakpoint;
    private JavaElementSelector javaElementSelector;
    private String pkg;
    private String cls;
    private String CLASS_PREPARE;
    private String CLASS_UNLOAD;
    private String CLASS_PREPARE_OR_UNLOAD;
    private boolean valid = false;
    private JCheckBox chkExclusion;
    private JLabel lblClassFilter;
    private JLabel lblPackage;
    private JComboBox cboxClass;
    private JComboBox cboxPackage;
    private JLabel lblClass;
    private JPanel jPanel1;
    private JComboBox cboxSetOn;
    private JLabel lblSetOn;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings;

    public ClassBreakpointPanel(ClassBreakpoint cb) {
        this.classBreakpoint = cb;
        this.javaElementSelector = new JavaElementSelector(0);
        this.javaElementSelector.addChangeListener((ChangeListener)this);
        this.initComponents();
        this.putClientProperty("HelpID", "debug.add.breakpoint.java.class");
        LineBreakpointPanel.Listener l = new LineBreakpointPanel.Listener(this);
        this.cboxClass.getEditor().getEditorComponent().addKeyListener(l);
        this.cboxClass.addActionListener(l);
        this.lblClassFilter.setLabelFor(this);
        this.getAccessibleContext().setAccessibleDescription(this.lblClassFilter.getText());
        this.cboxPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("ACSD_CTL_Package_name"));
        this.cboxClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("ACSD_CTL_Class_name"));
        this.chkExclusion.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("ACSD_CTL_Class_exclusion_filter"));
        this.cboxSetOn.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("ACSD_CTL_Class_breakpoint_type"));
        this.historyStorage = (JPDADebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings")) : class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings), (boolean)true);
        this.packageHistory = this.historyStorage.getPackageHistory();
        this.classHistory = this.historyStorage.getClassHistory();
        this.javaElementSelector.setPackageHistory((AbstractHistory)this.packageHistory);
        this.javaElementSelector.setClassHistory(this.classHistory);
        String s = this.classBreakpoint.getClassFilter().trim();
        int dotIndex = s.lastIndexOf(46);
        if (dotIndex == -1) {
            this.pkg = "";
            this.cls = s;
        } else {
            this.pkg = s.substring(0, dotIndex);
            this.cls = s.substring(dotIndex + 1);
        }
        this.javaElementSelector.setInitialSelection(this.pkg, this.cls);
        this.chkExclusion.setSelected(this.classBreakpoint.getExclusionFilter());
        switch (this.classBreakpoint.getType()) {
            case 1: {
                this.cboxSetOn.setSelectedItem(this.CLASS_PREPARE);
                break;
            }
            case 2: {
                this.cboxSetOn.setSelectedItem(this.CLASS_UNLOAD);
                break;
            }
            default: {
                this.cboxSetOn.setSelectedItem(this.CLASS_PREPARE_OR_UNLOAD);
            }
        }
    }

    private void initComponents() {
        this.lblClassFilter = new JLabel();
        this.lblPackage = new JLabel();
        this.cboxPackage = this.javaElementSelector.getPackageSelector();
        this.lblClass = new JLabel();
        this.cboxClass = this.javaElementSelector.getClassSelector();
        this.chkExclusion = new JCheckBox();
        this.lblSetOn = new JLabel();
        this.cboxSetOn = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblClassFilter.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_filter"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.lblClassFilter, gridBagConstraints);
        this.lblPackage.setLabelFor(this.cboxPackage);
        this.lblPackage.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Package_name"));
        this.lblPackage.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Package_name_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 14, 2, 2);
        this.add((Component)this.lblPackage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.cboxPackage, gridBagConstraints);
        this.lblClass.setLabelFor(this.cboxClass);
        this.lblClass.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_name"));
        this.lblClass.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_name_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 14, 2, 2);
        this.add((Component)this.lblClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.cboxClass, gridBagConstraints);
        this.chkExclusion.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_exclusion_filter"));
        this.chkExclusion.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_exclusion_filter_mnemonic").charAt(0));
        this.chkExclusion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassBreakpointPanel.this.chkExclusionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 14, 2, 2);
        this.add((Component)this.chkExclusion, gridBagConstraints);
        this.lblSetOn.setLabelFor(this.cboxSetOn);
        this.lblSetOn.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_breakpoint_type"));
        this.lblSetOn.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_breakpoint_type_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.add((Component)this.lblSetOn, gridBagConstraints);
        this.CLASS_PREPARE = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_prepare");
        this.CLASS_UNLOAD = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_unload");
        this.CLASS_PREPARE_OR_UNLOAD = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel = ClassBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.ClassBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$ClassBreakpointPanel)).getString("CTL_Class_both");
        this.cboxSetOn.addItem(this.CLASS_PREPARE);
        this.cboxSetOn.addItem(this.CLASS_UNLOAD);
        this.cboxSetOn.addItem(this.CLASS_PREPARE_OR_UNLOAD);
        this.cboxSetOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassBreakpointPanel.this.cboxSetOnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.add((Component)this.cboxSetOn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public void stateChanged(ChangeEvent e) {
        String clsFilter;
        Object changedComboBox = e.getSource();
        if (changedComboBox == this.cboxPackage) {
            this.pkg = this.javaElementSelector.getSelectedPackage().trim();
            this.classHistory.setPackage(this.pkg);
        } else {
            this.cls = this.javaElementSelector.getSelectedClass().trim();
        }
        String string = clsFilter = this.cls.length() == 0 ? "*" : this.cls.replace('.', '$');
        if (this.pkg.length() == 0) {
            this.classBreakpoint.setClassFilter(clsFilter);
        } else {
            this.classBreakpoint.setClassFilter(this.pkg + '.' + clsFilter);
        }
    }

    private void chkExclusionActionPerformed(ActionEvent evt) {
        this.classBreakpoint.setExclusionFilter(this.chkExclusion.isSelected());
    }

    private void cboxSetOnActionPerformed(ActionEvent evt) {
        Object selection = this.cboxSetOn.getSelectedItem();
        if (selection == this.CLASS_PREPARE) {
            this.classBreakpoint.setType(1);
        } else if (selection == this.CLASS_UNLOAD) {
            this.classBreakpoint.setType(2);
        } else {
            this.classBreakpoint.setType(3);
        }
    }

    public boolean ok() {
        if (this.pkg.length() > 0) {
            this.packageHistory.addItem((Object)this.pkg);
        }
        if (this.cls.length() > 0) {
            this.classHistory.addItem((Object)this.cls);
        }
        this.historyStorage.setPackageHistory(this.packageHistory);
        this.historyStorage.setClassHistory(this.classHistory);
        PackageListLoader.reset();
        return true;
    }

    public boolean cancel() {
        PackageListLoader.reset();
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean nv = false;
                String cls = ClassBreakpointPanel.this.javaElementSelector.getSelectedClass().trim();
                if (cls.length() > 0) {
                    nv = true;
                }
                if (ClassBreakpointPanel.this.valid == nv) {
                    return;
                }
                ClassBreakpointPanel.this.valid = nv;
                ClassBreakpointPanel.super.firePropertyChange("valid", !ClassBreakpointPanel.this.valid ? Boolean.TRUE : Boolean.FALSE, ClassBreakpointPanel.this.valid ? Boolean.TRUE : Boolean.FALSE);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

