/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings;
import org.netbeans.modules.debugger.jpda.Launcher;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.support.DebuggerInfoProducer;
import org.openide.ErrorManager;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.SharedClassObject;

class ConnectPanel
extends JPanel
implements DebuggerInfoProducer,
ActionListener {
    private JLabel lblConnectors;
    private JComboBox cbConnectors;
    private JLabel lblTransport;
    private JTextField tfTransport;
    private Map args;
    private int connectorCount;
    private List acs;
    private JTextField[] tfParams;
    private GridBagLayout gbl;
    private AttachingConnector ac;
    private JPDADebuggerProjectSettings jpdaSettings;
    private Map connectSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings;

    ConnectPanel() {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        this.acs = vmm.attachingConnectors();
        this.connectorCount = this.acs.size();
        if (this.connectorCount == 0) {
            this.add(new JLabel(JPDADebugger.getLocString("CTL_No_Connector")));
            return;
        }
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        if (this.connectorCount > 1) {
            this.lblConnectors = new JLabel(JPDADebugger.getLocString("CTL_Connector"));
            this.lblConnectors.setDisplayedMnemonic(JPDADebugger.getLocString("CTL_Connector_mnemonic").charAt(0));
            this.cbConnectors = new JComboBox();
            this.cbConnectors.getAccessibleContext().setAccessibleDescription(JPDADebugger.getLocString("ACSD_CTL_Connector"));
            int k = this.acs.size();
            int i = 0;
            while (i < k) {
                AttachingConnector ac = (AttachingConnector)this.acs.get(i);
                int jj = ac.name().lastIndexOf(46);
                String s = jj < 0 ? ac.name() : ac.name().substring(jj + 1);
                this.cbConnectors.addItem(s + " (" + ac.description() + ")");
                ++i;
            }
            this.cbConnectors.setActionCommand("SwitchMe!");
        }
        this.tfTransport = new JTextField();
        this.tfTransport.setEditable(false);
        this.lblTransport = new JLabel(JPDADebugger.getLocString("CTL_Transport"));
        this.lblTransport.setDisplayedMnemonic(JPDADebugger.getLocString("CTL_Transport_Mnemonic").charAt(0));
        this.lblTransport.setLabelFor(this.tfTransport);
        int defaultIndex = 0;
        try {
            this.jpdaSettings = (JPDADebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings = ConnectPanel.class$("org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings")) : class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings), (boolean)true);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        if (this.jpdaSettings != null && this.cbConnectors != null) {
            String lastConnector = this.jpdaSettings.getLastConnector();
            if (lastConnector != null) {
                ListIterator iter = this.acs.listIterator();
                int index = 0;
                while (iter.hasNext()) {
                    if (((AttachingConnector)iter.next()).name().equals(lastConnector)) {
                        defaultIndex = index;
                        break;
                    }
                    ++index;
                }
            }
            this.cbConnectors.setSelectedIndex(defaultIndex);
            this.cbConnectors.addActionListener(this);
        }
        this.refresh(defaultIndex);
    }

    private void refresh(int index) {
        GridBagConstraints c;
        this.removeAll();
        if (this.cbConnectors != null) {
            c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 3, 3);
            this.gbl.setConstraints(this.lblConnectors, c);
            c.insets = new Insets(0, 3, 3, 0);
            c.weightx = 1.0;
            c.fill = 2;
            c.gridwidth = 0;
            this.gbl.setConstraints(this.cbConnectors, c);
            this.add(this.lblConnectors);
            this.add(this.cbConnectors);
        }
        c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 0, 6);
        this.gbl.setConstraints(this.lblTransport, c);
        c.gridwidth = 0;
        c.insets = new Insets(3, 3, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        this.gbl.setConstraints(this.tfTransport, c);
        this.add(this.lblTransport);
        this.add(this.tfTransport);
        this.ac = (AttachingConnector)this.acs.get(index);
        this.tfTransport.setText(this.ac.transport().name());
        this.tfTransport.getAccessibleContext().setAccessibleDescription(JPDADebugger.getLocString("ACSD_CTL_Transport"));
        this.tfTransport.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ConnectPanel.this.tfTransport.selectAll();
            }
        });
        this.args = this.ac.defaultArguments();
        if (this.jpdaSettings != null) {
            Map savedValues;
            this.connectSettings = this.jpdaSettings.getConnectionSettings();
            Map map = savedValues = this.connectSettings == null ? null : (Map)this.connectSettings.get(this.ac.name());
            if (savedValues != null) {
                Iterator i = this.args.keySet().iterator();
                while (i.hasNext()) {
                    Connector.Argument arg;
                    Object argName = i.next();
                    String savedValue = (String)savedValues.get(argName);
                    if (savedValue != null) {
                        ((Connector.Argument)this.args.get(argName)).setValue(savedValue);
                        continue;
                    }
                    String argumentName = (String)argName;
                    if (!argumentName.equalsIgnoreCase("hostname") && !argumentName.equalsIgnoreCase("host") && !argumentName.equalsIgnoreCase("remotehost") || !Launcher.isUnknownHost((arg = (Connector.Argument)this.args.get(argName)).value())) continue;
                    arg.setValue("localhost");
                }
            }
        }
        this.tfParams = new JTextField[this.args.size()];
        Iterator it = this.args.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            char mnemonic;
            String label;
            String name = (String)it.next();
            Connector.Argument a = (Connector.Argument)this.args.get(name);
            String argName = a.label();
            if (argName.equalsIgnoreCase("Host")) {
                label = JPDADebugger.getLocString("CTL_Host");
                mnemonic = JPDADebugger.getLocString("CTL_Host_mnemonic").charAt(0);
            } else if (argName.equalsIgnoreCase("Port")) {
                label = JPDADebugger.getLocString("CTL_Port");
                mnemonic = JPDADebugger.getLocString("CTL_Port_mnemonic").charAt(0);
            } else if (argName.equalsIgnoreCase("Name")) {
                label = JPDADebugger.getLocString("CTL_Name");
                mnemonic = JPDADebugger.getLocString("CTL_Name_mnemonic").charAt(0);
            } else {
                label = argName;
                mnemonic = '!';
            }
            c = new GridBagConstraints();
            c.insets = new Insets(6, 0, 0, 3);
            c.anchor = 17;
            JLabel iLabel = new JLabel(label);
            if (mnemonic != '!') {
                iLabel.setDisplayedMnemonic(mnemonic);
            }
            this.add((Component)iLabel, c);
            JTextField tfParam = new JTextField(a.value());
            iLabel.setLabelFor(tfParam);
            this.tfParams[i++] = tfParam;
            tfParam.setName(name);
            tfParam.getAccessibleContext().setAccessibleDescription(new MessageFormat(JPDADebugger.getLocString("ACSD_CTL_Argument")).format(new Object[]{a.label()}));
            c = new GridBagConstraints();
            c.gridwidth = 0;
            c.insets = new Insets(6, 3, 0, 0);
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)tfParam, c);
        }
        c = new GridBagConstraints();
        c.weighty = 1.0;
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(1, 1));
        this.add((Component)p, c);
    }

    public DebuggerInfo getDebuggerInfo() {
        if (this.jpdaSettings != null) {
            String name = this.ac.name();
            int k = this.tfParams.length;
            HashMap<String, String> argsToSave = new HashMap<String, String>(k + 2);
            int i = 0;
            while (i < k) {
                JTextField tf = this.tfParams[i];
                String paramName = tf.getName();
                String paramValue = tf.getText();
                Connector.Argument a = (Connector.Argument)this.args.get(paramName);
                a.setValue(paramValue);
                argsToSave.put(paramName, paramValue);
                ++i;
            }
            this.connectSettings = this.connectSettings == null ? new HashMap(3) : new HashMap(this.connectSettings);
            this.connectSettings.put(name, argsToSave);
            this.jpdaSettings.setLastConnector(name);
            this.jpdaSettings.setConnectionSettings(this.connectSettings);
        }
        return new RemoteDebuggerInfo(this.ac, this.args);
    }

    public void actionPerformed(ActionEvent e) {
        this.refresh(((JComboBox)e.getSource()).getSelectedIndex());
        Container w = this.getParent();
        while (!(w instanceof Window)) {
            w = w.getParent();
        }
        if (w != null) {
            ((Window)w).pack();
        }
    }

    private String translate(String name) {
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

