/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.ExceptionBreakpointPanel;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.ValueVariable;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Utils;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.ClassBreakpointEvent;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExceptionBreakpoint
extends ClassBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = -1543264672497993747L;
    public static final String PROP_CATCH_TYPE = "catchType";
    public static final String PROP_CONDITION = "condition";
    public static final int EXCEPTION_CATCHED = 1;
    public static final int EXCEPTION_UNCATCHED = 2;
    public static final String TYPE_NAME = "java-exception";
    private transient ThreadReference thread;
    private StepManager.Requestor requestor;
    private ReferenceType tryClass;
    private JPDAVariable exception;
    private int catchType = 2;
    private String condition = "";
    private HashSet refTypesWithBreakpoint;
    private transient CoreBreakpoint.Action[] actions;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$VariableBreakpoint;
    static /* synthetic */ Class class$java$lang$String;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger d = this.getDebugger();
        if (!(d instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)d;
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        if (this.getClassName() == null || this.getClassName().trim().length() < 1) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new StepManager.Requestor(debugger.getStepManager(), this);
        }
        try {
            ReferenceType ref;
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            ClassPrepareRequest cpr = debugger.getRequestManager().createClassPrepareRequest();
            cpr.addClassFilter(this.getClassName() + '*');
            cpr.setSuspendPolicy(2);
            this.requestor.add(cpr);
            cpr.enable();
            List<ReferenceType> l = debugger.virtualMachine.classesByName(this.getClassName());
            if (l.size() == 0) {
                return false;
            }
            boolean set = false;
            ArrayList<ReferenceType> anonymousInner = new ArrayList<ReferenceType>();
            int i = 0;
            int iterCount = l.size();
            while (i < iterCount) {
                ref = l.get(i);
                this.set(ref);
                try {
                    anonymousInner.addAll(Utils.anonymousInnerClasses(ref.name(), ref.nestedTypes()));
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while (i < anonymousInner.size()) {
                ref = (ReferenceType)anonymousInner.get(i);
                this.set(ref);
                try {
                    anonymousInner.addAll(ref.nestedTypes());
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
                ++i;
            }
            return true;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$VariableBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$VariableBreakpoint = ExceptionBreakpoint.class$("org.netbeans.modules.debugger.jpda.VariableBreakpoint")) : class$org$netbeans$modules$debugger$jpda$VariableBreakpoint));
        return new Node.Property[]{org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = ExceptionBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"className", (String)JPDADebugger.getLocString("PROP_Exception_class_name"), (String)JPDADebugger.getLocString("HINT_Exception_class_name"), (String)"getClassName", (String)"setClassName"), new PropertySupport.ReadWrite(PROP_CATCH_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_Exception_type_name"), JPDADebugger.getLocString("HINT_Exception_type_name")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(ExceptionBreakpoint.this.getCatchType());
            }

            public void setValue(Object val) throws IllegalArgumentException {
                try {
                    ExceptionBreakpoint.this.setCatchType((Integer)val);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException();
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new TypeEditor();
            }
        }, org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = ExceptionBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)JPDADebugger.getLocString("PROP_condition"), (String)JPDADebugger.getLocString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public Line[] getLines() {
        return null;
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] parentActions = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new PrintAction(PrintAction.BREAKPOINT_EXCEPTION_TEXT)};
            if (parentActions.length != 0) {
                CoreBreakpoint.Action[] myActions = this.actions;
                this.actions = new CoreBreakpoint.Action[parentActions.length + myActions.length];
                System.arraycopy(parentActions, 0, this.actions, 0, parentActions.length);
                System.arraycopy(myActions, 0, this.actions, parentActions.length, myActions.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        if (debugger == null || debugger.threadManager == null) {
            return null;
        }
        return debugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        JPDAThread t = (JPDAThread)this.getThread();
        if (t == null) {
            return null;
        }
        return (CallStackFrame[])t.getCallStack();
    }

    public JavaVariable getVariable() {
        return this.exception;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Exception_event_name_type_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if ((this.getCatchType() & 1) != 0) {
            if ((this.getCatchType() & 2) != 0) {
                return new MessageFormat(JPDADebugger.getLocString("CTL_Exception_event_name")).format(new Object[]{this.getClassName()});
            }
            return new MessageFormat(JPDADebugger.getLocString("CTL_Exception_event_name_catched")).format(new Object[]{this.getClassName()});
        }
        return new MessageFormat(JPDADebugger.getLocString("CTL_Exception_event_name_uncatched")).format(new Object[]{this.getClassName()});
    }

    public String getIconBase() {
        return "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointExceptionJPDA");
    }

    public JComponent getCustomizer() {
        this.setClassName(JUtils.getSelectedIdentifier());
        return new ExceptionBreakpointPanel(this);
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        if (!this.condition.trim().equals("")) {
            JPDADebugger debugger = (JPDADebugger)this.getDebugger();
            JPDAWatch watch = new JPDAWatch(debugger, true);
            watch.setVariableName(this.condition);
            watch.refreshValue((JPDAThread)this.getThread());
            String type = watch.getType();
            String value = watch.getAsText();
            if (type != null && type.equals("boolean") && value != null && value.equals("false")) {
                this.stop(false);
                return;
            }
            if (type == null || !type.equals("boolean")) {
                debugger.getIOManager().println(JPDADebugger.getLocString("CTL_Incorrect_condition") + ": " + JPDADebugger.getLocString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            boolean v;
            boolean isDemanded;
            this.tryClass = ((ClassPrepareEvent)event).referenceType();
            String tryClassName = this.tryClass.name();
            if (tryClassName.equals(this.getClassName())) {
                isDemanded = true;
            } else {
                String mandatoryPrefix = this.getClassName() + '$';
                boolean bl = isDemanded = tryClassName.startsWith(mandatoryPrefix) && !Character.isJavaIdentifierStart(tryClassName.charAt(mandatoryPrefix.length()));
            }
            if (isDemanded && (v = this.set(this.tryClass)) && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            ((JPDADebugger)this.getDebugger()).getStepManager().resumeOperator();
            return;
        }
        this.thread = ((ExceptionEvent)event).thread();
        this.exception = new ValueVariable((JPDADebugger)this.getDebugger(), "Exception", ((ExceptionEvent)event).exception().type().name(), ((ExceptionEvent)event).exception());
        this.perform();
    }

    public void stop(boolean stop) {
        ((JPDADebugger)this.getDebugger()).stop(stop, (JPDAThread)this.getThread());
    }

    public int getCatchType() {
        return this.catchType;
    }

    public void setCatchType(int catchType) {
        if (catchType == this.catchType) {
            return;
        }
        if ((catchType & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.catchType;
        this.catchType = catchType;
        this.firePropertyChange(PROP_CATCH_TYPE, new Integer(old), new Integer(catchType));
    }

    public boolean set(ReferenceType clazz) {
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        ExceptionBreakpoint exceptionBreakpoint = this;
        synchronized (exceptionBreakpoint) {
            if (this.refTypesWithBreakpoint == null) {
                this.refTypesWithBreakpoint = new HashSet(17);
            } else {
                try {
                    if (this.refTypesWithBreakpoint.contains(clazz)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
            }
            this.refTypesWithBreakpoint.add(clazz);
        }
        try {
            ExceptionRequest er = debugger.getRequestManager().createExceptionRequest(clazz, (1 & this.catchType) != 0, (2 & this.catchType) != 0);
            er.setSuspendPolicy(2);
            this.requestor.add(er);
            er.enable();
            return true;
        }
        catch (VMDisconnectedException e) {
        }
        catch (VMMismatchException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "JPDAExceptionBreakpoint " + this.getClassName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TypeEditor
    extends PropertyEditorSupport {
        private static final int[] values = new int[]{1, 2, 3};
        private static final String[] tags = new String[]{JPDADebugger.getLocString("CTL_Exception_type_catched"), JPDADebugger.getLocString("CTL_Exception_type_uncatched"), JPDADebugger.getLocString("CTL_Exception_type_both")};

        TypeEditor() {
        }

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            int v = (Integer)this.getValue();
            int i = 0;
            while (i < values.length) {
                if (v == values[i]) {
                    return tags[i];
                }
                ++i;
            }
            return "?";
        }

        public void setAsText(String t) {
            int i = 0;
            while (i < tags.length) {
                if (tags[i].equals(t)) {
                    this.setValue(new Integer(values[i]));
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException(t);
        }
    }
}

