/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.util.MultilinePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.AbstractCompileAction;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;

final class FixActionImpl {
    private final JPDADebugger session;
    private final Method redefineClassesMethod;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$com$sun$jdi$VirtualMachine;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

    FixActionImpl(JPDADebugger session) throws NoSuchMethodException {
        this.session = session;
        this.redefineClassesMethod = (class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = FixActionImpl.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine).getMethod("redefineClasses", class$java$util$Map == null ? (class$java$util$Map = FixActionImpl.class$("java.util.Map")) : class$java$util$Map);
    }

    private boolean compile(DataObject dataObject) {
        CompilerCookie c = (CompilerCookie)dataObject.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = FixActionImpl.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (c != null) {
            return AbstractCompileAction.compile(Collections.enumeration(Collections.singleton(c)), (String)JPDADebugger.getLocString("MSG_Compile_before_fix"));
        }
        return true;
    }

    private List getClassFiles(DataObject dataObject) {
        Set files = dataObject.files();
        ArrayList<FileObject> classFiles = new ArrayList<FileObject>(files.size());
        Iterator i = files.iterator();
        while (i.hasNext()) {
            FileObject file = (FileObject)i.next();
            if (!file.getExt().equals("class")) continue;
            classFiles.add(file);
        }
        return classFiles;
    }

    private Map loadBytecodes(List classFiles) {
        String className = null;
        try {
            HashMap<ReferenceType, byte[]> bytecodes = new HashMap<ReferenceType, byte[]>((int)((double)classFiles.size() * 1.5), 0.75f);
            Iterator i = classFiles.iterator();
            while (i.hasNext()) {
                FileObject file = (FileObject)i.next();
                className = file.getPackageName('/');
                byte[] bytecode = null;
                List<ReferenceType> refTypes = this.session.virtualMachine.classesByName(className);
                int refTypesCount = refTypes.size();
                if (refTypesCount == 0) continue;
                InputStream is = file.getInputStream();
                long fileSize = file.getSize();
                if (fileSize > Integer.MAX_VALUE) {
                    throw new RuntimeException("File too large: " + file);
                }
                bytecode = new byte[(int)fileSize];
                is.read(bytecode);
                if (refTypesCount == 1) {
                    bytecodes.put(refTypes.get(0), bytecode);
                    continue;
                }
                Iterator<ReferenceType> j = refTypes.iterator();
                while (j.hasNext()) {
                    bytecodes.put(j.next(), bytecode);
                }
            }
            return bytecodes;
        }
        catch (IOException ex) {
            String format = JPDADebugger.getLocString("EXC_Could_not_read_class_file");
            String msg = MessageFormat.format(format, className);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            return null;
        }
    }

    private boolean redefineClasses(Map bytecodes) {
        try {
            this.redefineClassesMethod.invoke((Object)this.session.virtualMachine, bytecodes);
            return true;
        }
        catch (InvocationTargetException ex) {
            Throwable exc = ex.getTargetException();
            if (exc instanceof UnsupportedOperationException) {
                String msg = JPDADebugger.getLocString("MSG_Unsupported_class_definition_changes");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)new MultilinePanel(msg), 0));
            } else {
                String msg = JPDADebugger.getLocString("EXC_Cannot_redefine_class");
                ErrorManager.getDefault().annotate(exc, msg);
                ErrorManager.getDefault().notify(256, exc);
            }
            return false;
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return false;
        }
    }

    private ReferenceType getTopmostFrameRefType() {
        if (!this.session.currentThread.isSuspended()) {
            return null;
        }
        try {
            StackFrame topFrame = this.session.currentThread.getThreadReference().frame(0);
            return topFrame.location().declaringType();
        }
        catch (IncompatibleThreadStateException ex) {
            return null;
        }
    }

    private void warnTopmostFrameRedefined() {
        String title = JPDADebugger.getLocString("MSG_Old_frame_on_stack_title");
        String text = JPDADebugger.getLocString("MSG_Old_frame_on_stack");
        String optionPop = JPDADebugger.getLocString("MSG_Old_frame_on_stack_pop_frame");
        String optionLeave = JPDADebugger.getLocString("MSG_Old_frame_on_stack_leave_frame");
        DialogDescriptor descr = new DialogDescriptor((Object)new MultilinePanel(title, text), title, true, new Object[]{optionPop, optionLeave}, (Object)optionPop, 0, new HelpCtx("NetbeansDebuggerJPDAPopOldFrame"), null);
        descr.setClosingOptions(null);
        descr.setMessageType(2);
        Object selected = DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
        if (selected == optionPop) {
            this.session.popTopmostFrame();
        }
    }

    void fix() {
        ReferenceType topmostFrameRefType;
        boolean wasRunning;
        DataObject dataObject = this.session.dataObjectToFix;
        if (dataObject == null) {
            throw new IllegalStateException();
        }
        if (!this.compile(dataObject)) {
            return;
        }
        List classFiles = this.getClassFiles(dataObject);
        if (classFiles.isEmpty()) {
            String msg = JPDADebugger.getLocString("MSG_no_class_files_found");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            return;
        }
        Map bytecodes = this.loadBytecodes(classFiles);
        if (bytecodes == null) {
            return;
        }
        if (bytecodes.isEmpty()) {
            this.session.getIOManager().println(JPDADebugger.getLocString("MSG_No_class_redefined"));
            return;
        }
        boolean bl = wasRunning = this.session.getState() == 3;
        if (wasRunning) {
            this.session.setSuspended(true);
        }
        boolean offerAutomaticPop = this.session.canPopFrames() && this.session.currentThread.isSuspended() && this.session.currentThread.getStackDepth() > 1;
        ReferenceType referenceType = topmostFrameRefType = offerAutomaticPop ? this.getTopmostFrameRefType() : null;
        if (!this.redefineClasses(bytecodes)) {
            return;
        }
        Set redefinedRefTypes = bytecodes.keySet();
        Iterator i = redefinedRefTypes.iterator();
        String className = ((ReferenceType)i.next()).name();
        int dotIndex = className.indexOf(46);
        String packageName = dotIndex == -1 ? null : className.substring(0, dotIndex + 1);
        IOManager io = this.session.getIOManager();
        io.println(JPDADebugger.getLocString("MSG_Redefined_classes"));
        io.print("   ", 1);
        io.println(className);
        while (i.hasNext()) {
            io.print("   ", 1);
            io.println(((ReferenceType)i.next()).name());
        }
        if (offerAutomaticPop && redefinedRefTypes.contains(topmostFrameRefType)) {
            this.warnTopmostFrameRedefined();
        }
        try {
            Breakpoint[] breakpoints = this.session.getBreakpoints();
            int i2 = 0;
            while (i2 < breakpoints.length) {
                Breakpoint b = breakpoints[i2];
                CoreBreakpoint.Event event = ((CoreBreakpoint)breakpoints[i2]).getEvent((Debugger)this.session);
                if (event instanceof LineBreakpoint) {
                    ((LineBreakpoint)event).refreshAfterFix(redefinedRefTypes, packageName);
                } else if (event instanceof MethodBreakpoint) {
                    ((MethodBreakpoint)event).refreshAfterFix(redefinedRefTypes, packageName);
                }
                ++i2;
            }
        }
        catch (ClassCastException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        if (wasRunning) {
            this.session.resume();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

