/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.lang.reflect.Modifier;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class InstanceField
extends JPDAVariable {
    private ObjectReference instance;
    private Field field;

    InstanceField(JPDADebugger debugger, ObjectReference instance, Field field) {
        super(debugger, true);
        this.name = field.name();
        this.instance = instance;
        this.field = field;
        try {
            this.setRemoteValue(instance.getValue(field));
            this.modifiers = Modifier.toString(field.modifiers());
            this.type = field.typeName();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.update();
    }

    public void validate() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                return;
            }
            if (this.isCloned) {
                if (this.isObject) {
                    this.value = this.debugger.getValue(this.remoteValue);
                }
            } else {
                try {
                    this.setRemoteValue(this.instance.getValue(this.field));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.update();
            }
            this.firePropertyChange();
        }
    }

    protected boolean setValue(final Value v) {
        try {
            new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    InstanceField.this.instance.setValue(InstanceField.this.field, v);
                    return null;
                }
            }.throwAndWait(null);
        }
        catch (InvalidTypeException e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

