/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.LocalVariable;
import org.netbeans.modules.debugger.jpda.ThisLocalVariable;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.util.Protector;
import org.openide.debugger.DebuggerException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JPDACallStackFrame
extends CallStackFrame {
    private ThreadReference threadS;
    private int indexS;
    private JPDADebugger debugger;
    private VariablesFilter filter;
    HashMap oldLocals = new HashMap();
    private JPDAVariable[] oldVariables;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame;

    JPDACallStackFrame(JPDADebugger debugger, ThreadReference thread, int index) {
        this.debugger = debugger;
        this.threadS = thread;
        this.indexS = index;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StackFrame stackFrame() {
        StackFrame stackFrame;
        RequestProcessor.Task t = Protector.register((String)"JPDACallStackFrame.stackFrame");
        try {
            try {
                stackFrame = this.threadS.frame(this.indexS);
                Object var5_4 = null;
            }
            catch (IncompatibleThreadStateException e) {
                Object var5_5 = null;
                t.cancel();
                return null;
            }
            catch (InvalidStackFrameException e) {
                Object var5_6 = null;
                t.cancel();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            t.cancel();
            throw throwable;
        }
        t.cancel();
        return stackFrame;
    }

    public int getLineNumber() {
        try {
            return this.stackFrame().location().lineNumber();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getMethodName() {
        try {
            Method m = this.stackFrame().location().method();
            if (m == null) {
                return "";
            }
            return m.name();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return this.stackFrame().location().declaringType().name();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getSourceName() throws DebuggerException {
        try {
            return this.stackFrame().location().sourceName();
        }
        catch (Exception e) {
            throw new DebuggerException((Throwable)e);
        }
    }

    public String getInfo() {
        try {
            if (this.stackFrame().location().method().isNative()) {
                return null;
            }
            this.stackFrame().visibleVariables();
            return null;
        }
        catch (AbsentInformationException e) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame == null ? (class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame = JPDACallStackFrame.class$("org.netbeans.modules.debugger.jpda.JPDACallStackFrame")) : class$org$netbeans$modules$debugger$jpda$JPDACallStackFrame)).getString("CTL_Source_compiled_without_g");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AbstractVariable[] getVariables() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                if (this.oldVariables != null) {
                    JPDAVariable[] jPDAVariableArray = this.oldVariables;
                    return jPDAVariableArray;
                }
                AbstractVariable[] abstractVariableArray = new AbstractVariable[]{};
                return abstractVariableArray;
            }
            if (this.debugger.isDisconnected()) {
                AbstractVariable[] abstractVariableArray = new AbstractVariable[]{};
                return abstractVariableArray;
            }
            try {
                JPDAVariable var;
                List<Object> l = null;
                StackFrame sf = this.stackFrame();
                if (sf == null) {
                    AbstractVariable[] abstractVariableArray = new AbstractVariable[]{};
                    return abstractVariableArray;
                }
                if (sf.location().method().isNative()) {
                    l = new LinkedList();
                } else {
                    try {
                        l = sf.visibleVariables();
                    }
                    catch (AbsentInformationException e) {
                        l = new LinkedList();
                    }
                }
                HashMap<Object, JPDAVariable> newLocals = new HashMap<Object, JPDAVariable>();
                int k = l.size();
                ObjectReference objectRef = sf.thisObject();
                ArrayList<JPDAVariable> result = new ArrayList<JPDAVariable>();
                int i = 0;
                while (i < k) {
                    com.sun.jdi.LocalVariable lv = (com.sun.jdi.LocalVariable)l.get(i);
                    var = (JPDAVariable)this.oldLocals.get(lv);
                    try {
                        if (var == null) {
                            var = new LocalVariable(this.debugger, this.threadS, this.indexS, lv);
                        } else if (JPDAVariable.ON_LINE) {
                            var.validate();
                        }
                        result.add(var);
                        newLocals.put(lv, var);
                    }
                    catch (InconsistentDebugInfoException e) {
                        // empty catch block
                    }
                    ++i;
                }
                if (objectRef != null) {
                    var = (JPDAVariable)this.oldLocals.get("this");
                    if (var == null) {
                        var = new ThisLocalVariable(this.debugger, this.threadS, this.indexS);
                    } else if (JPDAVariable.ON_LINE) {
                        var.validate();
                    }
                    result.add(var);
                    newLocals.put("this", var);
                }
                this.oldLocals = newLocals;
                Iterator iter = ((AbstractList)result).iterator();
                JPDAVariable[] variables = new JPDAVariable[result.size()];
                int x = 0;
                while (x < result.size()) {
                    variables[x] = (JPDAVariable)iter.next();
                    ++x;
                }
                this.oldVariables = variables;
                JPDAVariable[] jPDAVariableArray = variables;
                return jPDAVariableArray;
            }
            catch (InvalidStackFrameException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            AbstractVariable[] abstractVariableArray = new AbstractVariable[]{};
            return abstractVariableArray;
        }
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (filter != null && filter.equals(this.filter)) {
            return;
        }
        VariablesFilter old = this.filter;
        this.filter = filter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

