/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.StaticField;
import org.netbeans.modules.debugger.jpda.ValueVariable;
import org.netbeans.modules.debugger.jpda.WatchVariable;
import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class JPDAClass
extends JavaClass {
    private ReferenceType referenceType;
    private JPDADebugger debugger;
    private boolean isClass;
    private MethodElement[] methods = null;
    private ConstructorElement[] constructors = null;
    private InitializerElement initializer = null;
    private FieldElement[] fields = null;
    private Hashtable classes = new Hashtable();

    public JPDAClass(ReferenceType ref, JPDADebugger debugger) {
        this.referenceType = ref;
        this.debugger = debugger;
        this.isClass = this.referenceType instanceof ClassType;
    }

    public String getName() {
        if (this.debugger.isDisconnected()) {
            return "";
        }
        try {
            return this.referenceType.name();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public JavaClass[] getInnerClasses() {
        if (this.debugger.isDisconnected()) {
            return new JPDAClass[0];
        }
        try {
            list = null;
            try {
                list = this.referenceType.nestedTypes();
            }
            catch (ConcurrentModificationException e) {
                try {
                    list = this.referenceType.nestedTypes();
                }
                catch (ConcurrentModificationException ee) {
                    return new JPDAClass[0];
                }
            }
            if (list.isEmpty()) {
                if (this.classes != null) {
                    this.classes.clear();
                }
                return new JavaClass[0];
            }
            iter = list.iterator();
            temp = new Hashtable<String, JavaClass>();
            try {
                prefixLength = this.referenceType.name().length() + 1;
                if (true) ** GOTO lbl38
            }
            catch (ObjectCollectedException ex) {
                return new JavaClass[0];
            }
            do {
                try {
                    ref = iter.next();
                    name = ref.name().substring(prefixLength);
                    inner = null;
                    if ((this.classes == null || (inner = (JavaClass)this.classes.get(name)) == null) && name.indexOf(36) == -1) {
                        inner = new JPDAClass(ref, this.debugger);
                    }
                    if (inner == null) continue;
                    temp.put(name, inner);
                }
                catch (ObjectCollectedException e) {
                    // empty catch block
                }
lbl38:
                // 4 sources

            } while (iter.hasNext());
            this.classes = temp;
            enum = this.classes.elements();
            res = new JavaClass[this.classes.size()];
            index = 0;
            while (enum.hasMoreElements()) {
                res[index++] = (JPDAClass)enum.nextElement();
            }
            return res;
        }
        catch (ObjectCollectedException e) {
        }
        catch (VMDisconnectedException var2_5) {
            // empty catch block
        }
        return new JavaClass[0];
    }

    private void initMethods() {
        if (this.debugger.isDisconnected()) {
            return;
        }
        if (this.methods != null && this.constructors != null) {
            return;
        }
        try {
            List<Method> methodsList = this.referenceType.methods();
            Iterator<Method> iter = methodsList.iterator();
            MethodElement[] tempM = new MethodElement[methodsList.size()];
            int index = 0;
            ArrayList<ConstructorElement> tempC = new ArrayList<ConstructorElement>();
            while (iter.hasNext()) {
                Method method = iter.next();
                if (method.isSynthetic()) continue;
                List<Object> args = new ArrayList();
                boolean failed = true;
                try {
                    args = method.arguments();
                    failed = false;
                }
                catch (AbsentInformationException e) {
                }
                catch (NativeMethodException e) {
                    // empty catch block
                }
                if (failed) {
                    args = method.argumentTypeNames();
                }
                MethodParameter[] params = new MethodParameter[args.size()];
                if (!failed) {
                    int x = 0;
                    while (x < args.size()) {
                        LocalVariable param = (LocalVariable)args.get(x);
                        params[x] = new MethodParameter(param.name(), Type.createClass((Identifier)Identifier.create((String)param.typeName())), false);
                        ++x;
                    }
                } else {
                    int x = 0;
                    while (x < args.size()) {
                        params[x] = new MethodParameter("", Type.createClass((Identifier)Identifier.create((String)((String)args.get(x)))), false);
                        ++x;
                    }
                }
                if (method.isStaticInitializer()) {
                    this.initializer = new InitializerElement();
                    this.initializer.setStatic(true);
                    continue;
                }
                ConstructorElement element = null;
                if (method.isConstructor()) {
                    element = new ConstructorElement();
                    tempC.add(element);
                } else {
                    element = new MethodElement();
                    ((MethodElement)element).setReturn(Type.createClass((Identifier)Identifier.create((String)method.returnTypeName())));
                    tempM[index++] = (MethodElement)element;
                }
                element.setParameters(params);
                element.setName(Identifier.create((String)method.name()));
                element.setModifiers(method.modifiers());
            }
            this.methods = new MethodElement[index];
            int x = 0;
            while (x < index) {
                this.methods[x] = tempM[x];
                ++x;
            }
            this.constructors = new ConstructorElement[tempC.size()];
            int x2 = 0;
            while (x2 < tempC.size()) {
                this.constructors[x2] = (ConstructorElement)tempC.get(x2);
                ++x2;
            }
            return;
        }
        catch (ObjectCollectedException e) {
        }
        catch (SourceException e) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
    }

    public MethodElement[] getMethods() {
        this.initMethods();
        if (this.methods != null) {
            return this.methods;
        }
        return new MethodElement[0];
    }

    public ConstructorElement[] getConstructors() {
        this.initMethods();
        if (this.constructors != null) {
            return this.constructors;
        }
        return new ConstructorElement[0];
    }

    public InitializerElement[] getInitializers() {
        InitializerElement[] initializerElementArray;
        this.initMethods();
        if (this.initializer == null) {
            initializerElementArray = new InitializerElement[]{};
        } else {
            InitializerElement[] initializerElementArray2 = new InitializerElement[1];
            initializerElementArray = initializerElementArray2;
            initializerElementArray2[0] = this.initializer;
        }
        return initializerElementArray;
    }

    public FieldElement[] getFields() {
        if (this.debugger.isDisconnected()) {
            return new FieldElement[0];
        }
        if (this.fields != null) {
            return this.fields;
        }
        try {
            List<Field> list = this.referenceType.fields();
            Iterator<Field> iter = list.iterator();
            FieldElement[] res = new FieldElement[list.size()];
            int index = 0;
            while (iter.hasNext()) {
                Field field = iter.next();
                FieldElement element = new FieldElement();
                element.setName(Identifier.create((String)field.name()));
                element.setType(Type.createClass((Identifier)Identifier.create((String)field.typeName())));
                element.setModifiers(field.modifiers());
                res[index++] = element;
            }
            this.fields = res;
            return res;
        }
        catch (ObjectCollectedException e) {
        }
        catch (SourceException e) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
        return new FieldElement[0];
    }

    public Identifier getSuperClass() {
        if (this.debugger.isDisconnected()) {
            return null;
        }
        if (!(this.referenceType instanceof ClassType)) {
            return null;
        }
        try {
            ClassType ref = ((ClassType)this.referenceType).superclass();
            if (ref != null) {
                return JavaClass.createClassIdentifier((String)ref.name());
            }
        }
        catch (ObjectCollectedException e) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
        return null;
    }

    public Identifier[] getInterfaces() {
        if (this.debugger.isDisconnected()) {
            return new Identifier[0];
        }
        try {
            List<InterfaceType> list = null;
            if (this.referenceType instanceof ClassType) {
                list = ((ClassType)this.referenceType).interfaces();
            }
            if (this.referenceType instanceof InterfaceType) {
                list = ((InterfaceType)this.referenceType).superinterfaces();
            }
            if (list == null) {
                return new Identifier[0];
            }
            Identifier[] res = new Identifier[list.size()];
            int x = 0;
            while (x < list.size()) {
                res[x] = JavaClass.createClassIdentifier((String)((ReferenceType)list.get(x)).name());
                ++x;
            }
            return res;
        }
        catch (ObjectCollectedException e) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            // empty catch block
        }
        return new Identifier[0];
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isPrepared() {
        if (this.debugger.isDisconnected()) {
            return false;
        }
        return this.referenceType.isPrepared();
    }

    public int modifiers() {
        if (this.debugger.isDisconnected()) {
            return 0;
        }
        return this.referenceType.modifiers();
    }

    public String classLoaderTypeName() {
        if (this.debugger.isDisconnected()) {
            return null;
        }
        if (this.referenceType.classLoader() == null) {
            return null;
        }
        try {
            return this.referenceType.classLoader().referenceType().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
    }

    public JavaVariable getClassLoader() {
        if (this.debugger.isDisconnected()) {
            return null;
        }
        ClassLoaderReference ref = this.referenceType.classLoader();
        if (ref == null) {
            return null;
        }
        ValueVariable var = new ValueVariable(this.debugger, "Classloader", ref.referenceType().name(), ref);
        return var;
    }

    public JavaVariable getStaticVariable(FieldElement element) {
        if (this.debugger.isDisconnected()) {
            return new WatchVariable(this.debugger, false);
        }
        return new StaticField(this.debugger, this.referenceType, this.referenceType.fieldByName(element.getName().getFullName()));
    }

    ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JPDAClass)) {
            return false;
        }
        return ((JPDAClass)((Object)o)).getReferenceType().equals(this.referenceType);
    }

    public int hashCode() {
        return this.referenceType.hashCode();
    }
}

