/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.EventRequestManager;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.jpda.FixActionImpl;
import org.netbeans.modules.debugger.jpda.JPDAClass;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.Launcher;
import org.netbeans.modules.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.PopFramesActionImpl;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.ThreadManager;
import org.netbeans.modules.debugger.jpda.VariableBreakpoint;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.StateSupport;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.LoadedClassesProducer;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.ErrorManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class JPDADebugger
extends JavaDebugger
implements LoadedClassesProducer {
    static final long serialVersionUID = 2797853329739651906L;
    public static int ACTION_ON_TI_FIND;
    private static Random random;
    transient CoreDebugger coreDebugger;
    transient VirtualMachine virtualMachine = null;
    protected transient ThreadManager threadManager;
    private StepManager stepManager;
    private transient Process process;
    transient boolean finishVM;
    private transient boolean disconnected = false;
    private transient Launcher launcher;
    private transient Hashtable loadedClasses = new Hashtable();
    private transient boolean isSuspended = false;
    private transient AttachingConnector connector;
    private transient Map args;
    private transient String mainClassName;
    private transient String stopClassName;
    transient JPDAThread currentThread = null;
    protected transient JPDAThreadGroup threadGroup;
    private transient boolean stopOnMain = false;
    private transient DebuggerInfo debuggerInfo;
    private static transient String[] stopMethodNames;
    private transient CoreBreakpoint[] breakpointMain = null;
    private transient boolean canRedefineClasses;
    private transient boolean canPopFrames;
    private transient FixActionImpl fixActionImpl;
    private transient PopFramesActionImpl popFramesActionImpl;
    transient DataObject dataObjectToFix;
    private transient SelectionListener selectionListener;
    private com.sun.jdi.Method toStringMethod;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebugger;
    static /* synthetic */ Class class$com$sun$jdi$VirtualMachine;

    public static String getLocString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = JPDADebugger.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger), (String)s);
    }

    public void startDebugger(DebuggerInfo info) throws DebuggerException {
        ((JPDAThreadGroup)this.getThreadsRoot()).setName(((AbstractDebuggerInfo)info).getProcessName());
        this.debuggerInfo = info;
        if (this.virtualMachine != null) {
            this.finishDebugger();
        }
        this.coreDebugger = Register.getCoreDebugger();
        this.stopOnMain = info.getStopClassName() != null;
        this.mainClassName = info.getClassName();
        this.finishVM = true;
        super.startDebugger(info);
        if (!(info instanceof RemoteDebuggerInfo) && !this.compile(info)) {
            this.finishDebugger();
            return;
        }
        this.disconnected = false;
        if (this.stopOnMain) {
            String stopClassName = this.debuggerInfo.getStopClassName();
            CoreDebugger d = this.coreDebugger;
            this.breakpointMain = new CoreBreakpoint[stopMethodNames.length];
            int x = 0;
            while (x < this.breakpointMain.length) {
                this.breakpointMain[x] = d.createBreakpoint(true);
                MethodBreakpoint mb = new MethodBreakpoint();
                mb.setClassName(stopClassName);
                mb.setMethodName(stopMethodNames[x]);
                this.breakpointMain[x].setEvent((CoreBreakpoint.Event)mb);
                CoreBreakpoint.Action[] a = this.breakpointMain[x].getActions();
                int ii = a.length;
                int i = 0;
                while (i < ii) {
                    if (a[i] instanceof PrintAction) {
                        ((PrintAction)a[i]).setPrintText(JPDADebugger.getLocString("CTL_Stop_On_Main_print_text"));
                    }
                    ++i;
                }
                ++x;
            }
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    if (ev.getPropertyName().equals("state") && ((Integer)ev.getNewValue() == 4 || (Integer)ev.getNewValue() == 1)) {
                        if (JPDADebugger.this.breakpointMain != null) {
                            int x = 0;
                            while (x < JPDADebugger.this.breakpointMain.length) {
                                JPDADebugger.this.breakpointMain[x].remove();
                                ++x;
                            }
                            JPDADebugger.access$002(JPDADebugger.this, null);
                        }
                        JPDADebugger.this.removePropertyChangeListener(this);
                    }
                }
            });
        }
        boolean launch = false;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            if (info instanceof ReconnectDebuggerInfo) {
                this.virtualMachine = this.reconnect((ReconnectDebuggerInfo)info);
            } else if (info instanceof RemoteDebuggerInfo) {
                this.virtualMachine = this.connect((RemoteDebuggerInfo)info);
            } else {
                this.virtualMachine = this.launch(info);
                this.getIOManager().showOutput(this.process, 3, 2);
                this.getIOManager().connectInput(this.process);
                launch = true;
            }
            Operator o = this.createOperator(launch);
            this.stepManager = this.createStepManager(this.virtualMachine.eventRequestManager(), o);
            o.start();
            this.setupHotswapCapabilities(this.virtualMachine);
            if (!launch) {
                this.startDebugger(false);
            }
        }
    }

    public synchronized void finishDebugger() throws DebuggerException {
        this.disconnected = true;
        if (this.threadManager != null) {
            this.threadManager.finish();
        }
        this.threadManager = null;
        this.loadedClasses = new Hashtable();
        if (this.breakpointMain != null) {
            int x = 0;
            while (x < this.breakpointMain.length) {
                this.breakpointMain[x].remove();
                ++x;
            }
            this.breakpointMain = null;
        }
        if (this.stepManager != null) {
            this.stepManager.destroy();
            this.stepManager = null;
        }
        if (this.finishVM) {
            try {
                if (this.virtualMachine != null) {
                    if (this.debuggerInfo instanceof RemoteDebuggerInfo) {
                        this.virtualMachine.dispose();
                    } else {
                        this.virtualMachine.exit(0);
                        if (this.process != null) {
                            this.process.destroy();
                        }
                    }
                }
                this.virtualMachine = null;
            }
            catch (VMDisconnectedException e) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        super.finishDebugger();
        if (this.selectionListener != null) {
            this.selectionListener.setEnabled(false);
            this.selectionListener = null;
        }
    }

    public synchronized void traceInto() throws DebuggerException {
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("traceInto start");
        }
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        if (this.getState() != 4) {
            return;
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("  traceInto start1");
        }
        this.setLastAction(3);
        this.setState(3);
        try {
            this.getStepManager().stepInto();
            this.setState(3);
            this.getIOManager().println(JavaDebugger.getString((String)"CTL_Debugger_running"), 4);
        }
        catch (IllegalThreadStateException e) {
            this.setState(4);
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("traceInto end");
            System.err.println("");
        }
    }

    public synchronized void traceOver() throws DebuggerException {
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("traceOver start");
        }
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        if (this.getState() != 4) {
            return;
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("  traceOver start1");
        }
        this.setLastAction(2);
        this.setState(3);
        try {
            this.getStepManager().stepOver();
            this.setState(3);
            this.getIOManager().println(JavaDebugger.getString((String)"CTL_Debugger_running"), 4);
        }
        catch (IllegalThreadStateException e) {
            this.setState(4);
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("traceOver end");
            System.err.println("");
        }
    }

    public synchronized void go() throws DebuggerException {
        if (this.virtualMachine == null) {
            return;
        }
        this.setLastAction(5);
        this.getStepManager().go();
        super.go();
    }

    public synchronized void stepOut() throws DebuggerException {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        this.setLastAction(4);
        this.setState(3);
        try {
            this.getStepManager().stepOut();
            this.setState(3);
            this.setCurrentLine(null);
            this.clearCallStackAnnotations();
            this.getIOManager().println(JavaDebugger.getString((String)"CTL_Debugger_running"), 4);
        }
        catch (IllegalThreadStateException e) {
            this.setState(4);
        }
    }

    public synchronized void runToCursor(Line l) {
        if (this.virtualMachine == null || this.currentThread == null) {
            return;
        }
        this.setLastAction(2);
        try {
            this.getStepManager().runToCursor(l);
            super.runToCursor(l);
        }
        catch (IllegalThreadStateException e) {
            this.setState(4);
        }
    }

    public void pause() {
        this.setSuspended(true);
    }

    public void setSuspended(boolean suspended) {
        if (suspended) {
            JPDAThread thread;
            this.suspend();
            if (this.currentThread == null && !this.disconnected && (thread = this.threadManager.getAnyThread()) != null) {
                thread.setCurrent(true);
            }
            this.setState(4);
            final IOManager ioManager = this.getIOManager();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ioManager.println(JPDADebugger.getLocString("CTL_Debugger_paused"), 4);
                }
            });
            this.threadManager.refreshStacks();
        } else {
            this.resume();
            this.setState(3);
        }
    }

    private synchronized void suspend() {
        try {
            if (this.isSuspended) {
                return;
            }
            this.isSuspended = true;
            if (this.virtualMachine != null) {
                this.virtualMachine.suspend();
                if (System.getProperty("netbeans.debug.step") != null) {
                    System.err.println("JPDADebugger.suspend");
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public synchronized void resume() {
        try {
            this.isSuspended = false;
            if (this.virtualMachine == null) {
                return;
            }
            if (this.currentThread == null) {
                this.virtualMachine.resume();
                if (System.getProperty("netbeans.debug.step") != null) {
                    System.err.println("JPDADebugger.resume");
                }
                return;
            }
            ThreadReference ref = this.currentThread.getThreadReference();
            int suspendCount = ref.suspendCount();
            if (suspendCount == 0) {
                this.virtualMachine.resume();
                if (System.getProperty("netbeans.debug.step") != null) {
                    System.err.println("JPDADebugger.resume2");
                }
                return;
            }
            int x = 0;
            while (x < suspendCount) {
                this.virtualMachine.resume();
                if (System.getProperty("netbeans.debug.step") != null) {
                    System.err.println("JPDADebugger.resume3");
                }
                ++x;
            }
        }
        catch (ObjectCollectedException e) {
            this.virtualMachine.resume();
            if (System.getProperty("netbeans.debug.step") != null) {
                System.err.println("JPDADebugger.resume4");
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public Watch createWatch() {
        JPDAWatch w = new JPDAWatch(this, false);
        this.addWatch((Watch)w);
        return w;
    }

    public Watch createWatch(String expr, boolean hidden) {
        JPDAWatch w = new JPDAWatch(this, false);
        w.setVariableName(expr);
        this.addWatch((Watch)w);
        return w;
    }

    public String getLocationName(DebuggerInfo info) {
        if (info instanceof RemoteDebuggerInfo) {
            if (JPDADebugger.hasShmemTransport(((RemoteDebuggerInfo)info).getConnector())) {
                return "localhost";
            }
            if (JPDADebugger.hasSocketTransport(((RemoteDebuggerInfo)info).getConnector())) {
                Connector.Argument name = (Connector.Argument)((RemoteDebuggerInfo)info).getArgs().get("hostname");
                return name == null ? "localhost" : name.value();
            }
            return "localhost";
        }
        return "localhost";
    }

    public ThreadsProducer getThreadsRoot() {
        if (this.threadGroup == null) {
            this.threadGroup = new JPDAThreadGroup("Thread");
        }
        return this.threadGroup;
    }

    public AbstractThread getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(AbstractThread thread) {
        if (this.currentThread == thread) {
            return;
        }
        JPDAThread old = this.currentThread;
        this.currentThread = (JPDAThread)thread;
        this.updateStoppedState();
        if (this.currentThread != null) {
            this.updateCurrentLine(this.currentThread.getLine());
        }
        this.firePropertyChange("currentThread", (Object)old, thread);
    }

    public List getLoadedClasses() {
        if (this.virtualMachine == null || this.disconnected) {
            this.loadedClasses = new Hashtable();
            return new ArrayList();
        }
        try {
            List<ReferenceType> list = this.virtualMachine.allClasses();
            ArrayList<JPDAClass> res = new ArrayList<JPDAClass>();
            Hashtable<ReferenceType, JPDAClass> newClasses = new Hashtable<ReferenceType, JPDAClass>();
            int i = 0;
            while (i < list.size()) {
                try {
                    ReferenceType ref = list.get(i);
                    if (!(ref instanceof ArrayType) && ref.name().indexOf(36) == -1) {
                        JPDAClass jpdaClass = (JPDAClass)((Object)this.loadedClasses.get(ref));
                        if (jpdaClass == null) {
                            jpdaClass = new JPDAClass(ref, this);
                        }
                        newClasses.put(ref, jpdaClass);
                        res.add(jpdaClass);
                    }
                }
                catch (ObjectCollectedException e) {
                    // empty catch block
                }
                ++i;
            }
            this.loadedClasses = newClasses;
            return res;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.loadedClasses = new Hashtable();
            return new ArrayList();
        }
    }

    synchronized void makeCurrent(String threadName, String className, String methodName, String lineNumber, boolean hasSource, boolean noInformation, ThreadReference tr, Line line) {
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("  JPDADebugger.makeCurrent");
        }
        JPDAThread tt = this.threadManager.getThread(tr);
        this.setCurrentThread((AbstractThread)tt);
        this.suspendedPatch = true;
        this.setState(4);
        this.suspendedPatch = false;
        IOManager ioManager = this.getIOManager();
        if (hasSource) {
            ioManager.println(new MessageFormat(JPDADebugger.getLocString("CTL_Thread_stopped")).format(new Object[]{threadName, className, methodName, lineNumber}), 5, line);
        } else if (noInformation) {
            ioManager.println(new MessageFormat(JPDADebugger.getLocString("CTL_Thread_stopped_no_information")).format(new Object[]{threadName, className, methodName}), 5);
        } else {
            ioManager.println(new MessageFormat(JPDADebugger.getLocString("CTL_Thread_stopped_no_source")).format(new Object[]{threadName, className, methodName, lineNumber}), 5);
        }
        Register.getCoreDebugger().setCurrentDebugger((AbstractDebugger)this);
        this.updateCurrentLine(line);
        this.updateUI();
    }

    private void updateCurrentLine(Line line) {
        if (line != null) {
            this.setCurrentLine(line);
        } else {
            JavaThread tt = (JavaThread)this.getCurrentThread();
            this.setCurrentLine(null);
            Location[] stack = tt.getCallStack();
            int k = stack.length;
            int i = 1;
            while (i < k) {
                if (Utils.showInEditor((Line)stack[i].getLine()) != null) break;
                ++i;
            }
        }
    }

    synchronized void stop(boolean stop, JPDAThread thread) {
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("JPDADebugger.stop thread " + (Object)((Object)thread));
        }
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = JPDADebugger.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger));
        if (stop) {
            this.getStepManager().stop();
            if (this.getLastAction() != 10) {
                this.setLastAction(1);
            }
            this.setCurrentThread((AbstractThread)thread);
            this.suspendedPatch = true;
            this.setState(4);
            this.suspendedPatch = false;
            Register.getCoreDebugger().setCurrentDebugger((AbstractDebugger)this);
            if (thread != null) {
                this.updateCurrentLine(thread.getLine());
            }
            this.updateUI();
        } else {
            this.getStepManager().resumeOperator();
        }
    }

    protected void updateUINow() {
        if (this.getState() != 4) {
            return;
        }
        if (this.threadManager != null) {
            this.threadManager.refreshStacks();
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("JPDADebugger.updateUINow -1)  threadManager.refreshStacks () done");
        }
        if (this.getState() != 4) {
            return;
        }
        JavaThread thread = (JavaThread)this.getCurrentThread();
        if (thread != null) {
            thread.makeCurrent();
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("JPDADebugger.updateUINow - 2) thread.makeCurrent () done");
        }
        super.updateUINow();
    }

    private StepManager createStepManager(EventRequestManager erm, Operator o) {
        return new StepManager(this, erm, o);
    }

    private Operator createOperator(boolean launch) {
        return new Operator(this.virtualMachine, this, launch ? new Runnable(){

            public void run() {
                JPDADebugger.this.startDebugger(true);
            }
        } : null, new Runnable(){

            public void run() {
                try {
                    JPDADebugger.this.finishVM = false;
                    JPDADebugger.this.finishDebugger();
                }
                catch (DebuggerException debuggerException) {
                    // empty catch block
                }
            }
        });
    }

    private void startDebugger(boolean calledFromOperator) {
        this.threadManager = new ThreadManager(this);
        boolean access = this.virtualMachine.canWatchFieldAccess();
        boolean modif = this.virtualMachine.canWatchFieldModification();
        if (!access || !modif) {
            CoreDebugger deb = this.coreDebugger;
            Breakpoint[] breakpoint = deb.getBreakpoints();
            int x = 0;
            while (x < breakpoint.length) {
                CoreBreakpoint.Event event;
                if (((CoreBreakpoint)breakpoint[x]).isEnabled() && (event = ((CoreBreakpoint)breakpoint[x]).getEvent((Debugger)deb)) instanceof VariableBreakpoint) {
                    if (!access && !modif) {
                        this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_not_supported"), 1);
                        break;
                    }
                    if (((VariableBreakpoint)event).getType() == 0 && !access) {
                        this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_access_not_supported"), 1);
                        break;
                    }
                    if (((VariableBreakpoint)event).getType() == 1 && !modif) {
                        this.getIOManager().println(JPDADebugger.getLocString("CTL_Break_on_field_modification_not_supported"), 1);
                        break;
                    }
                }
                ++x;
            }
        }
        this.getIOManager().println(JPDADebugger.getLocString("CTL_Debugger_running"), 4);
        this.setState(3);
        if (calledFromOperator) {
            this.getStepManager().resumeOperator();
        } else {
            List<ThreadReference> l = this.virtualMachine.allThreads();
            this.isSuspended = false;
            if (l.size() > 0) {
                ThreadReference tr = l.get(0);
                this.isSuspended = tr.isSuspended();
            }
            if (this.isSuspended) {
                this.setState(4);
            } else {
                this.setState(3);
            }
        }
    }

    private static String generatePassword() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 4) {
            sb.append((char)(random.nextInt(26) + 97));
            ++i;
        }
        return new String(sb);
    }

    private void setupHotswapCapabilities(VirtualMachine virtualMachine) {
        try {
            Object response;
            Class vmClass = class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = JPDADebugger.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine;
            try {
                Method canRedefineClassesMethod = vmClass.getMethod("canRedefineClasses", null);
                response = canRedefineClassesMethod.invoke((Object)virtualMachine, new Object[0]);
                this.canRedefineClasses = Boolean.TRUE.equals(response);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            try {
                Method canPopFramesMethod = vmClass.getMethod("canPopFrames", null);
                response = canPopFramesMethod.invoke((Object)virtualMachine, new Object[0]);
                this.canPopFrames = Boolean.TRUE.equals(response);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
    }

    private VirtualMachine launch(DebuggerInfo info) throws DebuggerException {
        try {
            if (this.launcher == null) {
                this.launcher = new Launcher(this.getIOManager());
            }
            VirtualMachine vm = this.launcher.launch(info);
            this.process = this.launcher.process();
            this.connector = this.launcher.attachingConnector();
            String address = this.launcher.address();
            this.args = this.connector.defaultArguments();
            if (JPDADebugger.hasShmemTransport(this.connector)) {
                ((Connector.Argument)this.args.get("name")).setValue(address);
            } else {
                ((Connector.Argument)this.args.get("port")).setValue(address);
            }
            return vm;
        }
        catch (DebuggerException e) {
            this.finishDebugger();
            throw e;
        }
    }

    private VirtualMachine reconnect(ReconnectDebuggerInfo info) throws DebuggerException {
        return this.connect("CTL_Reconnecting_to", info.getConnector(), info.getArgs());
    }

    private VirtualMachine connect(RemoteDebuggerInfo info) throws DebuggerException {
        this.connector = info.getConnector();
        this.args = info.getArgs();
        return this.connect("CTL_Connecting_to", this.connector, this.args);
    }

    private VirtualMachine connect(String bndlPrefix, AttachingConnector connector, Map args) throws DebuggerException {
        if (bndlPrefix != null) {
            if (JPDADebugger.hasShmemTransport(connector)) {
                Connector.Argument a = (Connector.Argument)args.get("name");
                if (a == null) {
                    this.getIOManager().println(JPDADebugger.getLocString(bndlPrefix + "_shmem_noargs"), 5);
                } else {
                    this.getIOManager().println(new MessageFormat(JPDADebugger.getLocString(bndlPrefix + "_shmem")).format(new Object[]{a.value()}), 5);
                }
            } else if (JPDADebugger.hasSocketTransport(connector)) {
                Connector.Argument name = (Connector.Argument)args.get("hostname");
                Connector.Argument port = (Connector.Argument)args.get("port");
                if (name == null || port == null) {
                    this.getIOManager().println(JPDADebugger.getLocString(bndlPrefix + "_socket_noargs"), 5);
                } else {
                    this.getIOManager().println(new MessageFormat(JPDADebugger.getLocString(bndlPrefix + "_socket")).format(new Object[]{name.value(), port.value()}), 5);
                }
            } else {
                this.getIOManager().println(JPDADebugger.getLocString(bndlPrefix), 5);
            }
        }
        Frame f = WindowManager.getDefault().getMainWindow();
        f.setCursor(Utilities.createProgressCursor((Component)f));
        try {
            try {
                VirtualMachine virtMachine = connector.attach(args);
                if (virtMachine != null) {
                    this.getIOManager().println(JPDADebugger.getLocString("CTL_Connection_established"), 1);
                }
                VirtualMachine virtualMachine = virtMachine;
                Object var8_8 = null;
                f.setCursor(0);
                return virtualMachine;
            }
            catch (Exception e) {
                this.finishDebugger();
                throw new DebuggerException(new MessageFormat(JPDADebugger.getLocString("EXC_While_connecting_to_debuggee")).format(new Object[]{e.toString()}), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            f.setCursor(0);
            throw throwable;
        }
    }

    boolean isDisconnected() {
        return this.disconnected;
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    protected void setLastAction(int la) {
        super.setLastAction(la);
    }

    public synchronized void setState(int newState) {
        if (this.getState() == newState) {
            return;
        }
        if (this.canRedefineClasses) {
            boolean isListening;
            boolean needsToListen = newState == 3 || newState == 4;
            boolean bl = isListening = this.selectionListener != null && this.selectionListener.isEnabled();
            if (needsToListen != isListening) {
                if (needsToListen) {
                    if (this.selectionListener == null) {
                        this.selectionListener = new SelectionListener();
                    }
                    this.selectionListener.setEnabled(true);
                    this.selectionListener.setDataObjectToFix();
                } else {
                    this.selectionListener.setEnabled(false);
                }
            }
        }
        super.setState(newState);
    }

    private void setDataObjectToFix(DataObject toFix) {
        boolean updateActionStates = toFix == null != (this.dataObjectToFix == null);
        this.dataObjectToFix = toFix;
        if (updateActionStates) {
            int state = this.getState();
            if (state == 3) {
                this.updateRunningState();
            } else if (state == 4) {
                this.updateStoppedState();
            }
        }
    }

    protected void updateStoppedState() {
        super.updateStoppedState();
    }

    public StepManager getStepManager() {
        return this.stepManager;
    }

    public EventRequestManager getRequestManager() {
        return this.getStepManager().getRequestManager();
    }

    protected void updateRunningState() {
        if (this.canRedefineClasses && this.dataObjectToFix != null) {
            this.setDebuggerState((State)new StateSupport(1056));
        } else {
            super.updateRunningState();
        }
    }

    private static boolean hasSocketTransport(Connector connector) {
        try {
            return connector.transport().name().toLowerCase().indexOf("socket") > -1;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private static boolean hasShmemTransport(Connector connector) {
        try {
            return connector.transport().name().toLowerCase().indexOf("shmem") > -1;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    com.sun.jdi.Method getToStringMethod() {
        if (this.toStringMethod != null) {
            return this.toStringMethod;
        }
        List<Comparable<ReferenceType>> list = this.virtualMachine.classesByName("java.lang.Object");
        ReferenceType refObject = list.iterator().next();
        list = refObject.methodsByName("toString");
        this.toStringMethod = (com.sun.jdi.Method)list.iterator().next();
        return this.toStringMethod;
    }

    public void fix() {
        if (this.fixActionImpl == null) {
            try {
                this.fixActionImpl = new FixActionImpl(this);
            }
            catch (NoSuchMethodException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
                this.canRedefineClasses = false;
                return;
            }
        }
        this.fixActionImpl.fix();
    }

    public boolean canPopFrames() {
        return this.canPopFrames;
    }

    public void popTopmostFrame() {
        if (this.popFramesActionImpl == null) {
            try {
                this.popFramesActionImpl = new PopFramesActionImpl(this);
            }
            catch (NoSuchMethodException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
                this.canPopFrames = false;
                return;
            }
        }
        this.popFramesActionImpl.popTopmostFrame();
    }

    void popFrames(JPDAThread thread, int frameIndex) throws NativeMethodException, InvocationTargetException, IncompatibleThreadStateException, IllegalAccessException {
        if (this.popFramesActionImpl == null) {
            try {
                this.popFramesActionImpl = new PopFramesActionImpl(this);
            }
            catch (NoSuchMethodException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
                this.canPopFrames = false;
                return;
            }
        }
        this.popFramesActionImpl.popFrames(thread, frameIndex);
    }

    protected boolean getStoppedStateForFix() {
        return this.canRedefineClasses && this.dataObjectToFix != null;
    }

    protected boolean getPopTopmostFrameState() {
        return this.canPopFrames && this.currentThread != null && this.currentThread.isSuspended() && this.currentThread.getStackDepth() > 1;
    }

    synchronized String getValue(Value value) {
        if (value instanceof StringReference) {
            String str = ((StringReference)value).value();
            str = JUtils.convertToStringInitializer((String)str);
            return "\"" + str + "\"";
        }
        if (value instanceof ObjectReference) {
            return "#" + ((ObjectReference)value).uniqueID();
        }
        if (value instanceof BooleanValue) {
            return "" + ((BooleanValue)value).value();
        }
        if (value instanceof ByteValue) {
            return Byte.toString(((ByteValue)value).value());
        }
        if (value instanceof BooleanValue) {
            return "" + ((CharValue)value).value();
        }
        if (value instanceof DoubleValue) {
            return Double.toString(((DoubleValue)value).value());
        }
        if (value instanceof FloatValue) {
            return Float.toString(((FloatValue)value).value());
        }
        if (value instanceof IntegerValue) {
            return Integer.toString(((IntegerValue)value).value());
        }
        if (value instanceof LongValue) {
            return Long.toString(((LongValue)value).value());
        }
        if (value instanceof ShortValue) {
            return Short.toString(((ShortValue)value).value());
        }
        return "???";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ CoreBreakpoint[] access$002(JPDADebugger x0, CoreBreakpoint[] x1) {
        x0.breakpointMain = x1;
        return x1;
    }

    static {
        random = new Random();
        stopMethodNames = new String[]{"main", "start", "init", "<init>"};
    }

    private final class SelectionListener
    implements PropertyChangeListener {
        private boolean enabled;
        private final TopComponent.Registry registry = TopComponent.getRegistry();
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public void setEnabled(boolean enabled) {
            if (enabled == this.enabled) {
                return;
            }
            this.enabled = enabled;
            if (enabled) {
                this.registry.addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                this.registry.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        private void setDataObjectToFix() {
            DataObject dataObj;
            DataObject toFix = null;
            Node[] selectedNodes = this.registry.getCurrentNodes();
            if (selectedNodes != null && selectedNodes.length == 1 && (dataObj = (DataObject)selectedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SelectionListener.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && dataObj.getPrimaryFile().getMIMEType().equalsIgnoreCase("text/x-java")) {
                toFix = dataObj;
            }
            JPDADebugger.this.setDataObjectToFix(toFix);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int state;
            if (evt.getPropertyName() == "currentNodes" && (state = JPDADebugger.this.getState()) != 3 && state != 4) {
                return;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ReconnectDebuggerInfo
    extends RemoteDebuggerInfo {
        private ReconnectDebuggerInfo(AttachingConnector connector, Map args) {
            super(connector, args);
        }
    }
}

