/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.Monitor;

public class JPDAMonitor
extends Monitor {
    private ObjectReference ref;
    private JPDADebugger debugger;

    public JPDAMonitor(JPDADebugger debugger, ObjectReference ref) {
        this.debugger = debugger;
        this.ref = ref;
    }

    public String name() {
        return "(" + this.ref.referenceType().name() + ") #" + this.ref.uniqueID();
    }

    public JavaThread owningThread() {
        try {
            ThreadReference thread = this.ref.owningThread();
            if (thread != null) {
                return this.debugger.threadManager.findThread(thread);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public JavaThread[] waitingThreads() {
        int x;
        LinkedList<JPDAThread> temp = new LinkedList<JPDAThread>();
        try {
            List<ThreadReference> threads = this.ref.waitingThreads();
            x = 0;
            while (x < threads.size()) {
                JPDAThread thread = this.debugger.threadManager.findThread(threads.get(x));
                if (thread != null) {
                    temp.add(thread);
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        JavaThread[] result = new JavaThread[temp.size()];
        x = 0;
        while (x < temp.size()) {
            result[x] = (JavaThread)temp.get(x);
            ++x;
        }
        return result;
    }

    ObjectReference reference() {
        return this.ref;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JPDAMonitor)) {
            return false;
        }
        return this.ref.equals(((JPDAMonitor)((Object)obj)).reference());
    }
}

