/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ThreadGroupReference;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.openide.debugger.DebuggerException;

public class JPDAThreadGroup
extends JavaThreadGroup {
    private ThreadGroupReference threadGroup;
    private String name = null;

    JPDAThreadGroup(String name) {
        this(null, null);
        this.name = name;
    }

    JPDAThreadGroup(JPDAThreadGroup parentThreadGroup, ThreadGroupReference threadGroup) {
        super((JavaThreadGroup)parentThreadGroup);
        this.threadGroup = threadGroup;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        try {
            return this.threadGroup.name();
        }
        catch (Exception exception) {
            return "Thread";
        }
    }

    void setName(String name) {
        this.name = name;
        this.firePropertyChange(null, null, null);
    }

    void markSuspended(boolean suspended) {
        JavaThread[] threads = this.getJavaThreads();
        int k = threads.length;
        int i = 0;
        while (i < k) {
            try {
                ((JPDAThread)threads[i]).markSuspended(suspended);
            }
            catch (DebuggerException e) {
                // empty catch block
            }
            ++i;
        }
        JPDAThreadGroup[] groups = (JPDAThreadGroup[])this.getThreadGroups();
        k = groups.length;
        i = 0;
        while (i < k) {
            groups[i].markSuspended(suspended);
            ++i;
        }
    }

    ThreadGroupReference getThreadGroupReference() {
        return this.threadGroup;
    }

    public String toString() {
        try {
            return "Thread Group: " + this.getName() + " (" + super.toString() + ")";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    void addThreadGroup(JPDAThreadGroup threadGroup) {
        super.addThreadGroup((JavaThreadGroup)threadGroup);
    }

    void removeThreadGroup(JPDAThreadGroup threadGroup) {
        super.removeThreadGroup((JavaThreadGroup)threadGroup);
    }

    void addThread(JPDAThread thread) {
        super.addThread((JavaThread)thread);
    }

    void removeThread(JPDAThread thread) {
        super.removeThread((JavaThread)thread);
    }

    void removeAllD() {
        this.removeAll();
    }

    void refresh() {
        this.firePropertyChange(null, null, null);
    }
}

