/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.jpda.ArrayElement;
import org.netbeans.modules.debugger.jpda.InstanceField;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAFilter;
import org.netbeans.modules.debugger.jpda.JPDAFixedWatch;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.SuperVariable;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.Evaluator;
import org.netbeans.modules.debugger.jpda.evaluator.TimeoutException;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public abstract class JPDAVariable
implements JavaVariable {
    public static boolean ON_LINE = false;
    protected transient Value remoteValue;
    protected transient String name;
    protected transient String value;
    protected transient String innerType;
    protected transient String type;
    protected transient String modifiers;
    protected transient VariablesFilter filter;
    protected transient HashMap oldVariables = new HashMap();
    private JavaVariable[] oldVariablesF;
    private transient JPDAVariable[] oldFields;
    protected transient boolean isCloned;
    private transient boolean isArray;
    protected transient boolean isObject;
    private transient Validator validator;
    private String oldToString;
    private int startIndex = 0;
    private int length = 100;
    private transient PropertyChangeSupport pcs;
    protected JPDADebugger debugger;
    protected boolean validate;
    private transient HashMap variables;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDAVariable;

    static void notify(String msg) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
    }

    static String getString(String msg) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$JPDAVariable == null ? (class$org$netbeans$modules$debugger$jpda$JPDAVariable = JPDAVariable.class$("org.netbeans.modules.debugger.jpda.JPDAVariable")) : class$org$netbeans$modules$debugger$jpda$JPDAVariable), (String)msg);
    }

    JPDAVariable(JPDADebugger debugger, boolean validate) {
        this.validator = validate ? debugger.getValidator() : null;
        this.debugger = debugger;
        this.validate = validate;
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        if (this.validate && !ON_LINE) {
            this.validator = this.debugger.getValidator();
            this.validator.add((Validator.Object)this);
        }
        this.pcs = new PropertyChangeSupport(this);
        this.variables = new HashMap();
    }

    public String getVariableName() {
        return this.name;
    }

    public String getAsText() {
        return this.value;
    }

    public void setAsText(String value) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                return;
            }
            if (this.isCloned) {
                return;
            }
            JPDAThread tt = (JPDAThread)this.debugger.getCurrentThread();
            if (tt == null) {
                return;
            }
            ThreadReference rt = tt.getThreadReference();
            int index = tt.getCurrentCallStackFrameIndex();
            if ((value = value.trim()).endsWith("B")) {
                try {
                    int i = Integer.parseInt(value.substring(0, value.length() - 1), 2);
                    value = "" + i;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            Value v = null;
            String val = value;
            try {
                LinkedList<String> imports = new LinkedList<String>();
                imports.add("java.lang");
                v = Evaluator.evaluate(val, this.debugger.virtualMachine, rt, index, imports);
            }
            catch (EvaluateException e) {
                if (e instanceof TimeoutException) {
                    Line l;
                    tt.setSuspended(true);
                    tt.refresh();
                    this.debugger.setCurrentLine(null);
                    int ln = tt.getLineNumber();
                    if (ln >= 0 && (l = tt.getLine()) != null) {
                        this.debugger.setCurrentLine(l);
                    }
                    this.debugger.annotateCallStack();
                } else {
                    JPDAVariable.notify(e.getLocalizedMessage());
                }
                return;
            }
            if (!this.setValue(v)) {
                return;
            }
            if (v == null) {
                this.setRemoteValue(null);
                this.type = "";
                this.update();
            } else {
                this.setRemoteValue(v);
                this.type = v.type().name();
                this.update();
            }
            this.firePropertyChange();
        }
    }

    public String getType() {
        return this.type;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public boolean isLeaf() {
        return this.remoteValue == null || !(this.remoteValue instanceof ObjectReference);
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (filter != null && filter.equals(this.filter)) {
            return;
        }
        VariablesFilter old = this.filter;
        this.filter = filter;
        this.pcs.firePropertyChange("variablesFilter", old, filter);
    }

    public AbstractVariable[] getVariables() {
        String name = this.name;
        if (this.remoteValue == null || !(this.remoteValue instanceof ObjectReference)) {
            return new JPDAVariable[0];
        }
        if (this.oldFields != null) {
            return this.oldFields;
        }
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                JavaVariable[] javaVariableArray = new JavaVariable[]{};
                return javaVariableArray;
            }
            try {
                JPDAVariable[] variable;
                if (this.remoteValue instanceof ArrayReference) {
                    String type = this.innerType.substring(0, this.innerType.length() - 2);
                    ArrayReference array = (ArrayReference)this.remoteValue;
                    int k = array.getValues().size();
                    variable = new JPDAVariable[k];
                    int i = 0;
                    while (i < k) {
                        variable[i] = new ArrayElement(this.debugger, array, name, i, type);
                        ++i;
                    }
                } else {
                    List<Field> fields = ((ObjectReference)this.remoteValue).referenceType().allFields();
                    int k = fields.size();
                    variable = new JPDAVariable[k];
                    int i = 0;
                    while (i < k) {
                        variable[i] = new InstanceField(this.debugger, (ObjectReference)this.remoteValue, fields.get(i));
                        ++i;
                    }
                }
                this.oldFields = variable;
                JPDAVariable[] jPDAVariableArray = variable;
                return jPDAVariableArray;
            }
            catch (Exception e) {
                JPDAVariable[] jPDAVariableArray = new JPDAVariable[]{};
                return jPDAVariableArray;
            }
        }
    }

    public String getInnerType() {
        return this.innerType;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public String getInfo() {
        return null;
    }

    public AbstractVariable getVariable(String fieldName) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                AbstractVariable abstractVariable = null;
                return abstractVariable;
            }
            try {
                Field f = ((ObjectReference)this.remoteValue).referenceType().fieldByName(fieldName);
                JPDAVariable var = (JPDAVariable)this.oldVariables.get(f);
                if (var == null) {
                    var = new InstanceField(this.debugger, (ObjectReference)this.remoteValue, f);
                    this.oldVariables.put(f, var);
                } else if (ON_LINE) {
                    var.validate();
                }
                JPDAVariable jPDAVariable = var;
                return jPDAVariable;
            }
            catch (Exception e) {
                AbstractVariable abstractVariable = null;
                return abstractVariable;
            }
        }
    }

    public int getVariablesNumber() {
        if (this.remoteValue == null || !(this.remoteValue instanceof ArrayReference)) {
            return 0;
        }
        return ((ArrayReference)this.remoteValue).length();
    }

    public boolean canRemove() {
        return true;
    }

    protected void update() {
        if (this.remoteValue == null) {
            this.isObject = false;
            this.isArray = false;
            this.value = "null";
            this.innerType = "";
        } else {
            try {
                this.isObject = this.remoteValue instanceof ObjectReference;
                this.isArray = this.remoteValue instanceof ArrayReference;
                this.value = this.debugger.getValue(this.remoteValue);
                this.innerType = this.remoteValue.type().name();
            }
            catch (Exception e) {
                this.type = null;
                this.value = e.toString();
            }
        }
    }

    protected void firePropertyChange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPDAVariable.this.pcs.firePropertyChange(null, null, null);
            }
        });
    }

    public String toString() {
        String n = this.getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + this.hashCode() + "[" + this.getParamString() + "]";
    }

    public String getParamString() {
        StringBuffer sb = new StringBuffer(50);
        if (this.name != null) {
            sb.append(this.name);
            sb.append(" = ");
        }
        String stringValue = null;
        if (this.debugger != null) {
            try {
                stringValue = this.toStringValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stringValue != null) {
            sb.append(stringValue);
        } else {
            sb.append('?');
        }
        return sb.toString();
    }

    public String toStringValue() {
        if (this.remoteValue == null) {
            return "null";
        }
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                if (this.oldToString != null) {
                    String string = this.oldToString;
                    return string;
                }
                String string = "?";
                return string;
            }
            try {
                if (this.remoteValue instanceof StringReference || this.remoteValue instanceof PrimitiveValue) {
                    String string = this.debugger.getValue(this.remoteValue);
                    return string;
                }
                if (this.remoteValue instanceof ArrayReference) {
                    String s = this.getInnerType();
                    if (s == null) {
                        String string = "";
                        return string;
                    }
                    int i = s.indexOf("[]");
                    if (i >= 0) {
                        s = s.substring(0, i + 1) + this.getSize() + s.substring(i + 1, s.length());
                    }
                    String string = s;
                    return string;
                }
                JPDAThread t = (JPDAThread)this.debugger.getCurrentThread();
                if (t == null) {
                    String string = "???";
                    return string;
                }
                ThreadReference thread = t.getThreadReference();
                if (thread == null) {
                    String string = "???";
                    return string;
                }
                ObjectReference obj = (ObjectReference)this.remoteValue;
                ReferenceType ref = ((ObjectReference)this.remoteValue).referenceType();
                Method method = this.debugger.getToStringMethod();
                try {
                    Value toStringValue = Evaluator.toString(obj, method, thread);
                    String string = this.oldToString = toStringValue instanceof StringReference ? ((StringReference)toStringValue).value() : "null";
                    return string;
                }
                catch (EvaluateException e) {
                    if (e instanceof TimeoutException) {
                        Line l;
                        t.setSuspended(true);
                        t.refresh();
                        this.debugger.setCurrentLine(null);
                        int ln = t.getLineNumber();
                        if (ln >= 0 && (l = t.getLine()) != null) {
                            this.debugger.setCurrentLine(l);
                        }
                        this.debugger.annotateCallStack();
                    }
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            String string = null;
            return string;
        }
    }

    public JavaVariable createFixedVariable() {
        return new JPDAFixedWatch(this.debugger, this.name, this.remoteValue, this.type);
    }

    public boolean isFixedVariable() {
        return this.isCloned;
    }

    JPDADebugger getDebugger() {
        return this.debugger;
    }

    Value getRemoteValue() {
        return this.remoteValue;
    }

    protected abstract boolean setValue(Value var1);

    protected void setRemoteValue(Value val) {
        if (val == this.remoteValue) {
            return;
        }
        if (val != null && this.remoteValue != null && val.equals(this.remoteValue)) {
            return;
        }
        this.remoteValue = val;
        this.oldVariables = new HashMap();
        this.disposeOldFields();
    }

    private void dispose() {
        this.debugger.getValidator().remove((Validator.Object)this);
        this.disposeOldFields();
    }

    private void disposeOldFields() {
        if (this.oldFields != null) {
            int k = this.oldFields.length;
            int i = 0;
            while (i < k) {
                this.oldFields[i].dispose();
                ++i;
            }
            this.oldFields = null;
        }
    }

    public JavaVariable[] filterVariables(ModifiersFilter jf, int startindex, int numberofitems) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                if (this.oldVariablesF != null) {
                    JavaVariable[] javaVariableArray = this.oldVariablesF;
                    return javaVariableArray;
                }
                JavaVariable[] javaVariableArray = new JavaVariable[]{};
                return javaVariableArray;
            }
            try {
                JavaVariable[] variable;
                HashMap<Comparable<Integer>, JavaVariable> newVariables = new HashMap<Comparable<Integer>, JavaVariable>();
                if (this.remoteValue instanceof ArrayReference) {
                    String type = this.innerType.substring(0, this.innerType.length() - 2);
                    ArrayReference array = (ArrayReference)this.remoteValue;
                    int k = Math.min(array.length(), numberofitems);
                    variable = new JPDAVariable[k];
                    int i = 0;
                    while (i < k) {
                        Integer index = new Integer(startindex + i);
                        variable[i] = (JPDAVariable)this.oldVariables.get(index);
                        if (variable[i] == null) {
                            variable[i] = new ArrayElement(this.debugger, array, this.name, startindex + i, type);
                        } else if (ON_LINE) {
                            variable[i].validate();
                        }
                        newVariables.put(index, variable[i]);
                        ++i;
                    }
                } else {
                    ClassType ref;
                    ClassType superRef;
                    List<Field> fields = null;
                    fields = jf != null && !jf.isInherited() ? ((ObjectReference)this.remoteValue).referenceType().fields() : ((ObjectReference)this.remoteValue).referenceType().allFields();
                    int k = fields.size();
                    ArrayList<JPDAVariable> al = new ArrayList<JPDAVariable>(k);
                    int i = 0;
                    while (i < k) {
                        Field fi = fields.get(i);
                        if (jf == null || JPDAFilter.filter(fi, jf)) {
                            String fieldName = fi.name();
                            JPDAVariable var = (JPDAVariable)this.oldVariables.get(fi);
                            if (var == null) {
                                var = new InstanceField(this.debugger, (ObjectReference)this.remoteValue, fi);
                            } else if (ON_LINE) {
                                var.validate();
                            }
                            newVariables.put(fi, var);
                            al.add(var);
                        }
                        ++i;
                    }
                    if (jf != null && !jf.isInherited() && (superRef = (ref = (ClassType)((ObjectReference)this.remoteValue).referenceType()).superclass()) != null) {
                        JPDAVariable superVar = (JPDAVariable)this.oldVariables.get(superRef);
                        if (superVar == null) {
                            superVar = new SuperVariable(this.debugger, (ObjectReference)this.remoteValue, superRef);
                        }
                        newVariables.put(superRef, superVar);
                        al.add(superVar);
                    }
                    variable = new JPDAVariable[al.size()];
                    variable = al.toArray(variable);
                }
                this.oldVariables = newVariables;
                this.oldVariablesF = variable;
                JavaVariable[] javaVariableArray = variable;
                return javaVariableArray;
            }
            catch (Exception e) {
                this.oldVariables = new HashMap();
                JavaVariable[] javaVariableArray = new JPDAVariable[]{};
                return javaVariableArray;
            }
        }
    }

    public int getSize() {
        if (this.remoteValue instanceof ArrayReference) {
            return ((ArrayReference)this.remoteValue).length();
        }
        return 0;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Invalid start index: " + index + " (must be non-negative)");
        }
        int old = this.startIndex;
        this.startIndex = index;
        this.firePropertyChange();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IllegalArgumentException("Invalid length: " + newLength + " (must be non-negative)");
        }
        int old = this.length;
        this.length = newLength;
        this.firePropertyChange();
    }

    public Object getSpecialVariable(String name) {
        return this.variables.get(name);
    }

    public void setSpecialVariable(String name, Object value) {
        this.variables.put(name, value);
        this.firePropertyChange();
    }

    public abstract void validate();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

