/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.WatchVariable;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.Evaluator;
import org.netbeans.modules.debugger.jpda.evaluator.TimeoutException;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.JavaWatch;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class JPDAWatch
extends JavaWatch {
    static final long serialVersionUID = 3439367144447814302L;
    protected WatchVariable var;
    private String errorMessage;
    private HashMap variables = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDAWatch;

    JPDAWatch(JPDADebugger debugger, boolean hidden) {
        super((JavaDebugger)debugger, hidden);
        this.var = new WatchVariable(debugger, false);
    }

    public boolean isInScope() {
        return this.getErrorMessage() == null;
    }

    public AbstractVariable getVariable() {
        return this.var;
    }

    public boolean isLeaf() {
        return false;
    }

    public void validate() {
        if (this.debugger.getState() == 1 || ((JPDADebugger)this.debugger).isDisconnected()) {
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("EXC_No_session"));
            this.firePropertyChange(null, null, null);
        } else if (this.debugger.getState() != 4) {
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("CTL_No_context"));
            this.firePropertyChange(null, null, null);
        } else {
            JPDAThread tt = (JPDAThread)this.debugger.getCurrentThread();
            if (tt != null) {
                JavaDebugger javaDebugger = this.debugger;
                synchronized (javaDebugger) {
                    this.refreshValue(tt);
                }
            } else {
                this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("CTL_No_context"));
                this.firePropertyChange(null, null, null);
            }
        }
    }

    public boolean canRemove() {
        return false;
    }

    public String getAsText() {
        if (!this.isInScope()) {
            return null;
        }
        String asText = this.var.getAsText();
        if (asText == null && this.errorMessage == null) {
            asText = "null";
        }
        return asText;
    }

    public String getType() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.getType();
    }

    public void setAsText(String value) {
        this.var.setAsText(value);
        this.firePropertyChange(null, null, null);
    }

    public AbstractVariable[] getVariables() {
        if (!this.isInScope()) {
            return new JPDAVariable[0];
        }
        return this.var.getVariables();
    }

    public JavaVariable[] filterVariables(ModifiersFilter jf, int startindex, int numberofitems) {
        if (!this.isInScope()) {
            return new JPDAVariable[0];
        }
        return this.var.filterVariables(jf, startindex, numberofitems);
    }

    public int getVariablesNumber() {
        if (!this.isInScope()) {
            return 0;
        }
        return this.var.getVariablesNumber();
    }

    public String toStringValue() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.toStringValue();
    }

    public String getInnerType() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.getInnerType();
    }

    public boolean isObject() {
        if (!this.isInScope()) {
            return false;
        }
        return this.var.isObject();
    }

    public boolean isArray() {
        if (!this.isInScope()) {
            return false;
        }
        return this.var.isArray();
    }

    public String getModifiers() {
        if (!this.isInScope()) {
            return "";
        }
        return this.var.getModifiers();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public AbstractVariable getVariable(String field) {
        if (!this.isInScope()) {
            return null;
        }
        return this.var.getVariable(field);
    }

    public JavaVariable createFixedVariable() {
        return this.var.createFixedVariable();
    }

    public boolean isFixedVariable() {
        return this.var.isFixedVariable();
    }

    protected void refreshValue(JavaThread t) {
        Value v;
        JPDAThread tt = (JPDAThread)t;
        ThreadReference rt = tt.getThreadReference();
        int index = tt.getCurrentCallStackFrameIndex();
        try {
            StackFrame sf = rt.frame(index);
        }
        catch (Exception e) {
            this.setErrorMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAWatch == null ? (class$org$netbeans$modules$debugger$jpda$JPDAWatch = JPDAWatch.class$("org.netbeans.modules.debugger.jpda.JPDAWatch")) : class$org$netbeans$modules$debugger$jpda$JPDAWatch)).getString("CTL_No_context"));
            this.firePropertyChange(null, null, null);
            return;
        }
        this.setErrorMessage(null);
        LinkedList<String> imports = new LinkedList<String>();
        imports.add("java.lang");
        try {
            v = Evaluator.evaluate(this.displayName, ((JPDADebugger)this.debugger).virtualMachine, rt, index, imports);
        }
        catch (EvaluateException e) {
            if (e instanceof TimeoutException) {
                Line l;
                tt.setSuspended(true);
                tt.refresh();
                this.debugger.setCurrentLine(null);
                int ln = tt.getLineNumber();
                if (ln >= 0 && (l = tt.getLine()) != null) {
                    this.debugger.setCurrentLine(l);
                }
                this.debugger.annotateCallStack();
            }
            this.setErrorMessage(e.getMessage());
            this.firePropertyChange(null, null, null);
            return;
        }
        this.var.update(this.displayName, v, v == null ? "" : v.type().name());
        this.firePropertyChange(null, null, null);
    }

    public String toString() {
        String n = ((Object)((Object)this)).getClass().getName();
        int i = n.lastIndexOf(46);
        if (i > 0) {
            n = n.substring(i + 1);
        }
        return n + ((Object)((Object)this)).hashCode() + "[" + this.var + ", " + this.getVariableName() + ", " + this.getErrorMessage() + "]";
    }

    protected void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public int getSize() {
        return this.var.getSize();
    }

    public int getStartIndex() {
        return this.var.getStartIndex();
    }

    public void setStartIndex(int newIndex) {
        this.var.setStartIndex(newIndex);
        this.firePropertyChange(null, null, null);
    }

    public int getLength() {
        return this.var.getLength();
    }

    public void setLength(int newLength) {
        this.var.setLength(newLength);
        this.firePropertyChange(null, null, null);
    }

    public Object getSpecialVariable(String name) {
        return this.variables.get(name);
    }

    public void setSpecialVariable(String name, Object value) {
        this.variables.put(name, value);
        this.firePropertyChange(null, null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

