/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.support.IOManager;
import org.netbeans.modules.debugger.support.ProcessDebuggerInfo;
import org.netbeans.modules.debugger.support.ProcessDebuggerType;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.openide.ErrorManager;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.NbProcessDescriptor;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Launcher {
    private ListeningConnector connector = null;
    private Map arguments = null;
    private String transport = null;
    private String address;
    private VirtualMachine virtualMachine;
    private Process process = null;
    private Exception thrownException = null;
    private boolean exited = false;
    private IOManager ioManager;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$Launcher;

    public static String getString(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$Launcher == null ? (class$org$netbeans$modules$debugger$jpda$Launcher = Launcher.class$("org.netbeans.modules.debugger.jpda.Launcher")) : class$org$netbeans$modules$debugger$jpda$Launcher), (String)s);
    }

    Launcher(IOManager ioManager) {
        this.ioManager = ioManager;
    }

    public synchronized VirtualMachine launch(DebuggerInfo info) throws DebuggerException {
        NbProcessDescriptor debuggerProcess;
        VirtualMachineManager vmm;
        LaunchingConnector lc;
        this.transport = System.getProperty("netbeans.debugger.jpda.transport");
        if (this.transport == null && Utilities.isWindows() && Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.3")) >= 0) {
            this.transport = "dt_socket";
        }
        if ((this.transport == null || (this.connector = Launcher.getListeningConnectorFor(this.transport)) == null) && (lc = (vmm = Bootstrap.virtualMachineManager()).defaultConnector()) != null) {
            this.transport = lc.transport().name();
            this.connector = Launcher.getListeningConnectorFor(this.transport);
        }
        if (this.connector != null) {
            this.arguments = this.connector.defaultArguments();
        }
        if (this.connector == null) {
            this.finish();
            throw new DebuggerException(new MessageFormat(Launcher.getString("EXC_Cannot_find_launcher")).format(new Object[]{"default"}));
        }
        File workingDirectory = null;
        if (info instanceof ProcessDebuggerInfo) {
            debuggerProcess = ((ProcessDebuggerInfo)info).getDebuggerProcess();
            workingDirectory = ((ProcessDebuggerInfo)info).getWorkingDirectory();
        } else {
            debuggerProcess = ProcessDebuggerType.DEFAULT_DEBUGGER_PROCESS;
        }
        try {
            this.address = this.connector.startListening(this.arguments);
        }
        catch (Exception e) {
            this.throwDebuggerException(debuggerProcess.getProcessName(), e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(info.getClassName());
        String[] infoArgs = info.getArguments();
        int i = 0;
        while (i < infoArgs.length) {
            sb.append(" \"").append(infoArgs[i]).append('\"');
            ++i;
        }
        String main = new String(sb);
        HashMap map = JUtils.processDebuggerInfo((DebuggerInfo)info, (String)("-Xdebug -Xnoagent -Xrunjdwp:transport=" + this.transport + ",address=" + this.address + ",suspend=y"), (String)main);
        MapFormat format = new MapFormat((Map)map);
        String commandLine = format.format(debuggerProcess.getProcessName() + " " + debuggerProcess.getArguments());
        String processName = format.format(debuggerProcess.getProcessName());
        this.ioManager.println(commandLine, 1);
        try {
            this.process = debuggerProcess.exec((Format)format, null, workingDirectory);
        }
        catch (IOException exc) {
            this.throwDebuggerException(processName, exc);
        }
        Thread acceptingThread = this.acceptConnection();
        Thread monitoringThread = this.monitorTarget();
        this.virtualMachine = null;
        this.exited = false;
        this.thrownException = null;
        try {
            block17: {
                try {
                    while (this.virtualMachine == null && this.thrownException == null && !this.exited) {
                        this.wait();
                    }
                    if (this.exited) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                        this.checkStream(bufferedReader, 1);
                        bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                        this.checkStream(bufferedReader, 2);
                        this.throwDebuggerException(processName, new IOException(Launcher.getString("CTL_VM_init_failed")));
                    }
                    if (this.thrownException == null) break block17;
                    this.throwDebuggerException(processName, this.thrownException);
                }
                catch (InterruptedException e) {
                    this.throwDebuggerException(processName, e);
                    Object var16_19 = null;
                    acceptingThread.interrupt();
                    monitoringThread.interrupt();
                }
            }
            Object var16_18 = null;
            acceptingThread.interrupt();
            monitoringThread.interrupt();
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            acceptingThread.interrupt();
            monitoringThread.interrupt();
            throw throwable;
        }
        return this.virtualMachine;
    }

    public void finish() {
        if (this.connector != null) {
            try {
                this.connector.stopListening(this.connector.defaultArguments());
            }
            catch (IOException e) {
            }
            catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    public Process process() {
        return this.process;
    }

    public String address() {
        return this.address;
    }

    public AttachingConnector attachingConnector() {
        return Launcher.getAttachingConnectorFor(this.transport);
    }

    synchronized void notifyOfExit() {
        this.exited = true;
        this.notify();
    }

    synchronized void notifyOfConnection(VirtualMachine vm) {
        this.virtualMachine = vm;
        this.notify();
    }

    synchronized void notifyOfThrownException(Exception thrownException) {
        this.thrownException = thrownException;
        this.notify();
    }

    private Thread monitorTarget() {
        Thread thread = new Thread("Launched target monitor"){

            public void run() {
                try {
                    Launcher.this.process.waitFor();
                    Launcher.this.notifyOfExit();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    private Thread acceptConnection() {
        Thread thread = new Thread("Connection acceptor"){

            public void run() {
                try {
                    VirtualMachine vm = Launcher.this.connector.accept(Launcher.this.arguments);
                    Launcher.this.finish();
                    Launcher.this.notifyOfConnection(vm);
                }
                catch (InterruptedIOException e) {
                }
                catch (Exception e) {
                    Launcher.this.notifyOfThrownException(e);
                }
            }
        };
        thread.start();
        return thread;
    }

    public static ListeningConnector getListeningConnectorFor(String transport) {
        List<ListeningConnector> lcs = Bootstrap.virtualMachineManager().listeningConnectors();
        int k = lcs.size();
        int i = 0;
        while (i < k) {
            ListeningConnector lc = lcs.get(i);
            if (lc.transport().name().equals(transport)) {
                return lc;
            }
            ++i;
        }
        return null;
    }

    public static AttachingConnector getAttachingConnectorFor(String transport) {
        List<AttachingConnector> acs = Bootstrap.virtualMachineManager().attachingConnectors();
        int k = acs.size();
        int i = 0;
        while (i < k) {
            AttachingConnector ac = acs.get(i);
            if (ac.transport().name().equals(transport)) {
                return ac;
            }
            ++i;
        }
        return null;
    }

    private void throwDebuggerException(String processName, Exception e) throws DebuggerException {
        this.finish();
        String description = e instanceof UnknownHostException ? Launcher.getString("EXC_Cannot_establish_connection_to_VM") : new MessageFormat(Launcher.getString("EXC_While_create_debuggee")).format(new Object[]{processName, e.toString()});
        DebuggerException de = new DebuggerException(description, (Throwable)e);
        ErrorManager.getDefault().annotate((Throwable)de, description);
        throw de;
    }

    static boolean isUnknownHost(String hostname) {
        if (hostname == null) {
            return true;
        }
        int length = hostname.length();
        if (length == 0) {
            return true;
        }
        if (length < 6) {
            return false;
        }
        char firstChar = hostname.charAt(0);
        if ('a' <= firstChar && firstChar <= 'z' || 'A' <= firstChar && firstChar <= 'Z' || firstChar == '-') {
            return false;
        }
        char c = hostname.charAt(5);
        if (c == firstChar) {
            return hostname.substring(1, 5).equalsIgnoreCase("none");
        }
        if (length < 9) {
            return false;
        }
        c = hostname.charAt(8);
        if (c == firstChar) {
            return hostname.substring(1, 8).equalsIgnoreCase("unknown");
        }
        return false;
    }

    public boolean checkStream(BufferedReader bufferedReader, int where) {
        int LIMIT = 20;
        int lineCounter = 0;
        boolean res = false;
        try {
            String line = bufferedReader.readLine();
            while (line != null && lineCounter < 20) {
                this.ioManager.println(line, where);
                line = bufferedReader.readLine();
                ++lineCounter;
            }
            bufferedReader.close();
        }
        catch (IOException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

