/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.LineBreakpointPanel;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaLineBreakpointEvent;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.HelpCtx;

public class LineBreakpoint
extends JavaLineBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = 1444281317183220550L;
    public static final String PROP_CONDITION = "condition";
    private transient ThreadReference thread;
    private transient StepManager.Requestor requestor;
    private transient ReferenceType tryClass;
    private String condition = "";
    private transient String outerClassName;
    private transient boolean isSetOnNestedClass;
    private transient CoreBreakpoint.Action[] actions;
    private HashSet refTypesWithBreakpoint;
    static /* synthetic */ Class class$java$lang$String;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger d = this.getDebugger();
        if (!(d instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)d;
        if (debugger.isDisconnected()) {
            return false;
        }
        if (this.getSourceName() == null || this.getSourceName().trim().length() < 1) {
            return false;
        }
        if (this.getLineNumber() < 0) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new StepManager.Requestor(debugger.getStepManager(), this);
        }
        try {
            if (debugger.virtualMachine == null) {
                return false;
            }
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            ClassPrepareRequest cpr = debugger.getRequestManager().createClassPrepareRequest();
            String sourceName = this.getSourceName();
            int dollarIndex = sourceName.indexOf(36);
            this.outerClassName = dollarIndex < 0 ? sourceName : sourceName.substring(0, dollarIndex);
            boolean bl = this.isSetOnNestedClass = sourceName != this.outerClassName;
            if (this.isSetOnNestedClass) {
                cpr.addClassFilter(this.outerClassName + "$*");
            } else {
                cpr.addClassFilter(this.outerClassName + '*');
            }
            cpr.setSuspendPolicy(2);
            this.requestor.add(cpr);
            cpr.enable();
            List<ReferenceType> l = debugger.virtualMachine.classesByName(this.outerClassName);
            if (l.size() == 0 && (l = debugger.virtualMachine.classesByName(sourceName)).size() == 0) {
                return false;
            }
            ArrayList<ReferenceType> list = new ArrayList<ReferenceType>(l);
            boolean set = false;
            int i = 0;
            while (i < list.size()) {
                ReferenceType ref = list.get(i);
                if (this.set(ref)) {
                    set = true;
                }
                try {
                    list.addAll(ref.nestedTypes());
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
                ++i;
            }
            return set;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    void refreshAfterFix(Set redefinedClasses, String classNamePrefix) {
        if ((classNamePrefix == null || ((LineBreakpointEvent)this).sourceName.startsWith(classNamePrefix)) && this.refTypesWithBreakpoint != null) {
            Set brkptsToRefresh = (Set)this.refTypesWithBreakpoint.clone();
            brkptsToRefresh.retainAll(redefinedClasses);
            Iterator i = brkptsToRefresh.iterator();
            while (i.hasNext()) {
                this.set((ReferenceType)i.next(), false);
            }
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = LineBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"sourceName", (String)JPDADebugger.getLocString("PROP_breakpoint_source_name"), (String)JPDADebugger.getLocString("HINT_breakpoint_source_name"), (String)"getSourceName", (String)"setSourceName"), Utils.createProperty((Object)this, Integer.TYPE, (String)"lineNumber", (String)JPDADebugger.getLocString("PROP_breakpoint_line_number"), (String)JPDADebugger.getLocString("HINT_breakpoint_line_number"), (String)"getLineNumber", (String)"setLineNumber"), Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = LineBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)JPDADebugger.getLocString("PROP_condition"), (String)JPDADebugger.getLocString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] parentActions = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new PrintAction(PrintAction.BREAKPOINT_TEXT)};
            if (parentActions.length != 0) {
                CoreBreakpoint.Action[] myActions = this.actions;
                this.actions = new CoreBreakpoint.Action[parentActions.length + myActions.length];
                System.arraycopy(parentActions, 0, this.actions, 0, parentActions.length);
                System.arraycopy(myActions, 0, this.actions, parentActions.length, myActions.length);
            }
        }
        return this.actions;
    }

    public boolean supportsMIMEType(String MIMEType) {
        return MIMEType.equals("text/x-java");
    }

    public JComponent getCustomizer() {
        String className = JUtils.getCurrentClassName();
        this.setSourceName(className);
        int ln = Utils.getCurrentLineNumber();
        if (ln > 0) {
            this.setLine(JUtils.getCurrentLine((String)className, (int)ln));
        }
        return new LineBreakpointPanel(this);
    }

    protected String getAnnotationType() {
        boolean isConditional;
        boolean bl = isConditional = this.condition != null && !this.condition.trim().equals("");
        if (this.getBreakpoint().isEnabled()) {
            return isConditional ? DebuggerAnnotation.Breakpoint.TYPE_CONDITIONAL : DebuggerAnnotation.Breakpoint.TYPE_NORMAL;
        }
        return isConditional ? DebuggerAnnotation.Breakpoint.TYPE_DISABLED_CONDITIONAL : DebuggerAnnotation.Breakpoint.TYPE_DISABLED;
    }

    public JavaThread getThread() {
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        return debugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineJPDA");
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            boolean v;
            boolean isDemanded;
            this.tryClass = ((ClassPrepareEvent)event).referenceType();
            String tryClassName = this.tryClass.name();
            String sourceName = this.getSourceName();
            boolean bl = isDemanded = this.isSetOnNestedClass || tryClassName.equals(sourceName) || tryClassName.startsWith(sourceName + '$');
            if (isDemanded && (v = this.set(this.tryClass)) && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            ((JPDADebugger)this.getDebugger()).getStepManager().resumeOperator();
            return;
        }
        this.thread = ((BreakpointEvent)event).thread();
        this.perform();
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        if (!this.condition.trim().equals("")) {
            JPDADebugger debugger = (JPDADebugger)this.getDebugger();
            JPDAWatch watch = new JPDAWatch(debugger, true);
            watch.setVariableName(this.condition);
            watch.refreshValue((JPDAThread)this.getThread());
            String type = watch.getType();
            String value = watch.getAsText();
            if (type != null && type.equals("boolean") && value != null && value.equals("false")) {
                this.stop(false);
                return;
            }
            if (type == null || !type.equals("boolean")) {
                debugger.getIOManager().println(JPDADebugger.getLocString("CTL_Incorrect_condition") + ": " + JPDADebugger.getLocString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
        CoreBreakpoint.Action[] actions = this.getBreakpoint().getActions();
        int i = 0;
        while (i < actions.length) {
            if (actions[i] instanceof JavaStopAction) {
                ((JavaStopAction)actions[i]).performStopAction((CoreBreakpoint.Event)this);
            }
            ++i;
        }
    }

    public void stop(boolean stop) {
        CoreBreakpoint.Action[] actions = this.getBreakpoint().getActions();
        int ii = actions.length;
        int i = 0;
        while (i < ii) {
            if (actions[i] instanceof PrintAction && ((PrintAction)actions[i]).getPrintText() == PrintAction.RUN_TO_CURSOR_TEXT) {
                ((JPDADebugger)this.getDebugger()).setLastAction(10);
                break;
            }
            ++i;
        }
        ((JPDADebugger)this.getDebugger()).stop(stop, (JPDAThread)this.getThread());
    }

    public final boolean set(ReferenceType clazz) {
        return this.set(clazz, true);
    }

    protected boolean set(ReferenceType clazz, boolean checkDuplicity) {
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        if (this.getLineNumber() < 0) {
            return false;
        }
        if (checkDuplicity) {
            LineBreakpoint lineBreakpoint = this;
            synchronized (lineBreakpoint) {
                if (this.refTypesWithBreakpoint == null) {
                    this.refTypesWithBreakpoint = new HashSet(17);
                } else {
                    try {
                        if (this.refTypesWithBreakpoint.contains(clazz)) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (ObjectCollectedException ex) {
                        // empty catch block
                    }
                }
                this.refTypesWithBreakpoint.add(clazz);
            }
        }
        try {
            Location loc;
            Line originalLine;
            int number = this.getLineNumber();
            Line.Set lineSet = JUtils.getLineSet((String)this.getSourceName());
            if (lineSet != null && (originalLine = lineSet.getOriginal(((LineBreakpointEvent)this).lineNumber)) != null) {
                number = originalLine.getLineNumber();
            }
            if ((loc = LineBreakpoint.getLocation(clazz, number)) == null) {
                return false;
            }
            try {
                Line newLine;
                CoreBreakpoint breakpoint = this.getBreakpoint();
                if (breakpoint.getLine() == null && !breakpoint.isHidden() && (newLine = JUtils.getLineForSource((String)this.getSourceName(), (String)loc.sourceName(), (int)this.getLineNumber())) != null) {
                    ((LineBreakpoint)breakpoint.getEvent()).setLine(newLine);
                }
            }
            catch (AbsentInformationException e) {
                // empty catch block
            }
            BreakpointRequest br = debugger.getRequestManager().createBreakpointRequest(loc);
            br.setSuspendPolicy(2);
            this.requestor.add(br);
            br.enable();
            return true;
        }
        catch (VMDisconnectedException e) {
            return false;
        }
    }

    private static Location getLocation(ReferenceType clazz, int lineNumber) {
        try {
            List<Location> locL = null;
            locL = clazz.locationsOfLine(lineNumber);
            if (locL != null && locL.size() > 0) {
                return locL.get(0);
            }
            locL = clazz.locationsOfLine(lineNumber + 1);
            if (locL != null && locL.size() > 0) {
                return locL.get(0);
            }
            locL = clazz.locationsOfLine(lineNumber + 2);
            if (locL != null && locL.size() > 0) {
                return locL.get(0);
            }
            if (lineNumber == 0) {
                return null;
            }
            locL = clazz.locationsOfLine(lineNumber - 1);
            if (locL != null && locL.size() > 0) {
                return locL.get(0);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

