/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.debugger.Controller;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings;
import org.netbeans.modules.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.support.java.JavaElementSelector;
import org.netbeans.modules.debugger.support.java.PackageClassHistory;
import org.netbeans.modules.debugger.support.util.AbstractHistory;
import org.netbeans.modules.debugger.support.util.PackageListLoader;
import org.netbeans.modules.debugger.support.util.SimpleHistory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

class LineBreakpointPanel
extends JPanel
implements Controller,
Runnable {
    static final long serialVersionUID = -8164649328980808272L;
    private final String DOT = ".";
    private final JPDADebuggerProjectSettings historyStorage;
    private final SimpleHistory packageHistory;
    private final PackageClassHistory classHistory;
    private final SimpleHistory conditionHistory;
    private LineBreakpoint event;
    private JavaElementSelector javaElementSelector;
    private String pkg;
    private String cls;
    private boolean valid = false;
    private JComboBox cboxCondition;
    private JLabel lblClassName;
    private JComboBox cboxClass;
    private JComboBox cboxPackage;
    private JLabel lblLineNumber;
    private JLabel lblPackageName;
    private JTextField tfLineNumber;
    private JLabel lblCondition;
    private JPanel jPanel1;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings;

    public LineBreakpointPanel(LineBreakpoint e) {
        this.event = e;
        this.javaElementSelector = new JavaElementSelector(2);
        this.javaElementSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                LineBreakpointPanel.this.setEventSource(e2.getSource());
            }
        });
        this.initComponents();
        this.putClientProperty("HelpID", "debug.add.breakpoint.java.line");
        Listener l = new Listener(this);
        this.cboxClass.getEditor().getEditorComponent().addKeyListener(l);
        this.cboxClass.addActionListener(l);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_LineBreakpointPanel"));
        this.cboxPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Package_name"));
        this.cboxClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Class_name"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Line_number"));
        this.cboxCondition.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("ACSD_CTL_Condition"));
        this.historyStorage = (JPDADebuggerProjectSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.JPDADebuggerProjectSettings")) : class$org$netbeans$modules$debugger$jpda$JPDADebuggerProjectSettings), (boolean)true);
        this.packageHistory = this.historyStorage.getPackageHistory();
        this.classHistory = this.historyStorage.getClassHistory();
        this.conditionHistory = this.historyStorage.getBreakpointConditionHistory();
        this.javaElementSelector.setPackageHistory((AbstractHistory)this.packageHistory);
        this.javaElementSelector.setClassHistory(this.classHistory);
        if (this.conditionHistory.getSize() != 0) {
            this.cboxCondition.setModel(new DefaultComboBoxModel<String>(this.conditionHistory.getItemsAsArray()));
        }
        this.fillPackageAndClass();
        this.fillLineNumber();
        this.tfLineNumber.setMinimumSize(this.tfLineNumber.getPreferredSize());
        String s = e.getCondition();
        this.cboxCondition.setSelectedItem(s == null ? "" : s.trim());
        this.run();
    }

    private void initComponents() {
        this.lblPackageName = new JLabel();
        this.cboxPackage = this.javaElementSelector.getPackageSelector();
        this.lblClassName = new JLabel();
        this.cboxClass = this.javaElementSelector.getClassSelector();
        this.lblLineNumber = new JLabel();
        this.tfLineNumber = new JTextField();
        this.lblCondition = new JLabel();
        this.cboxCondition = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblPackageName.setLabelFor(this.cboxPackage);
        this.lblPackageName.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Package_name_mnemonic").charAt(0));
        this.lblPackageName.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Package_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 2);
        this.add((Component)this.lblPackageName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(4, 6, 2, 2);
        this.add((Component)this.cboxPackage, gridBagConstraints);
        this.lblClassName.setLabelFor(this.cboxClass);
        this.lblClassName.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Class_name_mnemonic").charAt(0));
        this.lblClassName.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Class_name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.lblClassName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.add((Component)this.cboxClass, gridBagConstraints);
        this.lblLineNumber.setLabelFor(this.tfLineNumber);
        this.lblLineNumber.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Line_number"));
        this.lblLineNumber.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Line_number_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.lblLineNumber, gridBagConstraints);
        this.tfLineNumber.setColumns(7);
        this.tfLineNumber.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LineBreakpointPanel.this.tfLineNumberFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                LineBreakpointPanel.this.tfLineNumberFocusLost(evt);
            }
        });
        this.tfLineNumber.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                LineBreakpointPanel.this.tfLineNumberKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.add((Component)this.tfLineNumber, gridBagConstraints);
        this.lblCondition.setLabelFor(this.cboxCondition);
        this.lblCondition.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Condition"));
        this.lblCondition.setDisplayedMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel = LineBreakpointPanel.class$("org.netbeans.modules.debugger.jpda.LineBreakpointPanel")) : class$org$netbeans$modules$debugger$jpda$LineBreakpointPanel)).getString("CTL_Condition_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.lblCondition, gridBagConstraints);
        this.cboxCondition.setEditable(true);
        this.cboxCondition.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                LineBreakpointPanel.this.cboxConditionFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                LineBreakpointPanel.this.cboxConditionFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.add((Component)this.cboxCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void tfLineNumberKeyTyped(KeyEvent evt) {
        this.run();
    }

    private void cboxConditionFocusGained(FocusEvent evt) {
        if (!evt.isTemporary()) {
            this.cboxCondition.getEditor().selectAll();
        }
    }

    private void cboxConditionFocusLost(FocusEvent evt) {
        if (!evt.isTemporary()) {
            ComboBoxEditor editor = this.cboxCondition.getEditor();
            String value = ((String)editor.getItem()).trim();
            this.event.setCondition(value);
        }
    }

    private void setEventSource(Object changedComboBox) {
        if (changedComboBox == this.cboxPackage) {
            this.pkg = this.javaElementSelector.getSelectedPackage().trim();
            this.classHistory.setPackage(this.pkg);
        } else {
            this.cls = this.javaElementSelector.getSelectedClass().trim();
        }
        String clsFilter = this.cls.replace('.', '$');
        if (this.pkg.length() == 0) {
            this.event.setSourceName(clsFilter);
        } else {
            this.event.setSourceName(this.pkg + '.' + clsFilter);
        }
        this.run();
    }

    private void tfLineNumberFocusGained(FocusEvent evt) {
        if (!evt.isTemporary()) {
            ((JTextField)evt.getComponent()).selectAll();
        }
    }

    private void tfLineNumberFocusLost(FocusEvent evt) {
        if (!evt.isTemporary()) {
            if (this.tfLineNumber.getText().trim().length() > 0) {
                try {
                    int i = Integer.parseInt(this.tfLineNumber.getText());
                    if (i < 1) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JPDADebugger.getLocString("CTL_Bad_line_number"), 0));
                    } else {
                        this.event.setLineNumber(i);
                    }
                }
                catch (NumberFormatException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JPDADebugger.getLocString("CTL_Bad_line_number"), 0));
                }
            }
            this.fillLineNumber();
        }
    }

    private void fillPackageAndClass() {
        String s = this.event.getSourceName().trim();
        if (s.length() < 1) {
            this.pkg = "";
            this.cls = "";
        } else {
            int dotIndex = s.lastIndexOf(46);
            if (dotIndex == -1) {
                this.pkg = "";
                this.cls = s;
            } else {
                this.pkg = s.substring(0, dotIndex);
                this.cls = s.substring(dotIndex + 1);
            }
            this.javaElementSelector.setInitialSelection(this.pkg, this.cls);
        }
    }

    private void fillLineNumber() {
        if (this.event.getLineNumber() < 1) {
            this.tfLineNumber.setText("");
        } else {
            this.tfLineNumber.setText("" + this.event.getLineNumber());
        }
    }

    public boolean ok() {
        if (this.pkg.length() > 0) {
            this.packageHistory.addItem((Object)this.pkg);
        }
        if (this.cls.length() > 0) {
            this.classHistory.addItem((Object)this.cls);
        }
        this.historyStorage.setPackageHistory(this.packageHistory);
        this.historyStorage.setClassHistory(this.classHistory);
        String condition = (String)this.cboxCondition.getSelectedItem();
        if (condition != null && (condition = condition.trim()).length() != 0) {
            this.conditionHistory.addItem((Object)condition);
            this.historyStorage.setBreakpointConditionHistory(this.conditionHistory);
        }
        PackageListLoader.reset();
        return true;
    }

    public boolean cancel() {
        PackageListLoader.reset();
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean nv = false;
                String ln = LineBreakpointPanel.this.tfLineNumber.getText().trim();
                String cls = LineBreakpointPanel.this.javaElementSelector.getSelectedClass().trim();
                if (ln.length() > 0) {
                    try {
                        int i = Integer.parseInt(ln);
                        if (i > 0) {
                            nv = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (cls.length() < 1) {
                    nv = false;
                }
                if (LineBreakpointPanel.this.valid == nv) {
                    return;
                }
                LineBreakpointPanel.this.valid = nv;
                LineBreakpointPanel.super.firePropertyChange("valid", !LineBreakpointPanel.this.valid ? Boolean.TRUE : Boolean.FALSE, LineBreakpointPanel.this.valid ? Boolean.TRUE : Boolean.FALSE);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Listener
    extends KeyAdapter
    implements ActionListener {
        Runnable validator;

        Listener(Runnable v) {
            this.validator = v;
        }

        public void keyTyped(KeyEvent evt) {
            this.validator.run();
        }

        public void actionPerformed(ActionEvent evt) {
            this.validator.run();
        }
    }
}

