/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class LocalVariable
extends JPDAVariable {
    private ThreadReference thread = null;
    private int callStackIndex;
    private com.sun.jdi.LocalVariable lv;

    LocalVariable(JPDADebugger debugger, ThreadReference thread, int callStackIndex, com.sun.jdi.LocalVariable lv) {
        super(debugger, true);
        this.thread = thread;
        this.callStackIndex = callStackIndex;
        this.lv = lv;
        this.name = lv.name();
        this.type = lv.typeName();
        try {
            this.setRemoteValue(thread.frame(callStackIndex).getValue(lv));
        }
        catch (IncompatibleThreadStateException e) {
        }
        catch (InvalidStackFrameException e) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.modifiers = "";
        this.update();
    }

    public void validate() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                return;
            }
            if (this.isCloned) {
                if (this.isObject) {
                    this.value = this.debugger.getValue(this.remoteValue);
                }
            } else {
                try {
                    this.setRemoteValue(this.thread.frame(this.callStackIndex).getValue(this.lv));
                    this.type = this.lv.typeName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.update();
            }
            this.firePropertyChange();
        }
    }

    protected boolean setValue(final Value v) {
        try {
            new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    StackFrame stackFrame = LocalVariable.this.thread.frame(LocalVariable.this.callStackIndex);
                    stackFrame.setValue(LocalVariable.this.lv, v);
                    return null;
                }
            }.throwAndWait(null);
        }
        catch (InvalidTypeException e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

