/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.MethodBreakpointPanel;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Utils;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.ClassBreakpointEvent;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.MethodBreakpointEvent;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MethodBreakpoint
extends MethodBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = -2226362778610894492L;
    public static final String PROP_ALL_METHODS = "allMethods";
    public static final String PROP_CONDITION = "condition";
    private transient ThreadReference thread;
    private StepManager.Requestor requestor;
    private ReferenceType tryClass;
    private LinkedList lines = new LinkedList();
    private Line[] linesArray;
    private boolean allMethods = false;
    private boolean methodEntry = true;
    private String condition = "";
    private transient CoreBreakpoint.Action[] actions;
    private HashSet refTypesWithBreakpoint;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$VariableBreakpoint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$MethodBreakpoint;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$LineBreakpoint;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger d = this.getDebugger();
        if (!(d instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)d;
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        if (this.getClassName() == null || this.getClassName().trim().length() < 1) {
            return false;
        }
        if (!(this.getAllMethods() || this.getMethodName() != null && this.getMethodName().trim().length() >= 1)) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new StepManager.Requestor(debugger.getStepManager(), this);
        }
        try {
            ReferenceType ref2;
            String classFilter;
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            String string = classFilter = this.getApplyToAnonymousInnerClasses() ? this.getClassName() + '*' : this.getClassName();
            if (this.allMethods) {
                EventRequest er;
                if (this.methodEntry) {
                    MethodEntryRequest mer = debugger.getRequestManager().createMethodEntryRequest();
                    mer.addClassFilter(classFilter);
                    er = mer;
                } else {
                    MethodExitRequest mer = debugger.getRequestManager().createMethodExitRequest();
                    mer.addClassFilter(classFilter);
                    er = mer;
                }
                er.setSuspendPolicy(2);
                this.requestor.add(er);
                er.enable();
                return true;
            }
            ClassPrepareRequest cpr = debugger.getRequestManager().createClassPrepareRequest();
            cpr.addClassFilter(classFilter);
            cpr.setSuspendPolicy(2);
            this.requestor.add(cpr);
            cpr.enable();
            List<ReferenceType> l = debugger.virtualMachine.classesByName(this.getClassName());
            if (l.size() == 0) {
                return false;
            }
            boolean set = false;
            if (!this.getApplyToAnonymousInnerClasses()) {
                int iterCount = l.size();
                int i = 0;
                while (i < iterCount) {
                    ReferenceType ref2 = l.get(i);
                    if (this.set(ref2)) {
                        set = true;
                    }
                    ++i;
                }
                return set;
            }
            ArrayList<ReferenceType> anonymousInner = new ArrayList<ReferenceType>();
            int iterCount = l.size();
            int i = 0;
            while (i < iterCount) {
                ref2 = l.get(i);
                if (this.set(ref2)) {
                    set = true;
                }
                try {
                    anonymousInner.addAll(Utils.anonymousInnerClasses(ref2.name(), ref2.nestedTypes()));
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while (i < anonymousInner.size()) {
                ref2 = (ReferenceType)anonymousInner.get(i);
                if (this.set(ref2)) {
                    set = true;
                }
                try {
                    anonymousInner.addAll(ref2.nestedTypes());
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
                ++i;
            }
            return set;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
        this.linesArray = null;
        this.lines = new LinkedList();
    }

    void refreshAfterFix(Set redefinedClasses, String classNamePrefix) {
        if ((classNamePrefix == null || ((ClassBreakpointEvent)this).className.startsWith(classNamePrefix)) && this.refTypesWithBreakpoint != null) {
            Set brkptsToRefresh = (Set)this.refTypesWithBreakpoint.clone();
            brkptsToRefresh.retainAll(redefinedClasses);
            Iterator i = brkptsToRefresh.iterator();
            while (i.hasNext()) {
                this.set((ReferenceType)i.next(), false);
            }
        }
    }

    public Node.Property[] getProperties() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$VariableBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$VariableBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.VariableBreakpoint")) : class$org$netbeans$modules$debugger$jpda$VariableBreakpoint));
        return new Node.Property[]{org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = MethodBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"className", (String)bundle.getString("PROP_breakpoint_class_name"), (String)bundle.getString("HINT_breakpoint_class_name"), (String)"getClassName", (String)"setClassName"), org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, Boolean.TYPE, (String)"includingAnonymousInnerClasses", (String)bundle.getString("PROP_breakpoint_apply_to_anonymous_inner"), (String)bundle.getString("HINT_breakpoint_apply_to_anonymous_inner"), (String)"getApplyToAnonymousInnerClasses", (String)"setApplyToAnonymousInnerClasses"), org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = MethodBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"methodName", (String)bundle.getString("PROP_breakpoint_method_name"), (String)bundle.getString("HINT_breakpoint_method_name"), (String)"getMethodName", (String)"setMethodName"), org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, Boolean.TYPE, (String)PROP_ALL_METHODS, (String)bundle.getString("PROP_breakpoint_all_methods"), (String)bundle.getString("HINT_breakpoint_all_methods"), (String)"getAllMethods", (String)"setAllMethods"), org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = MethodBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)bundle.getString("PROP_condition"), (String)bundle.getString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public Line[] getLines() {
        if (this.linesArray != null) {
            return this.linesArray;
        }
        if (this.lines.size() == 0) {
            return null;
        }
        this.linesArray = this.lines.toArray(new Line[this.lines.size()]);
        return this.linesArray;
    }

    public JComponent getCustomizer() {
        this.setClassName(JUtils.getCurrentClassName());
        this.setMethodName(JUtils.getCurrentMethodName());
        return new MethodBreakpointPanel(this);
    }

    public String getDisplayName() {
        if (this.getAllMethods()) {
            return new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$MethodBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$MethodBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.MethodBreakpoint")) : class$org$netbeans$modules$debugger$jpda$MethodBreakpoint)).getString("CTL_All_method_event_name")).format(new Object[]{this.getClassName()});
        }
        return new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$MethodBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$MethodBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.MethodBreakpoint")) : class$org$netbeans$modules$debugger$jpda$MethodBreakpoint)).getString("CTL_Method_event_name")).format(new Object[]{this.getClassName(), this.getMethodName()});
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] parentActions = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new PrintAction(PrintAction.BREAKPOINT_METHOD_TEXT)};
            if (parentActions.length != 0) {
                CoreBreakpoint.Action[] myActions = this.actions;
                this.actions = new CoreBreakpoint.Action[parentActions.length + myActions.length];
                System.arraycopy(parentActions, 0, this.actions, 0, parentActions.length);
                System.arraycopy(myActions, 0, this.actions, parentActions.length, myActions.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        return debugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointMethodJPDA");
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        if (!this.condition.trim().equals("")) {
            JPDADebugger debugger = (JPDADebugger)this.getDebugger();
            JPDAWatch watch = new JPDAWatch(debugger, true);
            watch.setVariableName(this.condition);
            watch.refreshValue((JPDAThread)this.getThread());
            String type = watch.getType();
            String value = watch.getAsText();
            if (type != null && type.equals("boolean") && value != null && value.equals("false")) {
                this.stop(false);
                return;
            }
            if (type == null || !type.equals("boolean")) {
                ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$LineBreakpoint == null ? (class$org$netbeans$modules$debugger$jpda$LineBreakpoint = MethodBreakpoint.class$("org.netbeans.modules.debugger.jpda.LineBreakpoint")) : class$org$netbeans$modules$debugger$jpda$LineBreakpoint));
                debugger.getIOManager().println(bundle.getString("CTL_Incorrect_condition") + ": " + bundle.getString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
    }

    public void exec(Event event) {
        boolean isClassPrepareEvent = event instanceof ClassPrepareEvent;
        boolean isBreakpointEvent = event instanceof BreakpointEvent;
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        if (!isBreakpointEvent) {
            boolean ignore;
            if (isClassPrepareEvent) {
                this.tryClass = ((ClassPrepareEvent)event).referenceType();
            } else {
                Method method = event instanceof MethodEntryEvent ? ((MethodEntryEvent)event).method() : ((MethodExitEvent)event).method();
                this.tryClass = method.declaringType();
            }
            String tryClassName = this.tryClass.name();
            if (tryClassName.equals(this.getClassName())) {
                ignore = false;
            } else if (!this.getApplyToAnonymousInnerClasses()) {
                ignore = true;
            } else {
                String mandatoryPrefix = this.getClassName() + '$';
                boolean bl = ignore = !tryClassName.startsWith(mandatoryPrefix) || Character.isJavaIdentifierStart(tryClassName.charAt(mandatoryPrefix.length()));
            }
            if (ignore) {
                debugger.getStepManager().resumeOperator();
                return;
            }
        }
        if (isClassPrepareEvent) {
            boolean v = this.set(this.tryClass);
            if (v && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            debugger.getStepManager().resumeOperator();
        } else {
            this.thread = ((LocatableEvent)event).thread();
            if (debugger.virtualMachine.canGetSyntheticAttribute()) {
                try {
                    if (this.thread.frame(0).location().method().isSynthetic()) {
                        debugger.getStepManager().resumeOperator();
                        return;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.perform();
        }
    }

    public void stop(boolean stop) {
        ((JPDADebugger)this.getDebugger()).stop(stop, (JPDAThread)this.getThread());
    }

    public boolean getAllMethods() {
        return this.allMethods;
    }

    public void setAllMethods(boolean all) {
        if (this.allMethods == all) {
            return;
        }
        boolean old = this.allMethods;
        this.allMethods = all;
        this.firePropertyChange(PROP_ALL_METHODS, old ? Boolean.TRUE : Boolean.FALSE, this.allMethods ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getMethodEntry() {
        return this.methodEntry;
    }

    public void setMethodEntry(boolean methodEntry) {
        if (this.methodEntry == methodEntry) {
            return;
        }
        boolean old = this.methodEntry;
        this.methodEntry = methodEntry;
        this.firePropertyChange(PROP_ALL_METHODS, old ? Boolean.TRUE : Boolean.FALSE, methodEntry ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean set(ReferenceType clazz) {
        return this.set(clazz, true);
    }

    protected boolean set(ReferenceType clazz, boolean checkDuplicity) {
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        if (!(this.getAllMethods() || this.getMethodName() != null && this.getMethodName().trim().length() >= 1)) {
            return false;
        }
        if (checkDuplicity) {
            MethodBreakpoint methodBreakpoint = this;
            synchronized (methodBreakpoint) {
                if (this.refTypesWithBreakpoint == null) {
                    this.refTypesWithBreakpoint = new HashSet(17);
                } else {
                    try {
                        if (this.refTypesWithBreakpoint.contains(clazz)) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (ObjectCollectedException ex) {
                        // empty catch block
                    }
                }
                this.refTypesWithBreakpoint.add(clazz);
            }
        }
        String stopMethod = this.getMethodName();
        try {
            List<Method> methods = clazz.methods();
            boolean ok = false;
            int jj = methods.size();
            int j = 0;
            while (j < jj) {
                Location loc;
                Method method = methods.get(j);
                if (method.name().equals(stopMethod) && (loc = method.location()) != null) {
                    BreakpointRequest br = debugger.getRequestManager().createBreakpointRequest(loc);
                    br.setSuspendPolicy(2);
                    this.requestor.add(br);
                    br.enable();
                    ok = true;
                }
                ++j;
            }
            return ok;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "JPDAMethodBreakpoint " + this.getClassName() + "." + this.getMethodName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

