/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class PopFramesActionImpl {
    private final JPDADebugger session;
    private final Method popFramesMethod;
    static /* synthetic */ Class class$com$sun$jdi$StackFrame;
    static /* synthetic */ Class class$com$sun$jdi$ThreadReference;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDADebugger;

    public PopFramesActionImpl(JPDADebugger session) throws NoSuchMethodException {
        this.session = session;
        this.popFramesMethod = (class$com$sun$jdi$ThreadReference == null ? (class$com$sun$jdi$ThreadReference = PopFramesActionImpl.class$("com.sun.jdi.ThreadReference")) : class$com$sun$jdi$ThreadReference).getMethod("popFrames", class$com$sun$jdi$StackFrame == null ? (class$com$sun$jdi$StackFrame = PopFramesActionImpl.class$("com.sun.jdi.StackFrame")) : class$com$sun$jdi$StackFrame);
    }

    void popFrames(JPDAThread thread, int frameIndex) throws NativeMethodException, IncompatibleThreadStateException {
        if (this.popFramesMethod == null) {
            throw new UnsupportedOperationException("popFramesMethod = null");
        }
        ThreadReference jdiThread = thread.getThreadReference();
        try {
            int oldFrameCount = jdiThread.frameCount();
            int targetFrameCount = oldFrameCount - (frameIndex + 1);
            StackFrame jdiFrame = jdiThread.frame(frameIndex);
            this.popFramesMethod.invoke((Object)jdiThread, jdiFrame);
            int newFrameCount = jdiThread.frameCount();
            while (newFrameCount != targetFrameCount) {
                oldFrameCount = newFrameCount;
                int newFrameIndex = oldFrameCount - targetFrameCount - 1;
                jdiFrame = jdiThread.frame(newFrameIndex);
                this.popFramesMethod.invoke((Object)jdiThread, jdiFrame);
                newFrameCount = jdiThread.frameCount();
            }
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable exc = ex.getTargetException();
            if (exc instanceof NativeMethodException) {
                throw (NativeMethodException)exc;
            }
            if (exc instanceof InvalidStackFrameException) {
                throw (InvalidStackFrameException)exc;
            }
            ErrorManager.getDefault().notify(4096, exc);
        }
    }

    void popTopmostFrame() {
        try {
            this.popFrames(this.session.currentThread, 0);
            this.session.currentThread.refreshStack();
            this.session.currentThread.updateAnnotationsAndDisplayLocation();
            this.session.updateStoppedState();
        }
        catch (NativeMethodException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = PopFramesActionImpl.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger), (String)"MSG_Cannot_pop_native_frames")));
        }
        catch (InvalidStackFrameException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$modules$debugger$jpda$JPDADebugger = PopFramesActionImpl.class$("org.netbeans.modules.debugger.jpda.JPDADebugger")) : class$org$netbeans$modules$debugger$jpda$JPDADebugger), (String)"MSG_Cannot_pop_native_frames")));
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

