/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.DebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDADebuggerModule;

public class RemoteDebuggerInfo
extends AbstractDebuggerInfo {
    private Map args;
    private AttachingConnector connector;

    public RemoteDebuggerInfo(AttachingConnector connector, Map args) {
        super(null, new String[0]);
        this.args = args;
        this.connector = connector;
    }

    public RemoteDebuggerInfo(String hostName, int port) {
        super(null, new String[0]);
        Iterator<AttachingConnector> iter = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        this.connector = null;
        while (iter.hasNext()) {
            AttachingConnector ac = iter.next();
            if (ac.transport().name().toLowerCase().indexOf("socket") <= -1) continue;
            this.connector = ac;
            break;
        }
        if (this.connector != null) {
            this.args = this.connector.defaultArguments();
            ((Connector.Argument)this.args.get("hostname")).setValue(hostName);
            ((Connector.Argument)this.args.get("port")).setValue(String.valueOf(port));
        }
    }

    public RemoteDebuggerInfo(String hostName, String address) {
        super(null, new String[0]);
        Iterator<AttachingConnector> iter = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        this.connector = null;
        while (iter.hasNext()) {
            AttachingConnector ac = iter.next();
            if (ac.transport().name().toLowerCase().indexOf("shmem") <= -1) continue;
            this.connector = ac;
            break;
        }
        if (this.connector != null) {
            this.args = this.connector.defaultArguments();
            ((Connector.Argument)this.args.get("name")).setValue(address);
        }
    }

    public RemoteDebuggerInfo(String address) {
        super(null, new String[0]);
        Iterator<AttachingConnector> iter = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        this.connector = null;
        while (iter.hasNext()) {
            AttachingConnector ac = iter.next();
            if (ac.transport().name().toLowerCase().indexOf("shmem") <= -1) continue;
            this.connector = ac;
            break;
        }
        if (this.connector != null) {
            this.args = this.connector.defaultArguments();
            ((Connector.Argument)this.args.get("name")).setValue(address);
        }
    }

    public AttachingConnector getConnector() {
        return this.connector;
    }

    public Map getArgs() {
        return this.args;
    }

    public DebuggerImpl getDebuggerImpl() {
        return JPDADebuggerModule.getJPDADebuggerImpl();
    }

    public String getProcessName() {
        String name;
        if (this.args == null) {
            return "";
        }
        Connector.Argument arg = (Connector.Argument)this.args.get("port");
        if (arg != null) {
            name = this.getLocationName();
            String port = arg.value();
            if (port != null) {
                name = name + ':' + port;
            }
        } else {
            name = ((Connector.Argument)this.args.get("name")).value();
        }
        return name;
    }

    public String getLocationName() {
        if (this.args == null) {
            return "localhost";
        }
        Connector.Argument arg = (Connector.Argument)this.args.get("hostname");
        if (arg == null) {
            return "localhost";
        }
        String name = arg.value();
        if (name == null) {
            return "localhost";
        }
        int i = name.indexOf(46);
        if (i > 0) {
            try {
                int j = Integer.parseInt(name.substring(0, i));
            }
            catch (NumberFormatException e) {
                return name.substring(0, i);
            }
        }
        return name;
    }
}

