/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.lang.reflect.Modifier;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class StaticField
extends JPDAVariable {
    private ReferenceType parentClass;
    private Field field;

    StaticField(JPDADebugger debugger, ReferenceType parentClass, Field field) {
        super(debugger, true);
        this.name = field.name();
        this.field = field;
        this.parentClass = parentClass;
        try {
            this.setRemoteValue(parentClass.getValue(field));
            this.modifiers = Modifier.toString(field.modifiers());
            this.type = field.typeName();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.update();
    }

    public void validate() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                return;
            }
            if (this.isCloned) {
                if (this.isObject) {
                    this.value = this.debugger.getValue(this.remoteValue);
                }
            } else {
                try {
                    this.setRemoteValue(this.parentClass.getValue(this.field));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.update();
            }
            this.firePropertyChange();
        }
    }

    protected boolean setValue(final Value v) {
        if (!(this.parentClass instanceof ClassType)) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        try {
            new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    ((ClassType)StaticField.this.parentClass).setValue(StaticField.this.field, v);
                    return null;
                }
            }.throwAndWait(null);
        }
        catch (InvalidTypeException e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

