/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.StepRequest;
import java.util.LinkedList;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.modules.debugger.support.java.ActionTIPanel;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaDebuggerSettings;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.text.Line;
import org.openide.util.SharedClassObject;

public class StepManager
implements Executor {
    private JPDADebugger debugger;
    private EventRequestManager requestManager = null;
    private Operator operator;
    private EventRequest stepRequest;
    private MethodEntryRequest smartSteppingER;
    private int smartSteppingCounter = 0;
    private long smartSteppingStart = 0L;
    private CoreBreakpoint runToCursorBreakpoint;
    private static int smartSteppingTimeout = 0;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings;

    StepManager(JPDADebugger debugger, EventRequestManager requestManager, Operator operator) {
        this.debugger = debugger;
        this.requestManager = requestManager;
        this.operator = operator;
    }

    public EventRequestManager getRequestManager() {
        return this.requestManager;
    }

    public Operator getOperator() {
        return this.operator;
    }

    void destroy() {
        if (this.stepRequest != null) {
            this.operator.unregister(this.stepRequest);
        }
        this.operator.destroy();
        this.removeStepRequest();
        if (this.requestManager != null) {
            try {
                this.requestManager.deleteAllBreakpoints();
            }
            catch (VMDisconnectedException e) {
            }
            catch (InternalException internalException) {
                // empty catch block
            }
        }
        this.requestManager = null;
        this.debugger = null;
        this.stepRequest = null;
        this.smartSteppingER = null;
        this.runToCursorBreakpoint = null;
    }

    public void stepInto() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            this.stepInto(((JPDAThread)this.debugger.getCurrentThread()).getThreadReference());
            this.debugger.resume();
        }
    }

    public void stepInto(ThreadReference t) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                StepRequest request = this.requestManager.createStepRequest(t, -2, 1);
                request.addCountFilter(1);
                this.setRequest(request);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void stepOut() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            this.stepOut(((JPDAThread)this.debugger.getCurrentThread()).getThreadReference());
            this.debugger.resume();
        }
    }

    public void stepOut(ThreadReference t) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                StepRequest request = this.requestManager.createStepRequest(t, -2, 3);
                request.addCountFilter(1);
                this.setRequest(request);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void stepOver() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            this.stepOver(((JPDAThread)this.debugger.getCurrentThread()).getThreadReference());
            this.debugger.resume();
        }
    }

    public void stepOver(ThreadReference t) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                StepRequest request = this.requestManager.createStepRequest(t, -2, 2);
                request.addCountFilter(1);
                this.setRequest(request);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void go() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                this.debugger.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void runToCursor(Line l) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            try {
                this.removeStepRequest();
                CoreDebugger cDebugger = Register.getCoreDebugger();
                this.runToCursorBreakpoint = (CoreBreakpoint)cDebugger.createBreakpoint(l, true);
                CoreBreakpoint.Action[] actions = this.runToCursorBreakpoint.getActions();
                int ii = actions.length;
                int i = 0;
                while (i < ii) {
                    if (actions[i] instanceof PrintAction) {
                        ((PrintAction)actions[i]).setPrintText(PrintAction.RUN_TO_CURSOR_TEXT);
                    }
                    ++i;
                }
                this.debugger.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void setRequest(EventRequest r) {
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("  StepManager.setRequest " + r);
        }
        this.operator.register(r, this);
        this.stepRequest = r;
        r.setSuspendPolicy(2);
        r.enable();
    }

    public void removeStepRequest() {
        try {
            if (this.runToCursorBreakpoint != null) {
                this.runToCursorBreakpoint.remove();
                this.runToCursorBreakpoint = null;
            }
            if (this.stepRequest != null) {
                if (System.getProperty("netbeans.debug.step") != null) {
                    System.err.println("  StepManager.removeRequest " + this.stepRequest);
                }
                this.requestManager.deleteEventRequest(this.stepRequest);
                this.operator.unregister(this.stepRequest);
                this.stepRequest = null;
            }
        }
        catch (VMDisconnectedException e) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public void stop() {
        this.removeStepRequest();
        this.operator.stopRequest();
    }

    void resumeOperator() {
        this.operator.resume();
    }

    public void createMERequest(ThreadReference thread) {
        this.smartSteppingER = this.requestManager.createMethodEntryRequest();
        this.smartSteppingER.addThreadFilter(thread);
        this.smartSteppingCounter = 1;
        this.smartSteppingStart = System.currentTimeMillis();
        this.operator.register(this.smartSteppingER, this);
        this.smartSteppingER.setSuspendPolicy(2);
        this.smartSteppingER.enable();
    }

    public synchronized void exec(Event ev) {
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("exec start " + ev);
        }
        LocatableEvent event = (LocatableEvent)ev;
        ThreadReference tr = event.thread();
        Location loc = event.location();
        int ln = -1;
        String methodName = "?";
        String className = "?";
        String lineNumber = "?";
        String threadName = tr.name();
        String sourceName = null;
        boolean noInformation = false;
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("  exec start1 " + tr.isSuspended());
        }
        try {
            sourceName = loc.sourceName();
        }
        catch (AbsentInformationException e) {
            noInformation = true;
        }
        if (loc != null) {
            if (loc.method() != null) {
                methodName = loc.method().name();
            }
            className = loc.declaringType().name();
            ln = loc.lineNumber();
            if (ln >= 0) {
                lineNumber = "" + ln;
            }
        }
        Line l = null;
        if (ln != -1) {
            l = sourceName != null ? JUtils.getLineForSource((String)className, (String)sourceName, (int)ln) : JUtils.getLine((String)className, (int)ln);
        }
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("  exec - l " + l);
        }
        if (l != null && !this.debugger.canBeCurrent(l, false)) {
            this.stepOver(tr);
            this.resumeOperator();
            if (System.getProperty("netbeans.debug.step") != null) {
                System.err.println("  exec - end can not be current");
            }
            return;
        }
        if (l == null) {
            if (this.smartSteppingER != null) {
                if (className != null && className.length() > 1) {
                    this.smartSteppingER.disable();
                    this.smartSteppingER.addClassExclusionFilter(className);
                    this.smartSteppingER.enable();
                }
                this.operator.resume();
                long le = System.currentTimeMillis() - this.smartSteppingStart;
                if (this.smartSteppingCounter >= smartSteppingTimeout || le > (long)smartSteppingTimeout) {
                    if (System.getProperty("netbeans.debug.smartSteppingInfo") != null) {
                        System.out.println("  smartstepping unsuccessful!!!");
                        System.out.println("  time " + le);
                        System.out.println("  steps count " + this.smartSteppingCounter);
                    }
                    if (this.smartSteppingER != null) {
                        this.requestManager.deleteEventRequest(this.smartSteppingER);
                        this.operator.unregister(this.smartSteppingER);
                        this.smartSteppingER = null;
                        this.smartSteppingCounter = 0;
                    }
                    return;
                }
                ++this.smartSteppingCounter;
                return;
            }
            this.stepIntoNoSource(className, methodName, lineNumber, tr, l, threadName, noInformation);
            return;
        }
        if (this.smartSteppingER != null) {
            if (System.getProperty("netbeans.debug.smartSteppingInfo") != null) {
                System.out.println("  smart stepping successfull!");
            }
            this.smartSteppingCounter = 0;
            this.requestManager.deleteEventRequest(this.smartSteppingER);
            this.operator.unregister(this.smartSteppingER);
            this.smartSteppingER = null;
        }
        this.debugger.makeCurrent(threadName, className, methodName, lineNumber, l != null, noInformation, tr, l);
        this.operator.stopRequest();
        if (System.getProperty("netbeans.debug.step") != null) {
            System.err.println("exec end");
            System.err.println("");
        }
    }

    private void stepIntoNoSource(final String className, final String methodName, final String lineNumber, final ThreadReference tr, final Line l, final String threadName, final boolean noInformation) {
        new Thread(new Runnable(){

            public void run() {
                int o = StepManager.getActionOnTraceInto(className, methodName, lineNumber);
                JPDADebugger jPDADebugger = StepManager.this.debugger;
                synchronized (jPDADebugger) {
                    StepManager.this.debugger;
                    if (o == JPDADebugger.ACTION_ON_TI_FIND) {
                        int n = StepManager.this.debugger.getLastAction();
                        StepManager.this.debugger;
                        if (n == 3) {
                            StepManager.this.stepOut(tr);
                        }
                        StepManager.this.createMERequest(tr);
                        StepManager.this.debugger.resume();
                        return;
                    }
                    if (o == JavaDebuggerSettings.ACTION_ON_TI_TRACE_OUT) {
                        StepManager.this.stepOut(tr);
                        StepManager.this.debugger.resume();
                        return;
                    }
                    StepManager.this.debugger.makeCurrent(threadName, className, methodName, lineNumber, l != null, noInformation, tr, l);
                }
            }
        }, "stepIntoNoSource thread").start();
    }

    private static int getActionOnTraceInto(String className, String methodName, String lineNumber) {
        JavaDebuggerSettings debuggerSettings = (JavaDebuggerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings = StepManager.class$("org.netbeans.modules.debugger.support.java.JavaDebuggerSettings")) : class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings), (boolean)true);
        if (debuggerSettings.isActionOnTraceIntoSet()) {
            ActionTIPanel ap = new ActionTIPanel(className, methodName, lineNumber);
            NotifyDescriptor.Confirmation mess = new NotifyDescriptor.Confirmation((Object)ap, -1);
            Object o = DialogDisplayer.getDefault().notify((NotifyDescriptor)mess);
            if (o.equals(NotifyDescriptor.OK_OPTION)) {
                ap.updateSettings();
            }
        }
        return debuggerSettings.getActionOnTraceInto();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String o = System.getProperty("netbeans.debug.smartSteppingTimeout");
        smartSteppingTimeout = o != null ? Integer.parseInt(o) : 2500;
    }

    public class Requestor {
        private LinkedList requests = new LinkedList();
        private Executor listener;

        public Requestor(Executor listener) {
            this.listener = listener;
        }

        public int size() {
            return this.requests.size();
        }

        public void add(EventRequest r) {
            this.requests.add(r);
            StepManager.this.operator.register(r, this.listener);
        }

        public void removeRequests() {
            if (this.requests.size() == 0) {
                return;
            }
            int k = this.requests.size();
            try {
                int i = 0;
                while (i < k) {
                    EventRequest r = (EventRequest)this.requests.get(i);
                    if (StepManager.this.requestManager != null) {
                        StepManager.this.requestManager.deleteEventRequest(r);
                    }
                    StepManager.this.operator.unregister(r);
                    ++i;
                }
            }
            catch (VMDisconnectedException e) {
            }
            catch (InternalException e) {
                // empty catch block
            }
            this.requests = new LinkedList();
        }
    }
}

