/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.debugger.jpda.InstanceField;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAFilter;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.StaticField;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;

public class SuperVariable
extends JPDAVariable
implements JavaVariable.Super {
    private ObjectReference parentValue;
    private ClassType clsRef;
    private HashMap oldVariables = new HashMap();
    private JavaVariable[] oldVariableF;

    SuperVariable(JPDADebugger debugger, ObjectReference parentValue, ClassType clsRef) {
        super(debugger, true);
        this.parentValue = parentValue;
        this.clsRef = clsRef;
        this.name = "super";
        this.type = clsRef.name();
        this.setRemoteValue(null);
        this.modifiers = "";
        this.update();
    }

    public void setAsText(String value) {
    }

    public void validate() {
        this.firePropertyChange();
    }

    protected boolean setValue(Value v) {
        return false;
    }

    public boolean isLeaf() {
        return false;
    }

    public JavaVariable[] filterVariables(ModifiersFilter jf, int startindex, int numberofitems) {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                if (this.oldVariableF != null) {
                    JavaVariable[] javaVariableArray = this.oldVariableF;
                    return javaVariableArray;
                }
                JavaVariable[] javaVariableArray = new JavaVariable[]{};
                return javaVariableArray;
            }
            try {
                HashMap<Comparable<Field>, JPDAVariable> newVariables = new HashMap<Comparable<Field>, JPDAVariable>();
                List<Field> fields = jf != null && !jf.isInherited() ? this.clsRef.fields() : this.clsRef.allFields();
                int k = fields.size();
                ArrayList<JPDAVariable> list = new ArrayList<JPDAVariable>(k);
                int i = 0;
                while (i < k) {
                    Field field = fields.get(i);
                    if ((jf == null || JPDAFilter.filter(field, jf)) && (this.parentValue != null || field.isStatic())) {
                        JPDAVariable var = (JPDAVariable)this.oldVariables.get(field);
                        if (var == null) {
                            var = this.parentValue != null ? new InstanceField(this.debugger, this.parentValue, field) : new StaticField(this.debugger, this.clsRef, field);
                        } else if (JPDAVariable.ON_LINE) {
                            var.validate();
                        }
                        newVariables.put(field, var);
                        list.add(var);
                    }
                    ++i;
                }
                ClassType superRef = this.clsRef.superclass();
                if (superRef != null && jf != null && !jf.isInherited()) {
                    JPDAVariable superVar = (JPDAVariable)this.oldVariables.get(superRef);
                    if (superVar == null) {
                        superVar = new SuperVariable(this.debugger, this.parentValue, superRef);
                    }
                    list.add(superVar);
                    newVariables.put(superRef, superVar);
                }
                JavaVariable[] variable = new JPDAVariable[list.size()];
                variable = list.toArray(variable);
                this.oldVariables = newVariables;
                this.oldVariableF = variable;
                JavaVariable[] javaVariableArray = variable;
                return javaVariableArray;
            }
            catch (Exception e) {
                this.oldVariables = new HashMap();
                JavaVariable[] javaVariableArray = new JPDAVariable[]{};
                return javaVariableArray;
            }
        }
    }
}

