/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAVariable;

public class ThisLocalVariable
extends JPDAVariable {
    private ThreadReference thread = null;
    private int callStackIndex;

    ThisLocalVariable(JPDADebugger debugger, ThreadReference thread, int callStackIndex) {
        super(debugger, true);
        this.thread = thread;
        this.callStackIndex = callStackIndex;
        try {
            ObjectReference or = thread.frame(callStackIndex).thisObject();
            this.name = "this";
            this.type = or.type().name();
            this.setRemoteValue(or);
        }
        catch (IncompatibleThreadStateException e) {
        }
        catch (InvalidStackFrameException e) {
            // empty catch block
        }
        this.modifiers = "";
        this.update();
    }

    public void validate() {
        JPDADebugger jPDADebugger = this.debugger;
        synchronized (jPDADebugger) {
            if (this.debugger.getState() != 4) {
                return;
            }
            if (this.isCloned) {
                if (this.isObject) {
                    this.value = this.debugger.getValue(this.remoteValue);
                }
            } else {
                try {
                    ObjectReference or = this.thread.frame(this.callStackIndex).thisObject();
                    this.setRemoteValue(or);
                    this.type = or.type().name();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.update();
            }
            this.firePropertyChange();
        }
    }

    protected boolean setValue(Value v) {
        JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
        return false;
    }
}

