/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.ThreadBreakpointPanel;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ThreadBreakpoint
extends CoreBreakpoint.Event
implements Executor,
StopEvent,
InfoProducer,
CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = -5603544771083816554L;
    public static final String PROP_TYPE = "type";
    public static final int TYPE_START = 1;
    public static final int TYPE_DEATH = 2;
    public static final String TYPE_NAME = "java-thread";
    private transient ThreadReference thread;
    private StepManager.Requestor requestor;
    private int type = 1;
    private transient String action;
    private transient CoreBreakpoint.Action[] actions;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebugger;

    public boolean set() {
        Debugger d = this.getDebugger();
        if (!(d instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)d;
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = debugger.getStepManager().new StepManager.Requestor(this);
        }
        try {
            this.requestor.removeRequests();
            if ((this.type & 1) != 0) {
                ThreadStartRequest tsr = debugger.getRequestManager().createThreadStartRequest();
                tsr.setSuspendPolicy(2);
                this.requestor.add(tsr);
                tsr.enable();
            }
            if ((this.type & 2) != 0) {
                ThreadDeathRequest tdr = debugger.getRequestManager().createThreadDeathRequest();
                tdr.setSuspendPolicy(2);
                this.requestor.add(tdr);
                tdr.enable();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return true;
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{new PropertySupport.ReadWrite(PROP_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_breakpoint_type"), JPDADebugger.getLocString("HINT_breakpoint_type")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(ThreadBreakpoint.this.getType());
            }

            public void setValue(Object val) throws IllegalArgumentException {
                if (!(val instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                ThreadBreakpoint.this.setType((Integer)val);
            }

            public PropertyEditor getPropertyEditor() {
                return new TypeEditor();
            }
        }};
    }

    protected void perform() {
        super.perform();
        CoreBreakpoint.Action[] actions = this.getBreakpoint().getActions();
        int i = 0;
        while (i < actions.length) {
            if (actions[i] instanceof JavaStopAction) {
                ((JavaStopAction)actions[i]).performStopAction((CoreBreakpoint.Event)this);
            }
            ++i;
        }
    }

    public Line[] getLines() {
        return null;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Thread_event_type_name");
    }

    public String getCategoryDisplayName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebugger == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebugger = ThreadBreakpoint.class$("org.netbeans.modules.debugger.support.java.JavaDebugger")) : class$org$netbeans$modules$debugger$support$java$JavaDebugger), (String)"CTL_Java_breakpoint_events_cathegory_name");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointThreadJPDA");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return JPDADebugger.getLocString("CTL_Thread_start_event_name");
        }
        if (this.type == 2) {
            return JPDADebugger.getLocString("CTL_Thread_death_event_name");
        }
        return JPDADebugger.getLocString("CTL_Thread_event_name");
    }

    public String getIconBase() {
        return "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    }

    public JComponent getCustomizer() {
        return new ThreadBreakpointPanel(this);
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] parentActions = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new ThreadPrintAction()};
            if (parentActions.length != 0) {
                CoreBreakpoint.Action[] myActions = this.actions;
                this.actions = new CoreBreakpoint.Action[parentActions.length + myActions.length];
                System.arraycopy(parentActions, 0, this.actions, 0, parentActions.length);
                System.arraycopy(myActions, 0, this.actions, parentActions.length, myActions.length);
            }
        }
        return this.actions;
    }

    public JavaThread getThread() {
        if (this.thread == null) {
            return null;
        }
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        return debugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public void synchronizeWith(CoreBreakpoint.Event e) {
    }

    public void exec(Event event) {
        if (event instanceof ThreadStartEvent) {
            this.thread = ((ThreadStartEvent)event).thread();
            this.action = JPDADebugger.getLocString("CTL_Started");
        } else {
            this.thread = ((ThreadDeathEvent)event).thread();
            this.action = JPDADebugger.getLocString("CTL_Death");
        }
        this.perform();
    }

    public void stop(boolean stop) {
        ((JPDADebugger)this.getDebugger()).stop(stop, (JPDAThread)this.getThread());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type == this.type) {
            return;
        }
        if ((type & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.type;
        this.type = type;
        this.firePropertyChange(PROP_TYPE, new Integer(old), new Integer(type));
    }

    public String toString() {
        return "JPDAThreadBreakpoint " + this.getType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ThreadPrintAction
    extends PrintAction {
        static final long serialVersionUID = -5539254080847611623L;

        ThreadPrintAction() {
            super(JPDADebugger.getLocString("CTL_Thread_print_name"));
        }

        protected void resolveTag(String tag, CoreBreakpoint.Event event, StringBuffer sb) {
            if (tag.equals("action")) {
                sb.append(((ThreadBreakpoint)event).action);
            } else {
                super.resolveTag(tag, event, sb);
            }
        }
    }

    static class TypeEditor
    extends PropertyEditorSupport {
        private static final int[] values = new int[]{1, 2, 3};
        private static final String[] tags = new String[]{JPDADebugger.getLocString("CTL_Property_type_start_name"), JPDADebugger.getLocString("CTL_Property_type_death_name"), JPDADebugger.getLocString("CTL_Property_type_both_name")};

        TypeEditor() {
        }

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            int v = (Integer)this.getValue();
            int i = 0;
            while (i < values.length) {
                if (v == values[i]) {
                    return tags[i];
                }
                ++i;
            }
            return "?";
        }

        public void setAsText(String t) {
            int i = 0;
            while (i < tags.length) {
                if (tags[i].equals(t)) {
                    this.setValue(new Integer(values[i]));
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException(t);
        }
    }
}

