/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.util.Executor;

class ThreadManager
implements Executor {
    private HashMap referenceToThread;
    private ArrayList threads = new ArrayList();
    private JPDADebugger debugger;
    private ThreadStartRequest req1;
    private ThreadDeathRequest req2;

    ThreadManager(JPDADebugger debugger) {
        this.referenceToThread = new HashMap();
        this.debugger = debugger;
        this.createHierarchy(debugger.virtualMachine.topLevelThreadGroups());
        this.req1 = debugger.getRequestManager().createThreadStartRequest();
        this.req1.setSuspendPolicy(2);
        debugger.getStepManager().getOperator().register(this.req1, this);
        this.req1.enable();
        this.req2 = debugger.getRequestManager().createThreadDeathRequest();
        this.req2.setSuspendPolicy(2);
        debugger.getStepManager().getOperator().register(this.req2, this);
        this.req2.enable();
    }

    public void exec(Event event) {
        if (event instanceof ThreadStartEvent) {
            try {
                this.addThread(((ThreadStartEvent)event).thread());
            }
            catch (ObjectCollectedException e) {
            }
            catch (VMDisconnectedException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.debugger.getStepManager().resumeOperator();
            return;
        }
        try {
            this.removeThread(((ThreadDeathEvent)event).thread());
        }
        catch (ObjectCollectedException e) {
        }
        catch (VMDisconnectedException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.debugger.getStepManager().resumeOperator();
    }

    public synchronized void finish() {
        if (this.referenceToThread == null) {
            return;
        }
        Iterator i = this.referenceToThread.values().iterator();
        this.debugger.threadGroup.removeAllD();
        while (i.hasNext()) {
            Object ttg = i.next();
            if (!(ttg instanceof JPDAThreadGroup)) continue;
            ((JPDAThreadGroup)((Object)ttg)).removeAllD();
        }
        this.referenceToThread = null;
        try {
            this.debugger.getRequestManager().deleteEventRequest(this.req1);
            this.debugger.getRequestManager().deleteEventRequest(this.req2);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.debugger.getStepManager().getOperator().register(this.req1, null);
        this.debugger.getStepManager().getOperator().register(this.req2, null);
        this.threads = null;
        this.debugger = null;
    }

    synchronized void createHierarchy(List l) {
        int k = l.size();
        int i = 0;
        while (i < k) {
            ThreadGroupReference tgr = (ThreadGroupReference)l.get(i);
            JPDAThreadGroup ttg = this.createThreadGroup(tgr, this.debugger.threadGroup);
            this.createHierarchy(tgr, ttg);
            ++i;
        }
    }

    synchronized JPDAThread findThread(ThreadReference tr) {
        return (JPDAThread)((Object)this.referenceToThread.get(tr));
    }

    JPDAThread getThread(ThreadReference tr) {
        JPDAThread t = this.findThread(tr);
        if (t != null) {
            return t;
        }
        return this.addThread(tr);
    }

    synchronized JPDAThreadGroup getThreadGroup(ThreadGroupReference tgr) {
        return (JPDAThreadGroup)((Object)this.referenceToThread.get(tgr));
    }

    void refreshThreads() {
        ArrayList l = (ArrayList)this.threads.clone();
        Iterator i = ((AbstractList)l).iterator();
        while (i.hasNext()) {
            JPDAThread t = (JPDAThread)((Object)i.next());
            t.refresh();
        }
    }

    void refreshStacks() {
        ArrayList l = (ArrayList)this.threads.clone();
        Iterator iter = ((AbstractList)l).iterator();
        while (iter.hasNext()) {
            JPDAThread t = (JPDAThread)((Object)iter.next());
            t.refreshStack();
        }
    }

    synchronized JPDAThread getAnyThread() {
        Iterator iter = this.referenceToThread.entrySet().iterator();
        while (iter.hasNext()) {
            Object o = iter.next().getValue();
            if (!(o instanceof JPDAThread)) continue;
            return (JPDAThread)((Object)o);
        }
        return null;
    }

    private synchronized void createHierarchy(ThreadGroupReference tgr, JPDAThreadGroup ttg) {
        List<ObjectReference> l = tgr.threadGroups();
        int k = l.size();
        int i = 0;
        while (i < k) {
            ThreadGroupReference ntgr = l.get(i);
            this.createHierarchy(ntgr, this.createThreadGroup(ntgr, ttg));
            ++i;
        }
        l = tgr.threads();
        k = l.size();
        i = 0;
        while (i < k) {
            this.createThread((ThreadReference)l.get(i), ttg);
            ++i;
        }
    }

    private synchronized JPDAThread addThread(ThreadReference tr) {
        JPDAThread tt = (JPDAThread)((Object)this.referenceToThread.get(tr));
        if (tt != null) {
            return tt;
        }
        try {
            return this.createThread(tr, this.createThreadGroup(tr.threadGroup()));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private synchronized JPDAThread removeThread(ThreadReference tr) {
        JPDAThreadGroup ttg = (JPDAThreadGroup)((Object)this.referenceToThread.get(tr.threadGroup()));
        if (ttg == null) {
            return null;
        }
        JPDAThread tt = (JPDAThread)((Object)this.referenceToThread.remove(tr));
        ((AbstractCollection)this.threads).remove((Object)tt);
        ttg.removeThread(tt);
        return tt;
    }

    private synchronized JPDAThreadGroup createThreadGroup(ThreadGroupReference tgr) {
        JPDAThreadGroup ttg = (JPDAThreadGroup)((Object)this.referenceToThread.get(tgr));
        if (ttg != null) {
            return ttg;
        }
        ThreadGroupReference ptgr = tgr.parent();
        JPDAThreadGroup pttg = this.createThreadGroup(ptgr);
        return this.createThreadGroup(tgr, pttg);
    }

    private synchronized JPDAThreadGroup createThreadGroup(ThreadGroupReference tgr, JPDAThreadGroup pttg) {
        JPDAThreadGroup ttg = new JPDAThreadGroup(pttg, tgr);
        this.referenceToThread.put(tgr, ttg);
        pttg.addThreadGroup(ttg);
        return ttg;
    }

    private synchronized JPDAThread createThread(ThreadReference tr, JPDAThreadGroup pttg) {
        JPDAThread tt = new JPDAThread(this.debugger, pttg, tr);
        this.referenceToThread.put(tr, tt);
        this.threads.add(tt);
        pttg.addThread(tt);
        return tt;
    }
}

