/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.InstanceField;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.StaticField;
import org.netbeans.modules.debugger.jpda.StepManager;
import org.netbeans.modules.debugger.jpda.VariableBreakpointPanel;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Utils;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.ClassBreakpointEvent;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.text.Line;
import org.openide.util.HelpCtx;

public class VariableBreakpoint
extends ClassBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = -2579587576443670523L;
    public static final String PROP_FIELD_NAME = "fieldName";
    public static final String PROP_FIELD = "field";
    public static final String PROP_TYPE = "type";
    public static final String PROP_CONDITION = "condition";
    public static final int ACCESS_TYPE = 0;
    public static final int MODIFICATION_TYPE = 1;
    public static final String TYPE_NAME = "java-field";
    private transient ThreadReference thread;
    private StepManager.Requestor requestor;
    private transient Field field;
    private String fieldName = "";
    private int type = 1;
    private transient JPDAVariable value;
    private transient String action;
    private String condition = "";
    private HashSet refTypesWithBreakpoint;
    private transient CoreBreakpoint.Action[] actions;
    static /* synthetic */ Class class$java$lang$String;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger d = this.getDebugger();
        if (!(d instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger debugger = (JPDADebugger)d;
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        if (this.getClassName() == null || this.getClassName().trim().length() < 1) {
            return false;
        }
        if (this.type == 0 && !debugger.virtualMachine.canWatchFieldAccess()) {
            return false;
        }
        if (this.type == 1 && !debugger.virtualMachine.canWatchFieldModification()) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = debugger.getStepManager().new StepManager.Requestor(this);
        }
        try {
            ReferenceType ref;
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            ClassPrepareRequest cpr = debugger.getRequestManager().createClassPrepareRequest();
            cpr.addClassFilter(this.getClassName() + '*');
            cpr.setSuspendPolicy(2);
            this.requestor.add(cpr);
            cpr.enable();
            List<ReferenceType> l = debugger.virtualMachine.classesByName(this.getClassName());
            if (l.size() == 0) {
                return false;
            }
            boolean set = false;
            ArrayList<ReferenceType> anonymousInner = new ArrayList<ReferenceType>();
            int i = 0;
            int iterCount = l.size();
            while (i < iterCount) {
                ref = l.get(i);
                if (this.set(ref)) {
                    set = true;
                }
                try {
                    anonymousInner.addAll(Utils.anonymousInnerClasses(ref.name(), ref.nestedTypes()));
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while (i < anonymousInner.size()) {
                ref = (ReferenceType)anonymousInner.get(i);
                if (this.set(ref)) {
                    set = true;
                }
                try {
                    anonymousInner.addAll(ref.nestedTypes());
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
                ++i;
            }
            return set;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = VariableBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"className", (String)JPDADebugger.getLocString("PROP_breakpoint_class_name"), (String)JPDADebugger.getLocString("HINT_breakpoint_class_name"), (String)"getClassName", (String)"setClassName"), org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = VariableBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_FIELD_NAME, (String)JPDADebugger.getLocString("PROP_breakpoint_field_name"), (String)JPDADebugger.getLocString("HINT_breakpoint_field_name"), (String)"getFieldName", (String)"setFieldName"), new PropertySupport.ReadWrite(PROP_TYPE, Integer.TYPE, JPDADebugger.getLocString("PROP_breakpoint_type_name"), JPDADebugger.getLocString("HINT_breakpoint_type_name")){

            public Object getValue() throws IllegalArgumentException {
                return new Integer(VariableBreakpoint.this.getType());
            }

            public void setValue(Object val) throws IllegalArgumentException {
                if (!(val instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                VariableBreakpoint.this.setType((Integer)val);
            }

            public PropertyEditor getPropertyEditor() {
                return new TypeEditor();
            }
        }, org.netbeans.modules.debugger.support.util.Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = VariableBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)JPDADebugger.getLocString("PROP_condition"), (String)JPDADebugger.getLocString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] parentActions = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new VariablePrintAction()};
            if (parentActions.length != 0) {
                CoreBreakpoint.Action[] myActions = this.actions;
                this.actions = new CoreBreakpoint.Action[parentActions.length + myActions.length];
                System.arraycopy(parentActions, 0, this.actions, 0, parentActions.length);
                System.arraycopy(myActions, 0, this.actions, parentActions.length, myActions.length);
            }
        }
        return this.actions;
    }

    public Line[] getLines() {
        return null;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JPDADebugger.getLocString("CTL_Variable_event_type_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType().equals(TYPE_NAME);
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return new MessageFormat(JPDADebugger.getLocString("CTL_Variable_modification_event_name")).format(new Object[]{this.getClassName(), this.getFieldName()});
        }
        return new MessageFormat(JPDADebugger.getLocString("CTL_Variable_access_event_name")).format(new Object[]{this.getClassName(), this.getFieldName()});
    }

    public String getIconBase() {
        return "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    }

    public JComponent getCustomizer() {
        this.setClassName(JUtils.getCurrentClassName());
        this.setFieldName(JUtils.getCurrentFieldName());
        return new VariableBreakpointPanel(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointFieldJPDA");
    }

    public JavaThread getThread() {
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        return debugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return this.value;
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            boolean v;
            boolean isDemanded;
            ReferenceType tryClass = ((ClassPrepareEvent)event).referenceType();
            String tryClassName = tryClass.name();
            if (tryClassName.equals(this.getClassName())) {
                isDemanded = true;
            } else {
                String mandatoryPrefix = this.getClassName() + '$';
                boolean bl = isDemanded = tryClassName.startsWith(mandatoryPrefix) && !Character.isJavaIdentifierStart(tryClassName.charAt(mandatoryPrefix.length()));
            }
            if (isDemanded && (v = this.set(tryClass)) && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            ((JPDADebugger)this.getDebugger()).getStepManager().resumeOperator();
            return;
        }
        this.thread = ((WatchpointEvent)event).thread();
        ObjectReference objectRef = ((WatchpointEvent)event).object();
        Field field = ((WatchpointEvent)event).field();
        this.value = objectRef != null ? new InstanceField((JPDADebugger)this.getDebugger(), objectRef, field) : new StaticField((JPDADebugger)this.getDebugger(), field.declaringType(), field);
        this.action = event instanceof AccessWatchpointEvent ? JPDADebugger.getLocString("CTL_Access") : JPDADebugger.getLocString("CTL_Modification");
        this.perform();
    }

    public void stop(boolean stop) {
        ((JPDADebugger)this.getDebugger()).stop(stop, (JPDAThread)this.getThread());
    }

    public void setClassName(String cn, boolean notifyUpdater) {
        if (cn == this.className || cn != null && this.className != null && this.className.equals(cn)) {
            return;
        }
        String old = this.className;
        this.className = cn;
        this.field = null;
        if (notifyUpdater) {
            this.updater.setClassName(this.className);
        }
        this.firePropertyChange("className", old, this.className);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == this.fieldName || name != null && this.fieldName != null && this.fieldName.equals(name)) {
            return;
        }
        String old = this.fieldName;
        this.fieldName = name;
        this.field = null;
        this.firePropertyChange(PROP_FIELD_NAME, old, this.fieldName);
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        if (this.field == field) {
            return;
        }
        Field old = field;
        this.field = field;
        this.firePropertyChange(PROP_FIELD, old, field);
        if (field == null) {
            return;
        }
        try {
            this.setClassName(field.declaringType().name());
            this.setFieldName(field.type().name());
        }
        catch (ObjectCollectedException e) {
        }
        catch (ClassNotLoadedException e) {
        }
        catch (VMDisconnectedException e) {
            // empty catch block
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (this.type == type) {
            return;
        }
        if (type != 1 && type != 0) {
            throw new IllegalArgumentException();
        }
        int old = this.type;
        this.type = type;
        this.firePropertyChange(PROP_TYPE, new Integer(old), new Integer(type));
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        if (!this.condition.trim().equals("")) {
            JPDADebugger debugger = (JPDADebugger)this.getDebugger();
            JPDAWatch watch = new JPDAWatch(debugger, true);
            watch.setVariableName(this.condition);
            watch.refreshValue((JPDAThread)this.getThread());
            String type = watch.getType();
            String value = watch.getAsText();
            if (type != null && type.equals("boolean") && value != null && value.equals("false")) {
                this.stop(false);
                return;
            }
            if (type == null || !type.equals("boolean")) {
                debugger.getIOManager().println(JPDADebugger.getLocString("CTL_Incorrect_condition") + ": " + JPDADebugger.getLocString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
    }

    public boolean set(ReferenceType clazz) {
        JPDADebugger debugger = (JPDADebugger)this.getDebugger();
        if (debugger.virtualMachine == null || debugger.isDisconnected()) {
            return false;
        }
        VariableBreakpoint variableBreakpoint = this;
        synchronized (variableBreakpoint) {
            if (this.refTypesWithBreakpoint == null) {
                this.refTypesWithBreakpoint = new HashSet(17);
            } else {
                try {
                    if (this.refTypesWithBreakpoint.contains(clazz)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (ObjectCollectedException ex) {
                    // empty catch block
                }
            }
            this.refTypesWithBreakpoint.add(clazz);
        }
        try {
            Field f = null;
            boolean ok = false;
            try {
                f = clazz.fieldByName(this.getFieldName());
            }
            catch (ClassNotPreparedException e) {
            }
            catch (ObjectCollectedException e) {
                // empty catch block
            }
            if (f == null) {
                return false;
            }
            if (this.type == 0) {
                AccessWatchpointRequest awr = debugger.getRequestManager().createAccessWatchpointRequest(f);
                awr.setSuspendPolicy(2);
                awr.addClassFilter("*");
                this.requestor.add(awr);
                awr.enable();
                ok = true;
            } else {
                ModificationWatchpointRequest mwr = debugger.getRequestManager().createModificationWatchpointRequest(f);
                mwr.setSuspendPolicy(2);
                mwr.addClassFilter("*");
                this.requestor.add(mwr);
                mwr.enable();
                ok = true;
            }
            return ok;
        }
        catch (VMDisconnectedException e) {
            return false;
        }
    }

    public String toString() {
        return "JPDAVariableBreakpoint " + this.getClassName() + "." + this.getFieldName() + "." + this.getType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TypeEditor
    extends PropertyEditorSupport {
        private static final int[] values = new int[]{0, 1};
        private static final String[] tags = new String[]{JPDADebugger.getLocString("CTL_Breakpoint_type_access_value"), JPDADebugger.getLocString("CTL_Breakpoint_type_modification_value")};

        TypeEditor() {
        }

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            int v = (Integer)this.getValue();
            int i = 0;
            while (i < values.length) {
                if (v == values[i]) {
                    return tags[i];
                }
                ++i;
            }
            return "?";
        }

        public void setAsText(String t) {
            int i = 0;
            while (i < tags.length) {
                if (tags[i].equals(t)) {
                    this.setValue(new Integer(values[i]));
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException(t);
        }
    }

    class VariablePrintAction
    extends PrintAction {
        static final long serialVersionUID = -3852634593799541249L;

        VariablePrintAction() {
            super(JPDADebugger.getLocString("CTL_Variable_print_name"));
        }

        protected void resolveTag(String tag, CoreBreakpoint.Event event, StringBuffer sb) {
            if (tag.equals("variableName")) {
                sb.append(((VariableBreakpoint)event).getFieldName());
            } else if (tag.equals("action")) {
                sb.append(((VariableBreakpoint)event).action);
            } else {
                super.resolveTag(tag, event, sb);
            }
        }
    }
}

