/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAVariable;
import org.netbeans.modules.debugger.jpda.ValueVariable;
import org.netbeans.modules.debugger.support.util.Protector;

public class WatchVariable
extends ValueVariable {
    WatchVariable(JPDADebugger debugger, boolean validate) {
        super(debugger, validate);
    }

    void update(String name, Value value, String type) {
        this.name = name;
        this.setRemoteValue(value);
        this.type = type;
        this.modifiers = "";
        this.update();
    }

    protected boolean setValue(final Value v) {
        StackFrame sf;
        JPDAThread t = (JPDAThread)this.debugger.getCurrentThread();
        if (t == null) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        ThreadReference tr = t.getThreadReference();
        try {
            sf = tr.frame(0);
        }
        catch (Exception e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        try {
            Object o = new Protector("JPDAVariable.ExpressionParser"){

                public Object protect() throws Exception {
                    LocalVariable localVariable = sf.visibleVariableByName(WatchVariable.this.getVariableName());
                    if (localVariable != null) {
                        sf.setValue(localVariable, v);
                    } else {
                        ObjectReference obj = sf.thisObject();
                        ReferenceType ref = obj != null ? obj.referenceType() : sf.location().declaringType();
                        Field field = ref.fieldByName(WatchVariable.this.getVariableName());
                        if (field != null) {
                            if (obj != null) {
                                obj.setValue(field, v);
                            } else {
                                ((ClassType)ref).setValue(field, v);
                            }
                        } else {
                            return ref;
                        }
                    }
                    return null;
                }
            }.throwAndWait(null);
            if (o != null) {
                JPDAVariable.notify(JPDAVariable.getString("EXC_Cannot_assign_to_expression"));
                return false;
            }
        }
        catch (InvalidTypeException e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Wrong_type"));
            return false;
        }
        catch (Exception e) {
            JPDAVariable.notify(JPDAVariable.getString("EXC_Value_cannt_be_set"));
            return false;
        }
        return true;
    }
}

